<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * http://ldapsaisie.labs.libre-entreprise.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/*
 ***************************************************
 * Données de configuration pour le support SUPANN *
 ***************************************************
 */

// Nom de l'attribut LDAP nom
$GLOBALS['LS_SUPANN_LASTNAME_ATTR'] = 'sn';

// Nom de l'attribut LDAP prenom
$GLOBALS['LS_SUPANN_FIRSTNAME_ATTR'] = 'givenName';

// Type de LSobject correspondant aux entites SUPANN
$GLOBALS['LS_SUPANN_LSOBJECT_ENTITE_TYPE'] = 'LSsupannEntite';

// Format d'affichage du nom courts d'une entites SUPANN
$GLOBALS['LS_SUPANN_LSOBJECT_ENTITE_FORMAT_SHORTNAME'] = '%{ou}';

// DN de l'entite SUPANN correspondant à l'etablissement
$GLOBALS['LS_SUPANN_ETABLISSEMENT_DN'] = 'supannCodeEntite=XXX,ou=structures,dc=univ,dc=fr';

// Type de LSobject correspondant aux entites SUPANN
// Exemple : 0753742K
$GLOBALS['LS_SUPANN_ETABLISSEMENT_UAI'] = '0753742K';

/*
 * Nomenclatures SUPANN
 *
 * Tableau stockant les nomenclautures utilisées.
 *
 * Doc SUPANN :
 *   https://services.renater.fr/documentation/supann/2009/documentcomplet#nomenclatures
 *
 * $GLOBALS['supannNomenclatures'] = array (
 *     '[ETIQUETTE]' => array (
 *         '[table1] => array (
 *             '[key1]' => '[label1],
 *             '[key2]' => '[label2],
 *             [...]
 *         )
 * 	   ),
 * );
 *
 * [ETIQUETTE] : l'étiquette de la valeur
 * [table] : le nom de la table :
 *   - roleGenerique : les rôles génériques
 *   - typeEntite : les types d'entités
 *   - empCorps : les corps d'appartenances des personnels
 *   - codeEtablissement : les codes d'établissement
 *   - etuRegimeInscription : les régimes d'inscription étudiant
 *   - etuSecteurDisciplinaire : les secteurs disciplinaires de dîplomes ou d'enseignements
 *   - etuTypeDiplome : les types de diplôme
 *   - etuDiplome : les diplômes
 *   - etuEtape : les étapes des enseignements
 *   - etuElementPedagogique : les éléments pédagogiques
 *
 */
$GLOBALS['supannNomenclatures'] = array (
	'SUPANN' => array (
		'roleGenerique' => array (
			"D00" => "MINISTRE",
			"D01" => "DIRECTEUR DU CABINET",
			"D02" => "DIRECTEUR ADJOINT DU CABINET",
			"D10" => "DIRECTEUR  AC",
			"D11" => "DELEGUE AC",
			"D12" => "DELEGUE REGIONAL A LA RECH. ET TECHN.",
			"D21" => "DIRECTEUR DE RECHERCHE",
			"D22" => "DIRECTEUR SCIENTIFIQUE",
			"D23" => "DIRECTEUR DE PROJET",
			"D30" => "Directeur",
			"D32" => "Directeur des études",
			"D34" => "Directeur de la Recherche",
			"D35" => "Doyen",
			"D40" => "SOUS-DIRECTEUR",
			"D60" => "DIRECTEUR DE DEPARTEMENT",
			"D70" => "DOYEN DE L'IGEN",
			"D71" => "DOYEN DE L'IGB",
			"D80" => "DIRECTEUR GENERAL AC",
			"D81" => "DIR GEN AC, SECRETAIRE GENERAL ADJOINT",
			"D90" => "HAUT FONCTIONNAIRE DE DEFENSE",
			"F01" => "CHEF DU CABINET",
			"F02" => "CHEF ADJOINT DU CABINET",
			"F10" => "CHEF DE SERVICE",
			"F11" => "CHEF DE SERVICE ADJOINT AU DIRECTEUR",
			"F12" => "CHEF DU SERVICE DE l'IGAENR",
			"F20" => "CHEF DE MISSION",
			"F21" => "CHEF DE LA MISSION",
			"F22" => "CHEF DE SERVICE ADJOINT AU DIR GEN",
			"F30" => "CHEF DE DIVISION",
			"F40" => "CHEF DE DEPARTEMENT",
			"F42" => "chef des services administratifs",
			"F50" => "CHEF DE CENTRE",
			"F60" => "CHEF DE BUREAU",
			"F61" => "CHEF DE CELLULE",
			"F62" => "CHEF DU CABINET DU SECRETAIRE GENERAL",
			"F70" => "CHEF D'EXPLOITATION",
			"F71" => "CHEF D'EQUIPE",
			"F73" => "CHEF DU SERVICE INTERIEUR",
			"F74" => "CHEF DE SECTION",
			"F75" => "CHEF DE SITE",
			"F76" => "CHEF DE CUISINE",
			"H10" => "CHARGE DU SERVICE",
			"H11" => "CHARGE DE SOUS-DIRECTION",
			"H20" => "CHARGE DE MISSION AUPRES DU MINISTRE",
			"H30" => "CHARGE DE MISSION AUPRES DU DIR CAB",
			"H40" => "CHARGE DE MISSION",
			"H70" => "CHARGE DU SECRETARIAT DU DIRECTEUR",
			"H75" => "CHARGE DU SECRETERIAT DU DRRT",
			"H80" => "CHARGE DE GESTION ADMINIS. ET COMPTABLE",
			"J01" => "ADJOINT AU CHEF DE CABINET",
			"J04" => "ADJOINT AU DIRECTEUR GENERAL AC",
			"J05" => "ADJOINT AU DIRECTEUR",
			"J06" => "ADJOINT AU DELEGUE AC",
			"J07" => "ADJOINT AU DRRT",
			"J10" => "ADJOINT AU CHEF DE SERVICE",
			"J11" => "ADJOINT AU CHARGE DU SERVICE",
			"J12" => "ADJOINT AU SOUS-DIRECTEUR",
			"J13" => "ADJOINT AU CHARGE DE SOUS-DIRECTION",
			"J20" => "ADJOINT AU CHEF DE MISSION",
			"J21" => "ADJOINT AU CHEF DE LA MISSION",
			"J30" => "ADJOINT AU CHEF DE DIVISION",
			"J31" => "ADJOINT AU CHEF DE DEPARTEMENT",
			"J32" => "ADJOINT AU DIRECTEUR DE DEPARTEMENT",
			"J33" => "ADJOINT AU CHEF DE CENTRE",
			"J34" => "ADJOINT AU CHEF DE BUREAU",
			"J35" => "A CHEF AU CHEF DE SECTION",
			"J36" => "ADJOINT AU CHEF DE CELLULE",
			"J40" => "ADJOINT AU RESPONSABLE DE CELLULE",
			"J41" => "ADJOINT AU RESPONSABLE DE L'UNITE",
			"J42" => "ADJOINT AU RESPONSABLE DE POLE",
			"J50" => "ADJOINT AU RESPONSABLE D'ATELIER",
			"J60" => "Directeur adjoint",
			"J61" => "Chef de service adjoint",
			"J62" => "Directeur des études adjoint",
			"J63" => "Directeur de la Recherche adjoint",
			"J63" => "Directeur scientifique adjoint",
			"M01" => "COLLABORATEUR EXTERIEUR",
			"N00" => "CONSEILLER AUPRES DU MINISTRE",
			"N01" => "CONSEILLER",
			"N02" => "CONSEILLER DU CABINET",
			"N03" => "CONSEILLER TECHNIQUE DU CABINET",
			"N10" => "CONSEILLER D'ETABLISSEMENTS",
			"N11" => "CONSEILLER PEDAGOGIQUE",
			"N20" => "CONSEILLER TECHNIQUE",
			"N50" => "COORDONNATEUR",
			"P00" => "PRESIDENT",
			"P01" => "PRESIDENT D'ASSOCIATION",
			"P10" => "VICE-PRESIDENT",
			"P50" => "SECRETAIRE GENERAL",
			"P51" => "Secrétaire Général adjoint",
			"P60" => "SECRETAIRE GENERAL AC",
			"P70" => "Administrateur",
			"P71" => "Administrateur provisoire",
			"R00" => "RESPONSABLE",
			"R01" => "RESPONSABLE DE CELLULE",
			"R02" => "RESPONSABLE DE DEPARTEMENT",
			"R10" => "RESPONSABLE DE MISSION",
			"R20" => "RESPONSABLE DE POLE",
			"R21" => "RESPONSABLE DE SECTEUR",
			"R22" => "RESPONSABLE D'UNITE",
			"R30" => "RESPONSABLE DE SERVICES TECHNIQUES",
			"R31" => "RESPONSABLE EPI",
			"R33" => "RESPONSABLE D'ATELIER",
			"R40" => "Responsable admnistratif",
			"R41" => "Responsable de diplôme",
			"R42" => "Responsable pédagogique",
			"R43" => "Responsable de programme",
			"R80" => "RESPONSABLE UGARH",
			"R81" => "ADJOINT(E) RESP UGARH",
			"S01" => "Encadrant Tuteur",
			"S10" => "Membre titulaire, Membre",
			"S11" => "Membre suppléant",
			"S12" => "Membre consultatif",
			"S13" => "Participant",
			"S14" => "Représentant      / Représentant étudiant",
			"S15" => "Délégué",
			"S16" => "Correspondant",
			"S17" => "Coordonnateur scientifique",
			"S20" => "Partenaire",
			"S21" => "Personnalité extérieure",
			"T01" => "ASSISTANT DE SERVICE SOCIAL",
			"T02" => "INFIRMIER",
			"T12" => "AMINISTRATEUR  DE DONNEES",
			"T13" => "HUISSIER",
			"T14" => "AGENT D'ACCUEIL",
			"T15" => "HOTESSE D'ACCUEIL",
			"T16" => "AGENT TECHNIQUE",
			"T17" => "CHARGE DE COM, REL PUBLIQUE OU PRESSE",
			"T18" => "ALLOCATAIRE D'EMPLOIS",
			"T19" => "ANALYSTE",
			"T22" => "ASSISTANT DE DIRECTION",
			"T24" => "ASSISTANT TECHNIQUE",
			"T25" => "CHARGE D'ETUDES",
			"T26" => "CHEF DE PROJET",
			"T27" => "CHEF DE PROJET INFORMATIQUE",
			"T29" => "CONCEPTEUR REDACTEUR SITE WEB",
			"T30" => "CONDUCTEUR AUTOMOBILE",
			"T31" => "CONSEILLER SCIENTIFIQUE ET  TECHNIQUE",
			"T32" => "CONTROLEUR  DE GESTION",
			"T34" => "CORRESPONDANT INFORMATIQUE",
			"T35" => "DEVELOPPEUR D'APPLICATIONS",
			"T36" => "DOCUMENTALISTE - ARCHIVISTE",
			"T37" => "GESTIONNAIRE",
			"T39" => "GESTIONNAIRE DE PARC INF & TELECOM",
			"T40" => "GESTIONNAIRE GRH",
			"T41" => "GESTIONNAIRE DE RESTAURANT ADMINISTRATIF",
			"T42" => "GESTIONNAIRE FINANCIER",
			"T43" => "INFOGRAPHISTE - MAQUETTISTE (PAO)",
			"T44" => "INFORMATICIEN BUREAUTIQUE",
			"T45" => "INFORMATICIEN D'EXPLOITATION",
			"T46" => "INFORMATICIEN SYSTEMES ET RESEAUX",
			"T47" => "INGENIEUR PEDAGOGIQUE OU EN FORM PROF",
			"T48" => "MECANICIEN",
			"T49" => "OPERATEUR",
			"T50" => "OUVRIER",
			"T51" => "AGENT DE PREMIERE INTERVENTION",
			"T52" => "PERSONNEL DE RESTAURATION",
			"T54" => "REDACTEUR",
			"T55" => "REPROGRAPHISTE",
			"T56" => "RESPONSABLE PRODUCTION ET SYSTEMES",
			"T57" => "SECRETAIRE",
			"T58" => "SECRETAIRE PARTICULIER",
			"T59" => "SECRETAIRE MEDICAL",
			"T60" => "CHARGE DE MARCHES PUBLICS",
			"T61" => "CHARGE DE  GESTION  FINANCIERE",
			"T62" => "CHARGE DE PROGRAMMATION BUDGETAIRE",
			"T63" => "TECHNICIEN CONSEIL HYGIENE ET SECURITE",
			"T64" => "TECHNICIEN EXPLOITATION- MAINTENANCE",
			"T65" => "AGENT COMPTABLE",
			"T66" => "GESTIONNAIRE D'ETABLISSEMENT",
			"T80" => "Maîtrise d'ouvrage des SI",
			"T81" => "Maîtrise' d'œuvre des SI",
			"T82" => "AQSSI",
			"T83" => "RSSI",
			"T84" => "CSSI (Correspondant/Chargé de SSI)",
			"X00" => "MEDIATEUR",
			"X01" => "MEDECIN",
			"X10" => "EXPERT PEDAGOGIQUE",
			"X11" => "EXPERT CREDIT IMPOT RECHERCHE",
			"X30" => "CHAUFFEUR UTILITAIRE",
			"X31" => "CHAUFFEUR DE MINISTRE",
			"X32" => "CHAUFFEUR DU CABINET",
			"X33" => "CHAUFFEUR DE DIRECTION",
			"X40" => "CONTROLEUR FINANCIER",
			"X50" => "JURISTE",
			"X51" => "Correspondant I&L",
			"X60" => "SECRETAIRE DE  CABINET",
			"X70" => "ACMO H&S",
			"X71" => "Chargé de service de prévention H&S",
			"X80" => "Assesseur"
		),
		'typeEntite' => array (
			"C000" => "Bureau du président",
			"C010" => "Groupement d'Intérêt Scientifique (GIS)",
			"C020" => "Aide à la conception de produits pédagogiques",
			"C021" => "Conception de dispositifs de formation ouverts et à distance",
			"C022" => "Coordination d'enseignement transversaux à plusieurs diplômes",
			"C023" => "Création et mise en place d'une nouvelle filière",
			"C030" => "Haut comité éducation économie",
			"C031" => "Organisation",
			"C032" => "Participation au développement et à l'animation de formations délocalisées",
			"C033" => "Participation aux activités de formation continue",
			"C034" => "Programmes pluriannuels de formation (PPF)",
			"C035" => "Organisation",
			"C050" => "Plateforme technologique",
			"E101" => "Conseil d'Administration (CA)",
			"E102" => "Section disciplinaire du CA",
			"E103" => "Conseil Scientifique (CS)",
			"E104" => "Conseil d'UFR",
			"E105" => "Conseil d'école",
			"E106" => "Conseil d'institut",
			"E107" => "Conseil des Etudes et Vie Universitaire (CEVU)",
			"E108" => "Conseil de service général universitaire",
			"E109" => "Conseil de service commun universitaire",
			"E201" => "Commission Paritaire Etablissement",
			"E202" => "Commision consultative paritaire",
			"E203" => "Commission de conseil",
			"E204" => "Commission des Moyens",
			"E205" => "Commission des Statuts ",
			"E206" => "Commission Administrative Paritaire",
			"E301" => "Comité Hygiène et Sécurité",
			"E302" => "Comité de Pilotage SGI",
			"E303" => "Comité Technique Paritaire ",
			"E304" => "Comité consultatif",
			"E305" => "Comité de sélection",
			"E306" => "Comité de Pilotage SGI",
			"E401" => "Jury",
			"E801" => "Conseil CROUS",
			"E901" => "CNESER (Conseil National de l'Ens. Sup. Rech.)",
			"E902" => "CNU Conseil National des Universités",
			"E903" => "CTPM Comité Tech. Par. Min. Ens. Sup. Rech.",
			"S101" => "Grand établissement",
			"S102" => "Université",
			"S103" => "Institut ",
			"S104" => "École ",
			"S105" => "ENS (Ecole Normale Supérieure)",
			"S106" => "PRES   (si celui-ci est de type EPSCP) sinon il faudra une catégorie N1-Autre",
			"S107" => "EFE (Ecole Française de l'Etranger)",
			"S108" => "Établissement public administratif rattaché",
			"S109" => "Observatoire   est-ce un EPSCP? Si oui il faut mettre N1-établissement",
			"S120" => "Pôle ",
			"S200" => "Composante",
			"S201" => "UFR",
			"S202" => "Département",
			"S203" => "Unité de recherche",
			"S204" => "Institut ",
			"S205" => "École",
			"S206" => "Centre polytechnique universitaire",
			"S207" => "OSU (Observatoire des Sciences de l'Univers)",
			"S208" => "IUFM",
			"S220" => "Structure fédérative de recherche",
			"S221" => "Collège des écoles doctorales",
			"S222" => "École doctorale",
			"S230" => "Service central",
			"S231" => "Service général ",
			"S233" => "Scolarité",
			"S234" => "Centre de ressources ",
			"S235" => "Cellule universitaire d'accueil",
			"S236" => "Cellule juridique",
			"S237" => "Cellule controle gestion",
			"S238" => "Centre",
			"S239" => "Service culturel et action sociale",
			"S240" => "Service des Relations Internationales",
			"S241" => "Service inter-universitaire ",
			"S250" => "SCD",
			"S251" => "Section-SCD",
			"S252" => "Formation permanente ",
			"S253" => "SCUIO",
			"S254" => "SAIC",
			"S255" => "Autres comme CEP, UEFAPS, …",
			"S256" => "Service technique",
			"S257" => "Catégorie prévue dans la loi / peut être appelé \"service-commun-rattaché\"",
			"S300" => "Cabinet",
			"S301" => "Coordination",
			"S302" => "Division",
			"S304" => "Mission",
			"S310" => "Laboratoire",
			"S311" => "Département de formation",
			"S312" => "Centre de recherche",
			"S330" => "Campus",
			"S340" => "Plate-forme de recherche ou plateau technique",
		)
	),
	'UAI' => array (
		'codeEtablissement' => array (
			"0133774G" => "Ecole Centrale de Marseille",
			"0840985P" => "Ecole de Gestion et de Commerce d'Avignon",
			"0130230E" => "ECOLE DE L'AIR",
			"0130239P" => "Ecole Supérieure de Commerce de Marseille du groupe EUROMED",
			"0132396J" => "ECOLE SUPERIEURE D'INGENIEURS DE MARSEILLE-CCIMP GROUPE ESIM IMT",
			"0133347T" => "Institut Supérieur de Micro-Electronique Appliquée Ecole Nationale Supérieure des Mines de St Etienne",
			"0130238N" => "Institut supérieur du Bâtiment et des Travaux Publics - CCIMP",
			"0133393T" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE D'AIX MARSEILLE",
			"0131842G" => "UNIVERSITE AIX MARSEILLE 1",
			"0131843H" => "UNIVERSITE AIX MARSEILLE 2",
			"0132364Z" => "UNIVERSITE AIX MARSEILLE 3 PAUL CEZANNE",
			"0840685N" => "UNIVERSITE D AVIGNON ET DES PAYS DE VAUCLUSE",
			"0801911T" => "ECOLE SUPERIEURE D'INGENIEURS EN ELECTROTECHNIQUE ET ELECTRONIQUE D'AMIENS",
			"0800080C" => "GROUPE SUP DE CO ECOLE SUPERIEURE DE COMMERCE",
			"0600071B" => "INSTITUT SUPERIEUR AGRICOLE DE BEAUVAIS",
			"0801885P" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE D'AMIENS",
			"0801344B" => "UNIVERSITE D'AMIENS",
			"0601223D" => "UNIVERSITE DE TECHNOLOGIE DE COMPIEGNE",
			"0701045F" => "ECOLE DE GESTION, DE COMMERCE DE FRANCHE COMTE",
			"0250082D" => "ECOLE NATIONALE SUPERIEURE DE MECANIQUE ET DES MICROTECHNIQUES DE BESANCON",
			"0900362E" => "ECOLE SUPERIEURE DES TECHN. ET DES AFFAIRES",
			"0251762E" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE BESANCON",
			"0251215K" => "UNIVERSITE DE BESANCON",
			"0900424X" => "UNIVERSITE DE TECHNOLOGIE DE BELFORT MONTBELIARD",
			"0332984P" => "CENT ETUD SUP INDUST BLANQUEFO",
			"0332818J" => "ECOLE COMMERCE EUROPEENNE GR INSEEC",
			"0641848L" => "ECOLE DE GESTION ET DE COMMERCE DE BAYONNE",
			"0330203S" => "ECOLE NATIONALE D'INGENIEURS DES TRAVAUX AGRICOLES DE BORDEAUX",
			"0330211A" => "ECOLE SUP DE COMMERCE DE BORDX GRPE BORDX ECOLE MANAGEMENT",
			"0640096G" => "ECOLE SUPERIEURE DE COMMERCE",
			"0641923T" => "ES TECH INDUS AVANCEES BAYONNE",
			"0332524P" => "I.N.S.E.E.C.",
			"0332826T" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE BORDEAUX",
			"0331764N" => "UNIVERSITE BORDEAUX 1 SCIENCES ET TECHNOLOGIES",
			"0331765P" => "UNIVERSITE BORDEAUX 2",
			"0331766R" => "UNIVERSITE BORDEAUX 3",
			"0332929E" => "UNIVERSITE BORDEAUX 4",
			"0640251A" => "UNIVERSITE DE PAU",
			"0501840D" => "ECOLE FORMATION GESTION COMM. EGC BASSE NORMANDIE",
			"0611136D" => "ECOLE INGENIEURS INSTITUT SUP DE PLASTURGIE",
			"0142124H" => "ECOLE MANAGEMENT DE NORMANDIE GROUPE LE HAVRE CAEN",
			"0142182W" => "ECOLE SUPERIEURE D INGENIEURS DES TRAVAUX DE LA CONSTRUCTION DE CAEN",
			"0142158V" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE CAEN",
			"0141408E" => "UNIVERSITE DE CAEN, BASSE NORMANDIE",
			"0631786Z" => "ECOLE NATIONALE D'INGENIEURS DES TRAVAUX AGRICOLES DE CLERMONT FERRAND",
			"0630109B" => "ECOLE SUPERIEURE DE COMMERCE",
			"0631833A" => "INSTITUT FRANÇAIS DE MECANIQUE AVANCEE DE CLERMONT-FERRAND",
			"0631821M" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE CLERMONT FERRAND",
			"0631262E" => "UNIVERSITE DE CLERMONT FERRAND 1",
			"0631525R" => "UNIVERSITE DE CLERMONT FERRAND 2",
			"7200709H" => "ECOLE GESTION ET COMMERCE BORGO",
			"7200164R" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE CORSE",
			"7200664J" => "UNIVERSITE DE CORTE",
			"0941934S" => "Ecole d'ingénieurs des technologies de l'information et du management",
			"0772517T" => "ECOLE NATIONALE DES PONTS ET CHAUSSEES",
			"0772496V" => "ECOLE NATIONALE DES SCIENCES GEOGRAPHIQUES",
			"0940607Z" => "Ecole Normale Superieure de Cachan",
			"0942095S" => "ECOLE POUR INFORMAT.TECHN.AVA. EPITA",
			"0941875C" => "ECOLE SUPERIEURE DES INDUSTRIES DU CAOUTCHOUC",
			"0941954N" => "ECOLE SUPERIEURE DES TRAVAUX DE LA CONSTRUCTION DE CACHAN (EX ECOLE SUPERIEURE DES TRAVAUX PUBLICS DE CACHAN)",
			"0932019P" => "ECOLE SUPERIEURE D'INGENIEURS EN ELECTROTECHNIQUE ET ELECTRONIQUE DE LA CCI DE PARIS",
			"0772219U" => "ESI INFORM GENIE TELECOM AVON ESIGETEL",
			"0932341P" => "INST SUPERIEUR TECHNO MANAGT ISTM",
			"0930603A" => "institut supérieur de mécanique de paris",
			"0941936U" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE CRETEIL",
			"0772502B" => "UNIVERSITE MARNE LA VALLEE",
			"0931238R" => "UNIVERSITE PARIS NORD VILLETANEUSE",
			"0941111X" => "UNIVERSITE PARIS 12 VAL DE MARNE",
			"0931827F" => "UNIVERSITE PARIS 8",
			"0212024L" => "ETABLISSEMENT NATIONAL D'ENSEIGNEMENT SUPERIEUR AGRONOMIQUE DE DIJON",
			"0210099U" => "GROUPE ESC DIJON BOURGOGNE",
			"0211960S" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE DIJON",
			"0211237F" => "UNIVERSITE DE DIJON",
			"0261251U" => "Ecole de commerce gestion administrative et vente",
			"0730899F" => "ECOLE SUPERIEURE DE COMMERCE DE CHAMBERY",
			"0382778N" => "ECOLE SUPERIEURE DE COMMERCE DE GRENOBLE",
			"0381912X" => "INSTITUT POLYTECHNIQUE DE GRENOBLE",
			"0382955F" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE GRENOBLE",
			"0730858L" => "UNIVERSITE DE CHAMBERY",
			"0381838S" => "UNIVERSITE GRENOBLE 1",
			"0381839T" => "UNIVERSITE GRENOBLE 2",
			"0381840U" => "UNIVERSITE GRENOBLE 3",
			"9710939U" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DES ANTILLES GUYANE",
			"9710585J" => "UNIVERSITE DES ANTILLES GUYANE",
			"9730224F" => "ANTENNE D IUFM IUFM ANTILLES GUYANE",
			"0622384E" => "CENTRE D'ETUDES SUPERIEURES INDUSTRIELLES CENTRE REGIONAL DU NORD",
			"0595714R" => "EC SUP METROLOGIE DOUAI ECOLE SUPERIEUR DE METROLOGIE",
			"0590349J" => "ECOLE CENTRALE DE LILLE",
			"0590350K" => "ECOLE DES HAUTES ETUDES COMMERCIALES DU NORD",
			"0623921A" => "ECOLE D'INGENIEURS DU PAS DE CALAIS",
			"0596163D" => "ECOLE GESTION COMMERCE FLANDRE C.C.I. LILLE-METROPOLE",
			"0590311T" => "ECOLE NATIONALE SUPERIEURE DE CHIMIE DE LILLE, RATTACHEE A L'UNIVERSITE DE LILLE 1",
			"0590338X" => "ECOLE NATIONALE SUPERIEURE DES ARTS ET INDUSTRIES TEXTILES DE ROUBAIX",
			"0590342B" => "ECOLE NATIONALE SUPERIEURE DES TECHNIQUES INDUSTRIELLES ET DES MINES DE DOUAI",
			"0590346F" => "ECOLE SUPERIEURE DE COMMERCE DE LILLE",
			"0590353N" => "ECOLE SUPERIEURE DES TECHNIQUES INDUSTRIELLES ET DES TEXTILES",
			"0590348H" => "HAUTES ETUDES INDUSTRIELLES",
			"0590345E" => "INSTITUT CATHOLIQUE D'ARTS ET METIERS",
			"0590344D" => "INSTITUT CATHOLIQUE DE LILLE MEMBRE UNIV CATHOLIQUE DE LILL",
			"0593202K" => "INSTITUT D'ECONOMIE SCIENTIFIQUE ET DE GESTION",
			"0590343C" => "INSTITUT SUPERIEUR D'AGRICULTURE",
			"0590347G" => "INSTITUT SUPERIEUR DE L ELECTRONIQUE ET DU NUMERIQUE LILLE",
			"0595851P" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE LILLE",
			"0623957P" => "UNIVERSITE D'ARTOIS",
			"0593559Y" => "UNIVERSITE DE LILLE 1",
			"0593560Z" => "UNIVERSITE DE LILLE 2",
			"0593561A" => "UNIVERSITE DE LILLE 3",
			"0593279U" => "UNIVERSITE DE VALENCIENNES",
			"0595964M" => "UNIVERSITE DU LITTORAL",
			"0190805X" => "EGC BRIVE ECOLE GESTION ET COMMERCE",
			"0870997L" => "INSTITUT D'INGENIERIE INFORMATIQUE DE LIMOGES",
			"0871012C" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DU LIMOUSIN",
			"0870669E" => "UNIVERSITE DE LIMOGES",
			"0011293A" => "ANTENNE DE PLASTURGIE DE L'INSA DE LYON",
			"0693180G" => "ASSOCIATION LYONNAISE POUR LA FORMATION - INSTITUT POUR LA DIFFUSION DE LA RECHERCHE ACTIVE COMMERCIALE DE LYON",
			"0691696U" => "CENTRE D'ETUDES SUPERIEURES INDUSTRIELLES CENTRE REGIONAL RHONE ALPES AUVERGNE",
			"0690194L" => "ECOLE CATHOLIQUE D'ARTS ET METIERS",
			"0690187D" => "ECOLE CENTRALE DE LYON",
			"0693448Y" => "ECOLE DE COMMERCE EUROPEENNE DE LYON DU GROUPE INSEEC",
			"0690197P" => "ECOLE DE MANAGEMENT DE LYON",
			"0692587M" => "ECOLE NATIONALE DES TRAVAUX MARITIMES",
			"0692566P" => "ECOLE NATIONALE DES TRAVAUX PUBLICS DE L'ETAT",
			"0420093Y" => "ECOLE NATIONALE D'INGENIEURS DE SAINT-ETIENNE",
			"0420094Z" => "ECOLE NATIONALE SUPERIEURE DES MINES DE SAINT ETIENNE",
			"0692459Y" => "ECOLE NATIONALE SUPERIEURE DES SCIENCES DE L'INFORMATION ET DES BIBLIOTHEQUES (E.N.S.S.I.B.)",
			"0693259T" => "ECOLE NORMALE SUPERIEURE DE LYON",
			"0693817Z" => "ECOLE NORMALE SUPERIEURE LETTRES ET SCIENCES HUMAINES",
			"0693623N" => "ECOLE SUPERIEURE DE CHIMIE PHYSIQUE ELECTRONIQUE DE LYON",
			"0421601M" => "GROUPE ECOLE SUPERIEURE DE COMMERCE DE SAINT ETIENNE",
			"0690195M" => "INSTITUT CATHOLIQUE DE LYON",
			"0690192J" => "INSTITUT NATIONAL DES SCIENCES APPLIQUEES DE LYON",
			"0692353H" => "INSTITUT SUPERIEUR D'AGRICULTURE RHONE ALPES",
			"0693364G" => "INSTITUT TEXTILE ET CHIMIQUE DE LYON (ITECH)",
			"0693480H" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE LYON",
			"0421095M" => "UNIVERSITE DE SAINT-ETIENNE",
			"0691774D" => "UNIVERSITE LYON 1",
			"0691775E" => "UNIVERSITE LYON 2",
			"0692437Z" => "UNIVERSITE LYON 3",
			"9720719Z" => "EC.INTER.AFFAI.MANAGEMENT EIAM-EGC",
			"9720706K" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE LA MARTINIQUE",
			"0342222F" => "CIESSA MONTPELLIER SUP AGRONOMIE",
			"0340131H" => "ECOLE NATIONALE SUPERIEURE AGRONOMIQUE DE MONTPELLIER",
			"0300063F" => "ECOLE NATIONALE SUPERIEURE DES TECHNIQUES INDUSTRIELLES ET DES MINES D'ALES",
			"0340137P" => "ECOLE SUPERIEURE DE COMMERCE DE MONTPELLIER DU GROUPE SUP DE CODE MONTPELLIER",
			"0341818S" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE MONTPELLIER",
			"0341087X" => "UNIVERSITE DE MONTPELLIER 1",
			"0341089Z" => "UNIVERSITE DE MONTPELLIER 3",
			"0301687W" => "Université de Nîmes",
			"0660437S" => "UNIVERSITE DE PERPIGNAN VIA DOMITIA",
			"0341088Y" => "UNIVERSITE MONTPELLIER 2",
			"0542260N" => "CENTRE D'ETUDES SUPERIEURES INDUSTRIELLES CENTRE REGIONAL LORRAINE CHAMPAGNE ARDENNES",
			"0570140T" => "ECOLE NATIONALE D'INGENIEURS DE METZ",
			"0880077F" => "ECOLE SUPERIEURE DES INDUSTRIES TEXTILES D'EPINAL",
			"0573389Z" => "ECOLE SUPERIEURE D'INGENIEURS DES TRAVAUX DE LA CONSTRUCTION DE METZ",
			"0573593W" => "ECOLE SUPERIEURE DU SOUDAGE ET DE SES APPLICATIONS",
			"0542455A" => "Institut Commercial de Nancy - Ecole de Management",
			"0541564G" => "INSTITUT NATIONAL POLYTECHNIQUE DE LORRAINE",
			"0542255H" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE NANCY METZ",
			"0572081C" => "UNIVERSITE DE METZ",
			"0541507V" => "UNIVERSITE NANCY 1",
			"0541508W" => "UNIVERSITE NANCY 2",
			"0440112H" => "Audencia école management Nantes",
			"0442292C" => "CENTRE D'ETUDES SUPERIEURES INDUSTRIELLES CENTRE REGIONAL DES PAYS DE LOIRE",
			"0441965X" => "ECOLE ATLANTIQUE DE COMMERCE INTERNATIONAL CHAMBRE DE COMMERCE ET D INDUSTRIE DE NANTES ET DE ST NAZAIRE.",
			"0440100V" => "ECOLE CENTRALE DE NANTES",
			"0721513D" => "Ecole de gestion et de commerce du Mans",
			"0851465F" => "Ecole de gestion et de commerce Vendée",
			"0441679L" => "ECOLE NATIONALE D'INGENIEURS DES TECHNIQUES DES INDUSTRIES AGRICOLES ET ALIMENTAIRES",
			"0442205H" => "ECOLE NATIONALE SUPERIEURE DES TECHNIQUES INDUSTRIELLES ET DES MINES DE NANTES",
			"0492246A" => "ECOLE SUPERIEURE ANGEVINE D'INFORMATIQUE ET DE PRODUCTIQUE",
			"0490072M" => "ECOLE SUPERIEURE D'AGRICULTURE D'ANGERS",
			"0490075R" => "ECOLE SUPERIEURE D'ELECTRONIQUE DE L'OUEST",
			"0721575W" => "ECOLE SUPERIEURE DES GEOMETRES TOPOGRAPHES",
			"0490076S" => "ECOLE SUPERIEURE DES SCIENCES COMMERCIALES D ANGERS DU GROUPE ESSCA",
			"0442278M" => "ECOLE SUPERIEURE DU BOIS",
			"0492202C" => "ECOLE SUPERIEURE ET D APPLICATION DU GENIE",
			"0492189N" => "INH ANGERS",
			"0442185L" => "INSTITUT CATHOLIQUE D'ARTS ET METIERS DE NANTES",
			"0851415B" => "INSTITUT DE FORMATION DE L'UCO AUX METIERS DE L'ENSEIGNEMENT",
			"0492248C" => "INSTITUT NATIONAL D'HORTICULTURE - ECOLE NATIONALE D'INGENIEURS DE L'HORTICULTURE ET DU PAYSAGE",
			"0492247B" => "INSTITUT NATIONAL D'HORTICULTURE - ECOLE NATIONALE SUPERIEURE D'HORTICULTURE ET D'AMENAGEMENT DU PAYSAGE",
			"0721484X" => "INSTITUT SUPERIEUR DES MATERIAUX DU MANS",
			"0442199B" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE NANTES",
			"0490811R" => "UNIVERSITE CATHOLIQUE DE L'OUEST",
			"0490970N" => "UNIVERSITE D'ANGERS",
			"0440984F" => "UNIVERSITE DE NANTES",
			"0720916E" => "UNIVERSITE LE MANS",
			"0060656F" => "ECOLE HTES ETUDES COMMERCIALES C.E.R.A.M.",
			"0831521C" => "INSTITUT SUPERIEUR DE MECANIQUE DE PARIS",
			"0831458J" => "Institut Supérieur d'Electronique et du Numerique - TOULON",
			"0061758D" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE NICE",
			"0060931E" => "UNIVERSITE DE NICE",
			"0830766G" => "UNIVERSITE DE TOULON",
			"9830491S" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DU PACIFIQUE",
			"9830445S" => "UNIVERSITE DE LA NOUVELLE-CALEDONIE",
			"0451493D" => "EC DE COMMERCE ET DE GESTION ECG (CCI) ORLEANS",
			"0371376V" => "EC SUP COMMERCE TOURS GROUPE ESCM TOURS POITIERS",
			"0180910S" => "ECOLE NAT SUP ING DE BOURGES",
			"0410981U" => "ECOLE NATIONALE SUPERIEURE DE LA NATURE ET DU PAYSAGE DE BLOIS",
			"0451482S" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE D'ORLEANS TOURS",
			"0370800U" => "UNIVERSITE DE TOURS",
			"0450855K" => "UNIVERSITE D'ORLEANS",
			"0752092S" => "ACADEMIE COMMERCIALE INTERNATIONALE - NEGOCIA",
			"0754988P" => "ADVANCIA",
			"0753471R" => "CONSERVATOIRE NATIONAL DES ARTS ET METIERS",
			"0753636V" => "EC EUROPEENNE DE GESTION EUROPEAN BUSINESS SCHOOL",
			"0754967S" => "EC SUP ACTION ET RECH COMMERC",
			"0754431J" => "ECOLE CENTRALE D ́ELECTRONIQUE PARIS",
			"0753742K" => "ECOLE DES HAUTES ETUDES EN SCIENCES SOCIALES",
			"0750043P" => "ECOLE D'INGENIEURS DE LA VILLE DE PARIS",
			"0753478Y" => "ECOLE NATIONALE DES CHARTES",
			"0753503A" => "ECOLE NATIONALE DU GENIE RURAL DES EAUX ET DES FORETS",
			"0753237L" => "ECOLE NATIONALE SUPERIEURE D'ARTS ET METIERS",
			"0753375L" => "ECOLE NATIONALE SUPERIEURE DE CHIMIE DE PARIS, RATTACHEE A L'UNIVERSITE PARIS 6",
			"0753493P" => "ECOLE NATIONALE SUPERIEURE DES MINES DE PARIS",
			"0751878J" => "ECOLE NATIONALE SUPERIEURE DES TECHNIQUES AVANCEES",
			"0753510H" => "ECOLE NATIONALE SUPERIEURE DES TELECOMMUNICATIONS",
			"0753455Y" => "ECOLE NORMALE SUPERIEURE",
			"0753486G" => "ECOLE PRATIQUE DES HAUTES ETUDES",
			"0753574C" => "ECOLE SPECIALE DE MECANIQUE ET D'ELECTRICITE",
			"0753607N" => "ECOLE SPECIALE DES TRAVAUX PUBLICS DU BATIMENT ET DE L'INDUSTRIE",
			"0753560M" => "ECOLE SUPERIEURE D INFORMATIQUE ELECTRONIQUE AUTOMATIQUE",
			"0753547Y" => "ECOLE SUPERIEURE DE COMMERCE DE PARIS-ECOLE EUROPEENNE DES AFFAIRES, CHAMBRE DE COMMERCE ET D INDUSTRIE DE PARIS",
			"0753111Z" => "ECOLE SUPERIEURE DE GESTION",
			"0753429V" => "ECOLE SUPERIEURE DE PHYSIQUE ET DE CHIMIE INDUSTRIELLES DE LA VILLE DE PARIS",
			"0754500J" => "INST ETUD ECO ET COMMERCIALES",
			"0753147N" => "INST INTERNAT COMMERCE DISTRIB",
			"0752792C" => "INST PREPA ADM ET GESTION",
			"0752304X" => "INST SUP SC TECHN ET ECO COMM",
			"0753620C" => "INST SUPERIEUR DE GESTION",
			"0753541S" => "INSTITUT CATHOLIQUE PARIS",
			"0753428U" => "INSTITUT DE PHYSIQUE DU GLOBE DE PARIS",
			"0753431X" => "INSTITUT D'ETUDES POLITIQUES DE PARIS",
			"0753465J" => "INSTITUT NATIONAL AGRONOMIQUE PARIS GRIGNON",
			"0755026F" => "INSTITUT NATIONAL D HISTOIRE DE L ART",
			"0753488J" => "INSTITUT NATIONAL DES LANGUES ET CIVILISATIONS ORIENTALES",
			"0750252S" => "INSTITUT SUP DU COMMERCE",
			"0753559L" => "INSTITUT SUPERIEUR D ELECTRONIQUE DE PARIS",
			"0754445Z" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE PARIS",
			"0753494R" => "MUSEUM NATIONAL D'HISTOIRE NATURELLE",
			"0753496T" => "OBSERVATOIRE DE PARIS",
			"0750736T" => "UNIVERSITE DE TECHNOLOGIE EN SCIENCES DES ORGANISATIONS ET DE LA DECISION DE PARIS-DAUPHINE",
			"0751717J" => "UNIVERSITE PARIS 1",
			"0751718K" => "UNIVERSITE PARIS 2",
			"0751719L" => "UNIVERSITE PARIS 3",
			"0751720M" => "UNIVERSITE PARIS 4",
			"0751721N" => "UNIVERSITE PARIS 5",
			"0751722P" => "UNIVERSITE PARIS 6",
			"0751723R" => "UNIVERSITE PARIS 7",
			"0161122H" => "Ecole de gestion et de commerce d'Angoulème",
			"0171435T" => "ECOLE D'INGENIEURS EN GENIE DES SYSTEMES INDUSTRIELS",
			"0860073M" => "ECOLE NATIONALE SUPERIEURE DE MECANIQUE ET D'AEROTECHNIQUE DE POITIERS, RATTACHEE A L'UNIVERSITE DE POITIERS",
			"0171427J" => "ECOLE SUPERIEURE DE COMMERCE",
			"0861249R" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE POITOU-CHARENTES",
			"0171463Y" => "UNIVERSITE DE LA ROCHELLE",
			"0860856N" => "UNIVERSITE DE POITIERS",
			"9840349G" => "UNIVERSITE POLYNESIE FRANCAISE",
			"0101059X" => "Ecole Supérieure de Commerce",
			"0511935B" => "Institut Universitaire de Formation des Maîtres de l'académie de Reims",
			"0510088U" => "Reims management school",
			"0511296G" => "Université de Reims",
			"0101060Y" => "Université de Technologie de Troyes",
			"0352330T" => "ECOLE DE GESTION ET DE COMMERCE DE BRETAGNE DE LA CHAMBRE DE COMMERCE ET D'INDUSTRIE DU PAYS DE ST MALO",
			"0352337A" => "ECOLE LOUIS DE BROGLIE",
			"0350095N" => "ECOLE NATIONALE DE LA SANTE PUBLIQUE",
			"0352480F" => "ECOLE NATIONALE DE LA STATISTIQUE ET DE L'ANALYSE DE L'INFORMATION",
			"0290119X" => "ECOLE NATIONALE D'INGENIEURS DE BREST",
			"0350087E" => "ECOLE NATIONALE SUPERIEURE AGRONOMIQUE DE RENNES (AGROCAMPUS RENNES)",
			"0350077U" => "ECOLE NATIONALE SUPERIEURE DE CHIMIE DE RENNES, RATTACHEE A L'UNIVERSITE DE RENNES 1",
			"0290125D" => "ECOLE NATIONALE SUPERIEURE DES INGENIEURS DES ETUDES ET TECHNIQUES D'ARMEMENT",
			"0291811L" => "ECOLE NATIONALE SUPERIEURE DES TELECOMMUNICATIONS DE BRETAGNE",
			"0290124C" => "ECOLE NAVALE",
			"0560068V" => "ECOLE SPECIALE MILITAIRE DE SAINT CYR",
			"0290127F" => "Ecole Supérieure de Commerce de Bretagne Brest de la Chambre de Commerce et d'Industrie de Brest",
			"0351842M" => "ECOLE SUPERIEURE ET D'APPLICATION DES TRANSMISSIONS",
			"0352373P" => "ECOLE SUPERIEURE PRIVEE EME",
			"0352305R" => "GROUPE ECOLE SUPERIEURE DE COMMERCE DE RENNES",
			"0352422T" => "INSTITUT D'ETUDES SUPERIEURES D'INDUSTRIE ET D'ECONOMIE LAITIERES (AGROCAMPUS RENNES)",
			"0350097R" => "INSTITUT NATIONAL DES SCIENCES APPLIQUEES DE RENNES",
			"0352347L" => "INSTITUT NATIONAL SUPERIEUR DE FORMATION AGROALIMENTAIRE (AGROCAMPUS RENNES)",
			"0292125C" => "INSTITUT SUPERIEUR DE L'ELECTRONIQUE ET DU NUMERIQUE",
			"0352291A" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE RENNES",
			"0290346U" => "UNIVERSITE DE BREST",
			"0561718N" => "UNIVERSITE DE BRETAGNE SUD",
			"0350936C" => "UNIVERSITE RENNES 1",
			"0350937D" => "UNIVERSITE RENNES 2",
			"9741101D" => "ECOLE DE GESTION ET COMMERCE CTRE CONSUL FORM.STE CLOTILDE",
			"9741061K" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE LA REUNION",
			"9740478B" => "UNIVERSITE DE LA REUNION",
			"0762969P" => "CENTRE D'ETUDES SUPERIEURES INDUSTRIELLES CENTRE REGIONAL DE NORMANDIE",
			"0760167U" => "ECOLE DE SUPERIEURE DE COMMERCE DE ROUEN",
			"0760168V" => "ECOLE SUPERIEURE DE COMMERCE SUP. DE CO. LE HAVRE CAEN",
			"0762378X" => "ECOLE SUPERIEURE D'INGENIEURS EN GENIE ELECTRIQUE",
			"0271338H" => "Ecole supérieure d'ingénieurs et techniciens pour l'agriculture",
			"0760165S" => "INSTITUT NATIONAL DES SCIENCES APPLIQUEES DE ROUEN",
			"0762970R" => "INSTITUT PORTUAIRE D ENSEIGNEMENT ET RECHERCHE LE HAVRE",
			"0762952W" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE ROUEN",
			"0761904G" => "UNIVERSITE DE ROUEN",
			"0762762P" => "UNIVERSITE DU HAVRE",
			"0670189S" => "ECOLE NATIONALE DU GENIE DE L'EAU ET DE L'ENVIRONNEMENT DE STRASBOURG",
			"0680097L" => "ECOLE NATIONALE SUPERIEURE DE CHIMIE",
			"0670190T" => "Institut nationale des sciences appliquées de Strasbourg",
			"0672635A" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L'ACADEMIE DE STRASBOURG",
			"0681166Y" => "UNIVERSITE DE MULHOUSE",
			"0671712X" => "UNIVERSITE STRASBOURG 1",
			"0671713Y" => "UNIVERSITE STRASBOURG 2",
			"0671778U" => "UNIVERSITE STRASBOURG 3",
			"0312020C" => "Centre d'Etudes Supérieures Industrielles Midi-Pyrénées",
			"0811293R" => "Centre Universitaire de Formation et de Recherche du Nord-Est Midi-Pyrénées Jean-Francois Champollion Albi",
			"0820822Y" => "Ecole de Gestion et de Commerce",
			"0310154Z" => "Ecole d'Ingénieur de purpan",
			"0312069F" => "Ecole Nationale de la Météorologie",
			"0311256X" => "Ecole Nationale de l'Aviation Civile de Toulouse",
			"0650048Z" => "Ecole Nationale d'Ingénieurs de Tarbes",
			"0811200P" => "Ecole Nationale Supérieure des Techniques Industrielles et des Mines d'Albi-Carmaux",
			"0121367W" => "Ecole supérieure technique privée de gestion commerce informatique",
			"0312013V" => "Ecole supérieure technique privée gestion commerce informatique",
			"0310156B" => "Groupe Ecole supérieure de Commerce",
			"0310155A" => "Institut catholique Toulouse",
			"0312421N" => "Institut Catholique d'arts et métiers de Toulouse",
			"0310152X" => "Institut National des Sciences Appliquées de Toulouse",
			"0311381H" => "Institut National Polytechnique de Toulouse",
			"0312760G" => "Institut Supérieur de l'Aéronautique et de l'Espace",
			"0312299F" => "Institut Universitaire de Formation des Maîtres Académie de Toulouse Midi-Pyrénées",
			"0311382J" => "Université Toulouse 1 Sciences Sociales",
			"0311383K" => "Université Toulouse 2 Le Mirail",
			"0311384L" => "Université Toulouse 3 Paul Sabatier",
			"0922455U" => "CTRE D'ETUDES SUPERIEURES INDUSTRIELLES CTRE REGIONAL D'ILE DE FRANCE",
			"0921682D" => "EC NAT STAT ADM ECO MALAKOFF",
			"0921225G" => "ECOLE CENTRALE DES ARTS ET MANUFACTURES",
			"0951820M" => "ECOLE DE BIOLOGIE INDUSTRIELLE EBI",
			"0922369A" => "ECOLE DE MANAGEMENT LEONARD DE VINCI",
			"0951819L" => "ECOLE D'ELECTRICITE DE PRODUCTION ET DES METHODES INDUSTRIELLES EPMI",
			"0783054W" => "ECOLE HTES ETUDES COMMERCIALES H E C",
			"0951623Y" => "ECOLE INTERNATIONALE DES SCIENCES DU TRAITEMENT DE L'INFORMATION",
			"0951376E" => "ECOLE NATIONALE SUPERIEURE DE L'ELECTRONIQUE ET DE SES APPLICATIONS DE CERGY",
			"0910684Z" => "ECOLE NATIONALE SUPERIEURE DES INDUSTRIES AGRICOLES ET ALIMENTAIRES",
			"0920815L" => "ECOLE NATIONALE SUPERIEURE DU PETROLE ET DES MOTEURS DE RUEIL",
			"0911568K" => "ECOLE POLYTECHNIQUE",
			"0920674H" => "ECOLE POLYTECHNIQUE FEMININE",
			"0922007G" => "ECOLE PRIVEE DES DIRIGEANTS ET CREATEURS D'ENTREPRISES",
			"0951214D" => "ECOLE SUP SC ECO COMMERCIALES INSTITUT CATHOLIQUE",
			"0951803U" => "ECOLE SUPERIEURE DE CHIMIE ORGANIQUE ET MINERALE ESCOM",
			"0920672F" => "ECOLE SUPERIEURE DE FONDERIE",
			"0911494E" => "ECOLE SUPERIEURE D'ELECTRICITE PRIVEE SUPELEC",
			"0921929X" => "ECOLE SUPERIEURE DES TECHNIQUES AERONAUTIQUES ET DE CONSTRUCTION AUTOMOBILE",
			"0922563L" => "Ecole Supérieure d'Ingénieurs Léonard De Vinci. Etablissement d'Enseignement Supérieur Technique Privé.",
			"0910725U" => "ECOLE SUPERIEURE D'OPTIQUE",
			"0922374F" => "ECOLE SUPERIEURE PRIVEE COMMERCE EXTERIEUR ESCE LDV",
			"0951804V" => "institut géologique albert de lapparent (igal)",
			"0910685A" => "INSTITUT NATIONAL DES SCIENCES ET TECHNIQUES NUCLEAIRES",
			"0911781S" => "INSTITUT NATIONAL DES TELECOMMUNICATIONS",
			"0951808Z" => "institut supérieur des techniques d'outre-mer (istom)",
			"0781938H" => "INSTITUT UNIVERSITAIRE DE FORMATION DES MAITRES DE L 'ACADEMIE DE VERSAILLES",
			"0951793H" => "UNIVERSITE CERGY PONTOISE",
			"0781944P" => "UNIVERSITE DE VERSAILLES SAINT QUENTIN EN YVELINES",
			"0911975C" => "UNIVERSITE EVRY VAL D ESSONNE",
			"0921204J" => "UNIVERSITE PARIS 10",
			"0911101C" => "UNIVERSITE PARIS 11",
		)
	),
	'SISE' => array (
		'etuRegimeInscription' => array (
			'01' => "PARENTS ELEVANT 3 ENFANTS",
			'02' => "SPORTIFS DE HAUT NIVEAU",
			'03' => "CADRES PLUS DE 5 ANS",
			'04' => "BAC +2 & 5 ANS PRATIQUE PROF",
			'09' => "AUTRES DISPENSES",
			'10' => "FORMATION INITIALE HORS APPRENTISSAGE",
			'11' => "REPRISE ETUDES NON FINANCEE SANS CONV",
			'12' => "CONTRAT APPRENTISSAGE",
			'20' => "FORMATION CONTINUE HORS CONTRAT PROF",
			'21' => "FORMATION CONTINUE DIPLOMANTE",
			'22' => "CONTRAT DE PROFESSIONNALISATION",
			'51' => "PARENTS AYANT 3 ENFANTS",
			'52' => "SPORTIFS HAUT NIVEAU",
			'53' => "CADRES PLUS DE 5 ANS",
			'54' => "BAC+2 ET 5A PRATIQUE PROFESSIONNELLE",
			'55' => "BAC PROFESSIONNEL ET 7A PRTIQUE PROF",
			'56' => "CAP-BEP ET 8A PRATIQUE PROFESSIONNELLE",
			'57' => "CONTRAT DRT PRIV +5A ANCIEN (3 CONCOURS)",
			'59' => "AUTRES DISPENSES",
			'61' => "FORM PERMANENTE - FEMMES ELEVANT 3 ENFTS",
			'62' => "FORM PERMANENTE - SPORTIFS HAUT NIVEAU",
			'63' => "FORM PERMANENTE - CADRES PLUS DE 5 ANS",
			'64' => "FORM PERMANENTE - BAC+2 & 5A PRAT PROF",
			'69' => "FORM PERMANENTE - AUTRES DISPENSES",
			'71' => "FORM CONTINUE - FEMMES ELEVANT 3 ENFTS",
			'72' => "FORM CONTINUE - SPORTIFS HAUT NIVEAU",
			'73' => "FORM CONTINUE - CADRES PLUS DE 5 ANS",
			'74' => "FORM CONTINUE - BAC+2 & 5A PRAT PROF",
			'79' => "FORM CONTINUE - AUTRES DISPENSES",
			'90' => "STAGIAIRES EN SITUATION",
		),
		'etuSecteurDisciplinaire' => array (
			'01' => "MATHEMATIQUES",
			'02' => "PHYSIQUE",
			'03' => "CHIMIE",
			'04' => "MATHEMATIQUES APPLIQUEES ET SCIENCES SOCIALES (M.A.S.S.)",
			'05' => "SCIENCES DE L'UNIVERS",
			'06' => "SCIENCES DE LA VIE",
			'07' => "MEDECINE",
			'08' => "ODONTOLOGIE",
			'09' => "PHARMACIE",
			'10' => "S.T.A.P.S.",
			'11' => "MECANIQUE, GENIE MECANIQUE",
			'12' => "GENIE CIVIL",
			'13' => "GENIE DES PROCEDES",
			'14' => "INFORMATIQUE",
			'15' => "ELECTRONIQUE, GENIE ELECTRIQUE",
			'16' => "SCIENCES ET TECHNOLOGIE INDUSTRIELLES",
			'17' => "SCIENCES DU LANGAGE - LINGUISTIQUE",
			'18' => "LANGUES ET LITTERATURES ANCIENNES",
			'19' => "LANGUES ET LITTERATURES FRANCAISES",
			'20' => "LITTERATURE GENERALE ET COMPAREE",
			'21' => "ARTS",
			'22' => "FRANCAIS, LANGUE ETRANGERE",
			'23' => "LANGUES ET LITTERATURES ETRANGERES",
			'24' => "LANGUES ETRANGERES APPLIQUEES",
			'25' => "CULTURES ET LANGUES REGIONALES",
			'26' => "PHILOSOPHIE, EPISTEMOLOGIE",
			'27' => "HISTOIRE",
			'28' => "GEOGRAPHIE",
			'29' => "AMENAGEMENT",
			'30' => "ARCHEOLOGIE, ETHNOLOGIE, PREHISTOIRE",
			'31' => "SCIENCES RELIGIEUSES",
			'32' => "PSYCHOLOGIE",
			'33' => "SOCIOLOGIE, DEMOGRAPHIE",
			'34' => "SCIENCES DE L'EDUCATION",
			'35' => "SCIENCES DE L'INFORMATION ET LA COMMUNICATION",
			'36' => "SCIENCES JURIDIQUES",
			'37' => "SCIENCES POLITIQUES",
			'38' => "SCIENCES ECONOMIQUES",
			'39' => "SCIENCES DE GESTION",
			'40' => "ADMINISTRATION ECONOMIQUE ET SOCIALE (A.E.S.)",
			'41' => "FORMATION GENERALE AUX METIERS DE L'INGENIEUR",
			'42' => "MATHEMATIQUE ET INFORMATIQUE",
			'43' => "PHYSIQUE ET CHIMIE",
			'50' => "THEOLOGIE CATHOLIQUE",
			'61' => "PLURI DROIT - SCIENCES POLITIQUES",
			'62' => "PLURI SCIENCES ECONOMIQUES ET GESTION",
			'63' => "PLURI DROIT - SCIENCES ECONOMIQUES - AES",
			'64' => "PLURI LETTRES - SCIENCES DU LANGAGE - ARTS",
			'65' => "PLURI LANGUES",
			'66' => "PLURI SCIENCES HUMAINES ET SOCIALES",
			'67' => "PLURI LETTRES - LANGUES - SC HUMAINES",
			'68' => "PLURI SCIENCES FONDAMENTALES ET APPLICATIONS",
			'69' => "PLURI SC DE LA VIE, DE LA SANTE, DE LA TERRE ET DE L'UNIVERS",
			'70' => "PLURI SCIENCES",
			'71' => "PLURI SANTE",
			'80' => "VETERINAIRE",
			'90' => "INTERDISCIPLINAIRE",
			'AA' => "En attente d'attribution",
			'-' => "SANS OBJET",
		),
		'etuTypeDiplome' => array (
			'01' => "DIPLOME UNIVERSITE GENERIQUE",
			'02' => "CERTIFICAT D'ECOLE",
			'03' => "HABILITATION A DIRIGER DES RECHERCHES",
			'04' => "DU TYPE DOCTORAT (INST CATHOLIQUES)",
			'05' => "DIPLOME INTERNATIONAL",
			'06' => "POST-DUT",
			'07' => "MASTERE SPECIALISE",
			'08' => "MASTERS OF",
			'09' => "AUTRES DIPLOMES",
			'AC' => "CAPACITE EN DROIT",
			'CA' => "DEUG RENOVE",
			'CB' => "DUT",
			'CC' => "DEUG",
			'CD' => "DEUST",
			'CI' => "DEUST IUP",
			'CJ' => "DEUP",
			'CK' => "DEUG IUP",
			'CL' => "DIPLOME NAT DE TECHN SPECIAL (DNTS)",
			'CP' => "DEUG INTERMEDIAIRE LMD",
			'CX' => "PREMIER CYCLE DES ETUDES MEDICALES PCEM",
			'CY' => "1ERE ANNEE COMMUNE AUX ETUDES DE SANTE",
			'CZ' => "DIPLOME DE FORMATION GENERALE SANTE",
			'DA' => "LICENCE RENOVEE",
			'DB' => "LIC BI-DISCIPLINAIRE",
			'DC' => "LICENCE",
			'DJ' => "LICENCE IUP",
			'DK' => "PREPARATION CAPEPS",
			'DP' => "LICENCE PROFESSIONNELLE",
			'DU' => "PREPARATION CPE",
			'DV' => "PREPARATION CRPE",
			'DW' => "PREPARATION CAPES",
			'DX' => "PREPARATION CAPLP",
			'DY' => "PREPARATION CAPET",
			'DZ' => "PREPARATION CAPES",
			'EA' => "MAITRISE RENOVEE",
			'EB' => "MAITRISE BI-DISCIPLINAIRE",
			'EC' => "MAITRISE",
			'ED' => "MST",
			'EE' => "MAITRISE DE SCIENCES ET GESTION (MSG)",
			'EF' => "MAIT. INFOR. APPL. GESTION ENTR. (MIAGE)",
			'EJ' => "MAITRISE IUP",
			'EK' => "CERTIFICATION CAPEPS",
			'EL' => "MSBM - C1",
			'EM' => "MSBM - C2",
			'EN' => "MAITRISE DE SCIENCES BIOL. ET MEDICALE",
			'EP' => "MAITRISE INTERMEDIAIRE LMD",
			'ER' => "DIP PREP RECH BIOMEDICALE (DPRB) - C1",
			'ES' => "PREPARATION SPECIALISATION ENS TITULAIRE",
			'ET' => "CERTIFICATION AGREGATION",
			'EU' => "CERTIFICATION CPE",
			'EV' => "CERTIFICATION CRPE",
			'EW' => "CERTIFICATION CAPES",
			'EX' => "CERTIFICATION CAPLP",
			'EY' => "CERTIFICATION CAPET",
			'EZ' => "PREPARATION AGREGATION",
			'FC' => "DIPLOME D'ETUDE APPROFONDIE (DEA)",
			'FD' => "DESS",
			'FE' => "MAGISTERE",
			'FF' => "DIPLOME DE RECHERCHE TECHNOLOGIQUE (DRT)",
			'FH' => "DE DOCTEUR EN PHARMACIE",
			'FI' => "FORMATION D'INGENIEUR CLASSIQUE",
			'FJ' => "DE DOCTEUR EN CHIRURGIE DENTAIRE",
			'FK' => "DIPL FIN 2 CYCLE ETUDES PHARMACEUTIQUES",
			'FL' => "DIPL FIN 2 CYCLE ETUDES ODONTOLOGIQUES",
			'FM' => "DIPLÔME INGENIEUR CONJOINT",
			'FN' => "FORM D'INGENIEUR EN PARTENARIAT(EX NFI)",
			'FX' => "DEUX. CYCLE DES ETUDES MEDICALES (DCEM)",
			'GD' => "DE DOCTEUR EN PHARMACIE",
			'GF' => "CES (CHIR. DENT. A)",
			'GG' => "CES CHIRURGIE DENTAIRE",
			'HH' => "CES (CHIR. DENT.B)",
			'IB' => "DE DOCTEUR EN MEDECINE",
			'IC' => "DIPL FIN 2 CYCLE ETUDES MEDICALES",
			'IX' => "QUALIFICATION MEDECINE GENERALE",
			'JB' => "C.E.C.S.M.O.",
			'JC' => "DES PHARMACIE",
			'JD' => "DES MEDECINE",
			'JF' => "DES ODONTOLOGIE",
			'KG' => "CAPACITE MEDECINE",
			'LP' => "LICENCE PLURIDISCIPLINAIRE",
			'MA' => "DESC MEDECINE GROUPE 1",
			'MB' => "DESC MEDECINE GROUPE 2",
			'MC' => "DESC MEDECINE",
			'MD' => "DESC BIOLOGIE MEDICALE",
			'NA' => "AUTRES DIPL. NATIONAUX NIV. FORM. BAC",
			'NB' => "AUTRES DIPL. NATIONAUX NIV. FORM. BAC+1",
			'NC' => "AUTRES DIPL. NATIONAUX NIV. FORM. BAC+2",
			'ND' => "AUTRES DIPL. NATIONAUX NIV. FORM. BAC+3",
			'NE' => "AUTRES DIPL. NATIONAUX NIV. FORM. BAC+4",
			'NF' => "AUTRES DIPL. NATIONAUX NIV. FORM. BAC+5",
			'PA' => "CERTIFICAT CAPACITE ORTHOPHONISTE",
			'PB' => "CERTIFICAT CAPACITE ORTHOPTISTE",
			'PC' => "DIPLOME D'ETAT AUDIO-PROTHESISTE",
			'PD' => "DIPLOME D'ETAT PSYCHOMOTRICIEN",
			'PE' => "DIPLOME D'ETAT SAGE-FEMME",
			'PF' => "DIPL ETAT DE MASSEUR-KINESATHERAPEUTE",
			'PG' => "DIPLOME ETAT ERGOTHERAPEUTE",
			'PH' => "DIPLOME ETAT TECHN ANALYSES BIOMEDICALES",
			'PJ' => "DIPLÔME D'ETAT INFIRMIER",
			'PK' => "DIPL ETAT MANIPULATEUR ELECTRADIOL MEDIC",
			'RA' => "DIPLOME VISE NIVEAU BAC+5 GRADE MASTER",
			'RB' => "DIPLOME VISE NIVEAU BAC+5",
			'RC' => "DIPLOME VISE NIVEAU BAC+4",
			'RD' => "DIPLOME VISE NIVEAU BAC+3",
			'RE' => "DIPLOME VISE NIVEAU BAC+2",
			'RF' => "CYCLE PREPARATOIRE MANAGEMENT",
			'SA' => "DOCTORAT VETERINAIRE",
			'SB' => "DIPL ETUDES FONDAMENTALES VETERINAIRES",
			'SC' => "INTERNAT VETERINAIRE",
			'SD' => "DIPL ETUDES SPECIALISEES VETERINAIRES",
			'SE' => "CERTIF ETUDES APPROFONDIES VETERINAIRES",
			'TA' => "BAC CANONIQUE THEOLOGIE",
			'TB' => "LIC CANONIQUE THEOLOGIE",
			'TC' => "DOCT CANONIQUE THEOLOGIE",
			'TD' => "BAC CANONIQUE PHILOSOPHIE",
			'TE' => "LIC CANONIQUE PHILOSOPHIE",
			'TF' => "DOCT CANONIQUE PHILOSOPHIE",
			'TG' => "LIC CANONIQUE DROIT CANONIQUE",
			'TH' => "DOCT CANONIQUE DROIT CANONIQUE",
			'TJ' => "BAC CANONIQUE SCIENCES SOCIALES",
			'TK' => "LIC CANONIQUE SCIENCES SOCIALES",
			'TL' => "DOCT CANONIQUE SCIENCES SOCIALES",
			'TM' => "BAC CANONIQUE DROIT CANONIQUE",
			'TN' => "CERTIFICAT EN THEOLOGIE",
			'TP' => "MASTER CANONIQUE",
			'UA' => "DIPLOME UNIV OU ETAB NIVEAU BAC",
			'UB' => "DIPLOME UNIV OU ETAB NIVEAU BAC + 1",
			'UC' => "DIPLOME UNIV OU ETAB NIVEAU BAC + 2",
			'UD' => "DIPLOME UNIV OU ETAB NIVEAU BAC + 3",
			'UE' => "DIPLOME UNIV OU ETAB NIVEAU BAC + 4",
			'UF' => "DIPLOME UNIV OU ETAB NIVEAU BAC + 5",
			'UR' => "MASTERS DAUPHINE",
			'US' => "DIPLOME EPHE",
			'UT' => "DIPLOME ENS",
			'UU' => "DIPLOME EHESS",
			'UV' => "DIPLOME ENSAE",
			'UW' => "DIPLOME PARIS-DAUPHINE CYCLE1",
			'UX' => "DIPLOME INSTITUT ETUDES POLITIQUES",
			'UY' => "CERTIFICAT ETUDES JUDICIAIRES",
			'UZ' => "DIPLOME COMMERCE",
			'VA' => "CONCOURS ADMINISTRATIF NIV. FORM. BAC",
			'VB' => "CONCOURS ADMINISTRATIF NIV. FORM. BAC+1",
			'VC' => "CONCOURS ADMINISTRATIF NIV. FORM. BAC+2",
			'VD' => "CONCOURS ADMINISTRATIF NIV. FORM. BAC+3",
			'VE' => "CONCOURS ADMINISTRATIF NIV. FORM. BAC+4",
			'VF' => "PREPARATION CONCOURS ENSEIGNEMENT",
			'WA' => "DIPLOME PAR LE GOUVERNEMENT",
			'WB' => "DIPLÔME ARCHITECTE DE L'INSA",
			'XA' => "LICENCE (LMD)",
			'XB' => "MASTER (LMD)",
			'XC' => "MASTER INGENIEUR",
			'XD' => "MASTER ENSEIGNEMENT",
			'XE' => "CPGE INTEGREE UNIVERSITES",
			'XF' => "DU FORMATION ADAPTEE ENSEIGNEMENT",
			'YA' => "DOCTORAT D'UNIVERSITE",
			'YB' => "DOCTORAT D'UNIVERSITE (GENERIQUE)",
			'YI' => "FORMATION INGENIEUR SPECIALISE",
			'YJ' => "DIS MEDECINE",
			'YL' => "DIS PHARMACIE",
			'YM' => "ATTEST. FORMATION SPECIALISEE (AFS)",
			'YN' => "ATTEST. FORM. SPECIALISEE APPROF. (AFSA)",
			'YP' => "ATTESTATION ETUDES APPROF. CH. DENTAIRE",
			'YQ' => "DIPLOME FORMATION MEDICALE SPECIALISEE",
			'YR' => "DIPL FORM MEDICALE SPECIAL APPROFONDIE",
			'ZA' => "DIPLOME PREP AUX ETUDES COMPTABLES",
			'ZB' => "DIPLOME ETUDES COMPTABLES",
			'ZC' => "DIPLOME SUPERIEUR ETUDES COMPTABLES",
			'ZD' => "DIPLOME NATIONAL D'OENOLOGIE",
			'ZE' => "CERT APTITUDE ENSEIG SPECIALISE (UNIV)",
			'ZF' => "DIPLOME COMPTABILITE ET DE GESTION",
			'ZG' => "DIPL SUP COMPTABILITE ET DE GESTION",
			'ZH' => "CERTIFICATS DE COMPETENCES",
		)
	),
	'NCORPS' => array (
		'empCorps' => array (
			'002' => "PERSONNEL DIRECTION DE 1ERE CATEGORIE",
			'003' => "PERSONNEL DIRECTION DE 2EME CATEGORIE",
			'004' => "PERSONNEL DE DIRECTION",
			'006' => "DIRECTEUR DE CROUS",
			'007' => "DIRECTEUR DE CLOUS",
			'008' => "DIRECTEUR DE CRDP",
			'009' => "PRESIDENT  DU CONSEIL DE L'AERES",
			'010' => "DIRECTEUR D'EPN",
			'011' => "DIR. ADJOINT ET SECRETAIRE GENERAL D'EPN",
			'012' => "DIRECTEUR DU SIEC",
			'020' => "RECTEUR",
			'021' => "SECRETAIRE GENERAL D'ACADEMIE",
			'022' => "SECRETAIRE GENERAL D'A.S.U.",
			'023' => "SECRETAIRE GENERAL D'UNIVERSITE",
			'024' => "AGENT COMPTABLE D'UNIVERSITE",
			'025' => "AGT CPT D'EPCSCP",
			'026' => "AGENT COMPTABLE DE CROUS",
			'027' => "DIRECTEUR ACADEMIE DE PARIS",
			'030' => "ADM;DE L'EN, DE L'ENS SUP ET DE LA RECH",
			'031' => "C.A.S.U",
			'032' => "ATTACHE A.S.U",
			'033' => "SECRETAIRE ADMINISTRATIF (SASU) NV.ST.",
			'034' => "SECRETAIRE  A.S.U",
			'036' => "CONSEILLER A.U",
			'037' => "ATTACHE  A.U",
			'039' => "SECRETAIRE  A.U.",
			'041' => "INTENDANT UNIVERSITAIRE",
			'042' => "ATTACHE  I.U",
			'044' => "SECRETAIRE I.U.",
			'045' => "AGENT DE SERVICE DES ETABS D'ENSEIGN.",
			'046' => "AIDE D'ECONOMAT",
			'047' => "OUVRIER ENTRETIEN ACCUEIL DES ETABS ENS.",
			'050' => "ATTACHE ADMIN EDUC NAT ET ENS SUP",
			'051' => "ATTACHE D'ADMINISTRATION DE L'ETAT",
			'054' => "SECRETAIRE ADMINISTRATIF",
			'055' => "SECRETAIRE ADMINISTRATIF ",
			'056' => " ADJ. ADM DE L'EN ET DE L'ENS SUP ",
			'070' => "TECHNICIEN DE LABORATOIRE ENS.SUP.",
			'071' => "AIDE TECHNIQUE DE LABORATOIRE ENS. SUP.",
			'072' => "AIDE DE LABORATOIRE  ENS. SUP.",
			'073' => "GARCON DE LABORATOIRE  ENS. SUP.",
			'074' => "TECHNICIEN DE LABO DES ET. SC. (A.S)",
			'075' => "AIDE TECHNIQUE DE LABORAT. DES ET. SC.",
			'076' => "AIDE DE LABORATOIRE (ANC.ST)",
			'077' => "GARCON DE LABORATOIRE",
			'083' => "TECHNICIEN DE LABORATOIRE (1994)",
			'084' => "TECHNICIEN DE LABORATOIRE (1992)",
			'085' => "AIDE TECHNIQUE  DE LAB. (N.ST)",
			'086' => "AIDE  DE LABORATOIRE (N.STATUT)",
			'087' => "AGENT TECHNIQUE DE LABORATOIRE",
			'088' => "ADJ.TECH. LAB DES ETAB. ENS",
			'101' => "INSPECTEUR GENERAL DE L'ADMINISTRATION",
			'102' => "INSPECTEUR GENERAL DE L'EDUCATION NAT.",
			'103' => "INSPECTEUR GENERAL DES BIBLIOTHEQUES",
			'104' => "INSP. PEDAG. REGIONAL / INSP. D'ACADEMIE",
			'105' => "INSPECTEUR D'ACADEMIE DIR. SERV. DEPART.",
			'106' => "INSPECTEUR D'ACADEMIE ADJOINT",
			'107' => "INSPECTEUR D'ACADEMIE",
			'108' => "INSP.D'ACADEMIE/INSP.PEDAG. REGIONAL",
			'110' => "INSPECT. DE L'APPRENTISSAGE COMMISSIONNE",
			'111' => "INSPECTEUR DE L'ENSEIGNEMENT TECHNIQUE",
			'112' => "INSPECTEUR D'ORIENTATION ET D'INFORMATIO",
			'113' => "INSPECTEUR DEPARTEMENTAL DE L'E.N.",
			'114' => "INSPECTEUR PRINCIPAL DE L'ENSEIG. TECH.",
			'115' => "INSPECTEUR DE L'EDUCATION NATIONALE",
			'116' => "INSPECTEUR DE LA JEUNESSE ET DES SPORTS",
			'120' => "INPECTEUR GENERAL DE L'ADM ET DE LA RECH",
			'200' => "SECRETAIRE GENERAL DU MINISTERE",
			'201' => "MINISTRE",
			'202' => "SECRETAIRE D'ETAT",
			'203' => "ADMINISTRATEUR CIVIL",
			'204' => "DIRECTEUR GENERAL D'ADM. CENTRALE",
			'205' => "DIRECTEUR D'ADMINISTRATION CENTRALE",
			'206' => "CHEF DE SERVICE D'ADMINISTR. CENTRALE",
			'207' => "SOUS-DIRECTEUR D'ADMINISTR. CENTRALE",
			'208' => "DIRECTEUR ADJOINT D'ADMINISTR. CENTRALE",
			'209' => "DELEGUE D'ADMINISTRATION CENTRALE",
			'210' => "ATTACHE ADM.CENTRALE",
			'211' => "SECRETAIRE ADMINISTRAT. ADM.CENTR.(A.ST)",
			'212' => "ADJOINT ADMINISTRATIF ADM.CENTR.(N.S)",
			'213' => "AGENT ADMINISTRATIF ADM.CENTR.",
			'214' => "AGENT DE BUREAU ADM.CENTR.",
			'215' => "AGENT TECHNIQUE DE BUREAU DE L'ADM. CENT",
			'216' => "SECRETAIRE STENODACTYLOGRAPHE DE L'ADM.C",
			'217' => "SECRETAIRE ADMINISTRATIF (SAC) NV.STATUT",
			'218' => "DIRECTEUR DE PROJET ADMINIST. CENTRALE",
			'219' => "CHEF DE MISSION D'ADMINIST.CENTRALE",
			'220' => "ADJOINT ADMINISTRATIF DE L'AC",
			'221' => "DIRECTEUR DE CNOUS",
			'222' => "DIRECTEUR ADJOINT DE CNOUS",
			'223' => "DIRECTEUR DE RECHERCHE DU CNRS",
			'224' => "SOUS DIRECTEUR DE CNOUS",
			'230' => "ADJOINT TECHNIQUE DE L'AC",
			'231' => "CHEF DE SERVICE INTERIEUR",
			'232' => "AGENT DE SERVICE DES ADMINISTR.CENTRALES",
			'233' => "AGENT PRINCIPAL DES SERVICES TECHNIQUES",
			'234' => "HUISSIER DES ADMINISTRATIONS CENTRALES",
			'235' => "MAITRE-OUVRIER (NOUV. STATUT) ADM.CENTR.",
			'236' => "CONTREMAITRE DE L'ADMINISTR. CENTRALE",
			'237' => "OUVRIER PROFESSIONNEL (N.ST.) ADM. CENT.",
			'238' => "OUVRIER PROFESSIONNEL DE L'ADM. CENTRALE",
			'239' => "AGENT SUPERIEUR DE L'ADM. CENTRALE",
			'240' => "CHEF DE GROUPE DE L'ADM. CENTRALE",
			'241' => "MAITRE OUVRIER DE L'ADM. CENTRALE",
			'245' => "EXPERT DE HAUT NIVEAU",
			'251' => "ADJOINT ADMINISTRATIF A.C  (A.C)",
			'263' => "ADJOINT ADMINISTRATIF( RECHERCHE CNRS)",
			'264' => "SECRET.D'ADMINISTR. ( RECHERCHE CNRS)",
			'265' => "ATTACHE D'ADMINISTR. ( RECHERCHE CNRS)",
			'275' => "ASSISTANT INGENIEUR ( RECHERCHE CNRS)",
			'276' => "INGENIEUR D'ETUDES( RECHERCHE CNRS)",
			'277' => "INGENIEUR DE RECHERCHE ( RECHERCHE CNRS)",
			'278' => "ADJOINT TECHNIQUE ( RECHERCHE CNRS)",
			'279' => "TECHNICIEN ( RECHERCHE CNRS)",
			'280' => "INGENIEUR DES PONTS ET CHAUSSEES",
			'281' => "ARCHITECTE ET URBANISME DE L'ETAT",
			'282' => "INGENIEUR TRAVAUX PUBLICS DE L'ETAT",
			'283' => "INGENIEUR DES TELECOMMUNICATIONS",
			'284' => "ATTACHE INSEE",
			'285' => "ADMINISTRATEUR INSEE",
			'286' => "CHARGE DE MISSION INSEE",
			'287' => "INGENIEUR EN CHEF TPE",
			'288' => "MEDECIN INSPECTEUR DE SANTE PUBL. (N.ST)",
			'289' => "INFIRMIERE D'ETAT ",
			'290' => "INGENIEUR DES PONTS, EAUX ET FORETS",
			'293' => "INGENIEUR EN CHEF DES TVX PUBLICS  2G",
			'294' => "INGENIEUR EN CHEF DES TVX PUBLICS  1G",
			'295' => "INGENIEUR DES MINES",
			'296' => "CHARGE D'ETUDES DOCUMENTAIRES (CULTURE)",
			'297' => "RESTAURATEURS SPECIALISTES",
			'298' => "CHEF DE TRAVAUX D'ART",
			'299' => "TECHNICIEN D'ART",
			'300' => "PROFESSEUR DES UNIVERSITES",
			'301' => "MAITRE DE CONFERENCES DES UNIVERSITES",
			'302' => "MAITRE ASSISTANT",
			'303' => "ASSISTANT AGREGE ET ASSIMILE",
			'304' => "ASSISTANT NON AGREGE ET ASSIMILE",
			'305' => "ASSISTANT DE L'ENSEIGNEMENT SUPERIEUR",
			'310' => "PROF DES UNIV.- PRATICIEN HOSPITALIER",
			'311' => "MAITRE DE CONF PRATICIEN HOSPITALIER ",
			'312' => "CHEF DE TRAVAUX DES FACULTES",
			'313' => "CHEF DE TRAVAUX UNIV-PRATICIEN HOSPITAL.",
			'314' => "ASSISTANT DISCIPL. MED-BIOLOG. ET MIXTES",
			'315' => "PROF UNIV-PRATICIEN HOSPITAL. CSERD",
			'316' => "MAITRE DE CONF PRATICIEN HOSPITAL.CSERD ",
			'317' => "PROF DU 1ER GRADE CHIR DENT ODONTO",
			'318' => "PROF DU 2EME GRADE CHIR DENT ODONTO",
			'330' => "ASTRONOME",
			'331' => "PHYSICIEN",
			'332' => "ASTRONOME ADJOINT",
			'333' => "PHYSICIEN ADJOINT",
			'334' => "ASTRONOME TITULAIRE",
			'335' => "PHYSICIEN TITULAIRE",
			'336' => "ASTRONOME ADJOINT (DECRET DU 31/07/1936)",
			'337' => "PHYSICIEN ADJOINT (DECRET DU 25/12/1936)",
			'338' => "AIDE-ASTRONOME",
			'339' => "AIDE-PHYSICIEN",
			'340' => "ASSISTANT D'OBSERVATOIRE",
			'341' => "PROFESSEUR DE L'ECOLE CENTRALE 2E CAT.",
			'342' => "PROFESSEUR DE L'ECOLE CENTRALE 1E CAT.",
			'343' => "PROFESSEUR DU COLLEGE DE FRANCE",
			'344' => "SS-DIR DE LABORAT. DU COLLEGE DE FRANCE",
			'345' => "ASSISTANT DU COLLEGE DE FRANCE",
			'346' => "SOUS-DIRECTEUR DE LABORATOIRE DES E.N.S.",
			'347' => "CHEF DE TRAVAUX DE L'INSTIT.HYDROL.CLIM.",
			'348' => "ASSISTANT DE L'INSTIT. HYDROL. CLIM.",
			'350' => "PROF MUSEUM HISTOIRE NATURELLE",
			'351' => "MAITRE DE CONF MUSEUM HISTOIRE NATURELLE",
			'352' => "ASSISTANT MUSEUM HISTOIRE NATURELLE",
			'353' => "DIRECTEUR D'ETUDES DE L'EHESS",
			'354' => "MAITRE DE CONFERENCES DE L' EHESS",
			'355' => "DIR. D'ETUDES EPHE ET ECOLE DES CHARTES",
			'356' => "MAITRE DE CONF EPHE ET ECOLE DES CHARTES",
			'357' => "PREP.-CHEF TRAVAUX LICENCIE EHESS/EPHE",
			'358' => "PREP.-CH.TRAVAUX NON LICENCIE EHESS/EPHE",
			'359' => "CONSEILLER TECH. & PEDAGO. SUPERIEU",
			'360' => "PROFESSEUR DU CNAM",
			'361' => "SOUS-DIRECTEUR DE LABORATOIRE DU CNAM",
			'362' => "CHEF DE TRAVAUX DU CNAM",
			'363' => "ASSISTANT DU CNAM",
			'364' => "PROFESSEUR DE L'ENSAM",
			'365' => "PROFESSEUR TECHNIQUE ADJOINT DE L'ENSAM",
			'366' => "CHEF DE TRAVAUX PRATIQUES DE L'ENSAM",
			'380' => "PROFESSEUR DES UNIVERSITES ASSOCIE ",
			'381' => "MAITRE DE CONFERENCES DES UNIV. ASSOCIE",
			'382' => "PROF ASSOCIE DES UNIV. DIS. MED. ",
			'383' => "MAITRE DE CF ASSOCIE DES UNIV.DIS.MED.  ",
			'384' => "PROF ASSOCIE DES UNIV. DIS. ODONTO. ",
			'385' => "MAITRE DE CF ASSOCIE DES UNIV.DIS.ODONT.",
			'386' => "ASTRONOME ASSOCIE",
			'387' => "PHYSICIEN ASSOCIE",
			'388' => "ASTRONOME ADJOINT ASSOCIE",
			'389' => "PHYSICIEN ADJOINT ASSOCIE",
			'390' => "PROFESSEUR DU COLLEGE DE FRANCE ASSOCIE ",
			'391' => "PROF MUSEUM HISTOIRE NATURELLE ASSOCIE ",
			'392' => "MAITRE DE CONF MUSEUM HIST.NAT. ASSOCIE ",
			'393' => "DIRECTEUR D'ETUDES DE L'EHESS ASSOCIE ",
			'394' => "MAITRE DE CONF. DE L' EHESS ASSOCIE ",
			'395' => "DIR.D'ETUDES EPHE-ECOL.CHARTES ASSOCIE ",
			'396' => "MAITRE DE CONF EPHE-EC. CHARTES ASSOCIE ",
			'397' => "PROFESSEUR DU CNAM ASSOCIE ",
			'400' => "ECR INSTITUTEUR",
			'402' => "ECR INSTRUCTEUR",
			'404' => "ECR INSTITUTEUR SUPPLEANT",
			'405' => "ECR PROFESSEUR DES ECOLES",
			'406' => "ADM CONTR 1ER DEGRE SESSION EX 2014 PR",
			'431' => "ECR PROFESSEUR D'EPS",
			'432' => "ECR CHARGE D'ENSEIGNEMENT EPS",
			'433' => "ECR PROFESSEUR ADJOINT D'EPS",
			'450' => "ECR CHAIRE SUPERIEUR",
			'451' => "ECR AGREGE",
			'453' => "ECR PROFESSEUR CERTIFIE",
			'454' => "ECR PROFESSEUR TECHNIQUE ADJOINT",
			'456' => "ECR PROFESSEUR CHEF DE TRAVAUX DE LYCEE",
			'457' => "ECR PROFESSEUR CHEF DE TRAVAUX DEGRE SUP",
			'459' => "ECR PROFESSEUR D'ENS GENERAL DES COLLEGE",
			'462' => "ECR CHARGE D'ENSEIGNEMENT HORS EPS",
			'467' => "ECR ADJOINT D'ENSEIGNEMENT",
			'471' => "ECR PROFESSEUR DE LYCEE PROF CHEF DE TRA",
			'472' => "ECR PROFESSEUR D'ENS. GENERAL DE CET",
			'473' => "ECR PROFESSEUR D'ENS. TECH THEOR DE CET",
			'474' => "ECR PROFESSEUR TECH D'ENS. PRATIQ DE CET",
			'475' => "ECR PROFESSEUR DE LYCEE PROF",
			'476' => "ECR PROFESSEUR TECHNIQUE CHEF DE TRAVAUX",
			'477' => "ECR PROFESSEUR TECHN. DE LYCEE TECHNIQUE",
			'478' => "ECR PROFESSEUR DE CET",
			'480' => "BENEFICIAIRE DE L'OBLIGATION D'EMPLOI",
			'496' => "ECR MAITRE AUXILIAIRE",
			'497' => "ADM CONTR 2ND DEGRE SESSION EX 2014 PR",
			'520' => "PERSONNEL D'ORIENTATION (D-72)",
			'521' => "PERSONNEL D'ORIENTATION",
			'531' => "PROFESSEUR D'EPS",
			'532' => "CHARGE D'ENSEIGNEMENT EPS",
			'533' => "PROFESSEUR ADJOINT D'EPS",
			'534' => "MAITRE D'EPS",
			'550' => "PROFESSEUR DE CHAIRE SUPERIEURE",
			'551' => "PROFESSEUR AGREGE",
			'553' => "PROFESSEUR CERTIFIE",
			'554' => "PROFESSEUR TECHNIQUE ADJOINT",
			'555' => "PROFESSEUR TECHNIQUE ADJOINT D'ENNA",
			'556' => "PROFESSEUR CHEF DE TRAVAUX DE LYCEE TECH",
			'557' => "PROFESSEUR CHEF DE TRAVAUX DEGRE SUP",
			'558' => "PROFESSEUR D'ENNA",
			'559' => "PROFESSEUR D'ENS. GENERAL DES COLLEGES",
			'562' => "CHARGE D'ENSEIGNEMENT HORS EPS",
			'563' => "CONSEILLER PRINCIPAL D'EDUCATION",
			'564' => "CONSEILLER D'EDUCATION",
			'567' => "ADJOINT D'ENSEIGNEMENT",
			'571' => "PROFESSEUR DE LYCEE PROF CHEF DE TRAVAUX",
			'572' => "PROFESSEUR D'ENSEIGNEMENT DE CET",
			'573' => "PROFESSEUR D'ENS. TECH THEORIQUE DE CET",
			'574' => "PROFESSEUR TECHNIQUE D'ENS. PROF DE CET",
			'575' => "PROFESSEUR DES LYCEES PROFESSIONNELS",
			'576' => "PROFESSEUR TECHNIQUE CHEF DE TRAVAUX",
			'577' => "PROFESSEUR TECHNIQUE DE LYCEE TECHNIQUE",
			'578' => "PROFESSEUR DE CET",
			'590' => "ELEVE PROFESSEUR",
			'600' => "INSTITUTEUR",
			'602' => "INSTRUCTEUR",
			'604' => "INSTITUTEUR AUXILIAIRE SUPPLEANT",
			'615' => "PROFESSEUR DES ECOLES",
			'620' => "PERS. DIRECTION 1ERE CATEGORIE(CT)",
			'621' => "PERS. DIRECTION 2EME CATEGORIE (CT)",
			'622' => "PERS. DIRECTION (CT)",
			'623' => "INSPECTEUR DE L'EN (CT)",
			'624' => "PERSONNEL D'ORIENTATION (CT)",
			'625' => "PROF D'EPS (CT)",
			'626' => "CHARGE ENS EPS (CT)",
			'627' => "PROFESSEUR DE CHAIRE SUPERIEURE",
			'628' => "PROFESSEUR AGREGE (CT)  ",
			'629' => "PROFESSEUR CERTIFIE (CT)",
			'630' => "PROF.D'ENS GEN DE COLLEGE (CT)",
			'631' => "CONSEILLER PRINCIPAL D'EDUCATION (CT)",
			'632' => "CONSEILLER D'EDUCATION  (CT)",
			'633' => "ADJOINT D'ENSEIGNEMENT (CT)",
			'634' => "PROF LYCEES PROFESSIONNELS (CT)",
			'635' => "INSTITUTEUR (CT)",
			'636' => "PROFESSEUR DES ECOLES (CT)",
			'637' => "SURVEILLANT (CT)",
			'638' => "ADJOINT D'EDUCATION (CT)",
			'639' => "INSTITUTEUR C.T. MAYOTTE",
			'640' => "INSTITUTEUR D'ETAT RECRUTE A MAYOTTE",
			'641' => "AGENT ADMINISTRATIF DE MAYOTTE",
			'642' => "AGENT TECHNIQUE DES ADMINISTRATIONS",
			'650' => "INSTIT. CHARGE ENSEIGNEMENT EN COLLEGE",
			'651' => "MONITEUR (DIPLOME D'UN CEP)",
			'652' => "INSTITUTEUR BREVETE",
			'653' => "INSTITUTEUR PERENNISE (NIVEAU CEP)",
			'654' => "INSTITUTEUR (PF)",
			'655' => "PROFESSEUR DES ECOLES (PF)",
			'656' => "CONTRACTUEL PF1D CAT A",
			'657' => "CONTRACTUEL PF1D CAT B",
			'660' => "CADRE2 (CT)",
			'670' => "CADRE1 (CT)",
			'680' => "CADRE DES BACHELIERS (CT)",
			'690' => "CONTRACTUEL (CT)",
			'695' => "CONTRACTUEL CT GARANTI D'EMPLOI",
			'700' => "PROFESSEUR DES UNIVERSITES ASSOCIE-MT ",
			'701' => "MAITRE DE CONF. DES UNIV. ASSOCIE-MT ",
			'702' => "PROF. ASS. DES UNIV. DE MEDECINE GENER.",
			'703' => "M. DE CONF. ASS. UNIV. MEDECINE GENER.",
			'704' => "ASTRONOME ASSOCIE-MT",
			'705' => "PHYSICIEN ASSOCIE-MT",
			'706' => "ASTRONOME ADJOINT ASSOCIE-MT",
			'707' => "PHYSICIEN ADJOINT ASSOCIE-MT",
			'708' => "PROFESSEUR DU COLLEGE DE FRANCE ASS-MT ",
			'709' => "PROF MUSEUM HISTOIRE NATURELLE ASS-MT ",
			'710' => "MAITRE DE CONF MUSEUM HIST.NAT. ASS-MT ",
			'711' => "DIRECTEUR D'ETUDES DE L'EHESS ASS-MT ",
			'712' => "MAITRE DE CONF. DE L' EHESS ASSOCIE-MT ",
			'713' => "DIR.D'ETUDES EPHE-ECOL.CHARTES ASS-MT ",
			'714' => "MAITRE DE CONF EPHE-EC. CHARTES ASS-MT ",
			'715' => "PROFESSEUR DU CNAM ASSOCIE-MT ",
			'720' => "PROFESSEUR DES UNIVERSITES INVITE",
			'721' => "MAITRE DE CONFERENCES DES UNIV. INVITE",
			'722' => "PROFESSEUR INVITE DISC. MED.",
			'723' => "MAITRE DE CONF. INVITE DISC. MED.",
			'724' => "PROF INVITE DISC. ODONTO.",
			'725' => "MAITRE DE CONF INVITE DISC. ODONTO.",
			'726' => "ASTRONOME INVITE",
			'727' => "PHYSICIEN INVITE",
			'728' => "ASTRONOME ADJOINT INVITE",
			'729' => "PHYSICIEN ADJOINT INVITE",
			'730' => "PROFESSEUR DU COLLEGE DE FRANCE INVITE",
			'731' => "PROF MUSEUM HISTOIRE NATURELLE INVITE",
			'732' => "MAITRE DE CONF MUSEUM HIST. NAT. INVITE",
			'733' => "DIRECTEUR D'ETUDES DE L'EHESS INVITE",
			'734' => "MAITRE DE CONFERENCES DE L' EHESS INVITE",
			'735' => "DIR.D'ETUDES EPHE-ECOL.CHARTES INVITE",
			'736' => "MAITRE DE CONF EPHE-ECOL.CHARTES INVITE",
			'737' => "PROFESSEUR DU CNAM INVITE",
			'740' => "ASSISTANT HOSPITALIER UNIV. CSERD",
			'741' => "PRATICIEN HOSPITALIER UNIVERSITAIRE",
			'742' => "ASSISTANT HOSPITALIER UNIVERSITAIRE",
			'743' => "CHEF CLINIQUE UNIV. ASSISTANT HOPITAUX",
			'744' => "ASSISTANT ASSOCIE DES UNIV. DIS. ODONTO.",
			'745' => "ASSIS.CHEF CLINIQUE ASSOCIE UNIV.DIS.MED",
			'750' => "MAITRE DE LANGUE",
			'751' => "LECTEUR",
			'752' => "REPETITEUR DE L'INALCO",
			'753' => "ATTACHE TEMPORAIRE ENSEIGN. ET RECHERCHE",
			'754' => "ALLOCATAIRE MONITEUR NORMALIEN",
			'755' => "MONITEUR ",
			'756' => "MONITEUR EN PHARMACIE",
			'757' => "CONTRACTUEL DECRET 1992",
			'758' => "CHARGE D'ENSEIGNEMENT VACATAIRE",
			'759' => "AGENT TEMPORAIRE VACATAIRE",
			'773' => "INTERVENANT LANGUE PRIMAIRE",
			'774' => "ASSISTANT LANGUE VIVANTE",
			'775' => "CONSEILLER D'ORIENTATION INTERIMAIRE",
			'776' => "MAITRE AUXILIAIRE",
			'777' => "CORPS DES ASSISTANTS ETRANGERS",
			'778' => "PROFESSEUR ASSOCIE",
			'779' => "PROFESSEUR CONTRACTUEL",
			'786' => "MAITRE D'INTERNAT",
			'787' => "SURVEILLANT D'EXTERNAT",
			'789' => "ACCOMPAGNANT EN SITUATION DE HANDICAP",
			'790' => "ASSISTANT D'EDUCATION",
			'791' => "ADMISSIBLE CONTRACTUEL 1D EXCEPT 2014",
			'792' => "ADMISSIBLE CONTRACTUEL 2D EXCEPT 2014",
			'800' => "CONSERVATEUR GENERAL DES BIBLIOTHEQUES",
			'801' => "CONSERVATEUR DES BIBLIOTHEQUES (1992)",
			'802' => "CONSERVATEUR DES MUSEES (1992)",
			'803' => "CONSERVATEUR DES BIBLIOTHEQUES (1969)",
			'804' => "CONSERVATEUR STAGIAIRE ELEVE ENSSIB",
			'806' => "BIBLIOTHECAIRE",
			'807' => "BIBLIOTHECAIRE ADJOINT ANC. STATUT 1950",
			'808' => "BIBLIOTHECAIRE ADJOINT (NV.STATUT 1995)",
			'809' => "BIBLIOTHECAIRE ADJOINT SPECIALISE",
			'810' => "BIBLIOTHECAIRE ASSISTANT SPECIALISE",
			'813' => "MAGASINIER EN CHEF",
			'814' => "MAGASINIER SPECIALISE",
			'815' => "INSPECTEUR DE MAGASINAGE",
			'816' => "MAGASINIER",
			'817' => "GARDIEN DE BIBLIOTHEQUE",
			'818' => "ASSISTANT DES BIBLIOTHEQUES",
			'820' => "MAGASINIER DES BIBLIOTHEQUES",
			'821' => "AGENT DE BUREAU DE RECH.ET DE FORMATION",
			'822' => "AGENT D'ADMINISTRATION RECH.ET FORMATION",
			'823' => "ADJOINT ADMINISTRATIF RECH.ET FORMATION",
			'825' => "ATTACHE D'ADMINISTR. RECH.ET FORMATION",
			'826' => "CHARGE D'ADMINISTR. RECH.ET FORMATION",
			'827' => "SECRET.D'ADMINISTR. RECH.ET FORMATION",
			'828' => "AGENT DES SERV.TECH. RECH.ET FORMATION",
			'830' => "TECHNICIEN DE RECHERCHE & FORMATION(NES)",
			'831' => "AIDE TECHNIQUE DE RECH.ET DE FORMATION",
			'832' => "AGENT TECHNIQUE DE RECH.ET DE FORMATION",
			'834' => "ASSISTANT INGENIEUR (RECH ET FORM)",
			'835' => "INGENIEUR D'ETUDES (RECH ET FORM)",
			'836' => "INGENIEUR DE RECHERCHE (RECH ET FORM)",
			'837' => "ADJOINT TECHNIQUE DE RECH.ET FORMATION",
			'838' => "TECHNICIEN DE RECH.ET FORMATION",
			'839' => "ADJOINT TECHNIQUE-RECHERCHE & FORMATION",
			'840' => "INGENIEUR CONTRACTUEL CNRS",
			'841' => "TECHNIQUE CONTRACTUEL CNRS",
			'842' => "ADMINISTRATIF CONTRACTUEL CNRS",
			'843' => "CONTRACT. D.DETERM. ENS.SUP (>86) CAT A",
			'844' => "CONTRACT. D.DETERM. ENS.SUP. (>86) CAT B",
			'845' => "CONTRACT. D.DETERM. ENS.SUP. (>86) CAT D",
			'846' => "CONTRACTUEL TEMPORAIRE ENS. SUPERIEUR",
			'847' => "CONTROLEUR CONTRACTUEL DE L'ADM. CENTR.",
			'850' => "AGENT CONTRACTUEL ADMINISTRATIF",
			'851' => "CONTRACTUEL VIGILE",
			'852' => "AGENT CONTRACTUEL TECHNIQUE",
			'853' => "AGENT CONTRACTUEL FORMATION CONTINUE",
			'855' => "CONTRACTUEL EX-UGAP",
			'856' => "MEDECIN CONTACTUEL",
			'857' => "MEDECIN CONTRACTUEL SANTE SCOLAIRE",
			'858' => "INFIRMIERE AUXILIAIRE",
			'859' => "INFIRMIERE CONTRACTUELLE",
			'860' => "ASSISTANTE SOCIALE CONTRACTUELLE",
			'861' => "AUXILIAIRE DE BUREAU",
			'862' => "AUXILIAIRE DE SERVICE",
			'863' => "CONTRACTUEL RECHERCHE CHARGE DE MISSION",
			'864' => "AGENT CONTRACTUEL RECHERCHE",
			'865' => "CONTRACTUEL DECRET 62",
			'866' => "CONTRACTUEL A DUREE DETERMINEE",
			'867' => "CONTRACTUEL INDIVIDUEL",
			'868' => "CONTRACTUEL CABINET",
			'869' => "TRAVAILLEUR HANDICAPE",
			'870' => "AGENT CONTRACTUEL DE BIBLIOTHEQUES",
			'871' => "AGENT SUR CONTRAT DES BIBLIOTHEQUES",
			'872' => "ARCHITECTE CONTRACTUEL",
			'873' => "INFORMATICIEN DE HAUT NIVEAU",
			'874' => "INSPECT. DE L'APPRENTISSAGE CONTRACTUEL",
			'875' => "PARCOURS D'ACCES A L' EMPLOI",
			'879' => "CONTRACTUEL BOE - DECRET DE 1995",
			'887' => "MAD ENTRANT AUTRE ADMINISTRATION",
			'888' => "APPRENTI",
			'898' => "VACATAIRE",
			'899' => "INDEMNITAIRE",
			'910' => "COMMIS DES SERVICES EXTERIEURS",
			'911' => "AGENT ADMINISTRATIF DES SERV. EXT.",
			'912' => "ADJOINT ADMINISTRATIF DES SERV. EXT.",
			'915' => "ADJOINT AMINISTRATIF DES SER. DEC.",
			'920' => "STENODACTYLOGRAPHE DES SERV. EXT.",
			'925' => "ADJOINTE DU SERV. DE SANTE SCOL. ET UNIV",
			'930' => "AGENT DE BUREAU DES SERV. EXT.",
			'940' => "AGENT TECHNIQUE DE BUREAU DES SERV. EXT.",
			'953' => "OUVRIER PROFESSIONNEL DES SERV. EXT.",
			'954' => "CONTREMAITRE DES SERV. EXT.",
			'955' => "OUVRIER PROFESSIONNEL DES ETABS D'ENS.",
			'956' => "MAITRE OUVRIER DES ETABS D'ENSEIGNEMENT",
			'957' => "TECHNICIEN DE L'EDUCATION NATIONALE",
			'960' => "ADJOINT TECHNIQUE DES ETAB.ENS.",
			'961' => "AGENT DE SERVICE DES SERV. EXT.",
			'962' => "AGENT DES SERV.TECHNIQUES DES SERV.EXT.",
			'970' => "CONDUCTEUR AUTO DES ADM. DE L'ETAT",
			'975' => "CHEF DE GARAGE DES ADM. DE L'ETAT",
			'980' => "TELEPHONISTE DES ADM. DE L'ETAT",
			'984' => "CONSEILLER POUR L'ACTION SOCIALE",
			'985' => "SECRETAIRE DE DOCUMENTATION NOUV.STATUT",
			'986' => "INFIRMIERS ENES CATEGORIE A",
			'987' => "ASSISTANT SERVICE SOCIAL ADMIN DE L'ETAT",
			'988' => "CONS TECH DE SERV SOC AE",
			'989' => "INFIRMIERE OU INFIRMIER (NOUVEAU STATUT)",
			'990' => "ASSISTANT DE SERVICE SOCIAL",
			'991' => "SECRETAIRE DE DOCUMENTATION (ANC.STATUT)",
			'992' => "INFIRMIER ET INFIRMIERE (ANCIEN STATUT)",
			'993' => "DOCUMENTALISTE",
			'994' => "CHEF D'ETUDES DOCUMENTAIRES",
			'995' => "CHARGE D ETUDES DOCUMENTAIRES",
			'996' => "CONSEILLER TECHNIQUE DE SERVICE SOCIAL",
			'997' => "MEDECIN DE L'EDUCATION NATIONALE",
			'998' => "MEDECIN DE L'E.N.- CONSEILLER TECHNIQUE",
			'999' => "SANS CORRESPONDANCE CORPS",
			'***' => "CONVENTION ETOILE, DECLINAISON TOUT CODE",
		)
	),
	'CNU' => array(
		'supannActivite' => array(
			"5401" => "PEDIATRIE",
			"5601" => "PEDODONTIE",
			"4904" => "PEDOPSYCHIATRIE",
			"4007" => "PHARMACIE CLINIQUE",
			"4006" => "PHARMACOGNOSIE",
			"4004" => "PHARMACOLOGIE & PHARMACOCINETI",
			"4803" => "PHARMACOLOGIE FONDAMENTALE - P",
			"3905" => "PHARMACOTECHNIE",
			"1700" => "PHILOSOPHIE",
			"4003" => "PHYSIOLOGIE",
			"4402" => "PHYSIOLOGIE",
			"6600" => "PHYSIOLOGIE",
			"9959" => "PLASTURGIE",
			"5101" => "PNEUMOLOGIE",
			"5603" => "PREVENTION, EPIDEMIOLOGIE, ECO",
			"5802" => "PROTHESES (PROTHESE CONJOINTE,",
			"4903" => "PSYCHIATRIE D'ADULTES",
			"1600" => "PSYCHOLOGIE",
			"4302" => "RADIOLOGIE ET IMAGERIE MEDICAL",
			"4802" => "REANIMATION MEDICALE",
			"5001" => "RHUMATOLOGIE",
			"0000" => "SANS DISCIPLINE",
			"4600" => "SANTE PUBLIQUE",
			"0400" => "SCIENCE POLITIQUE",
			"5803" => "SCIENCES ANATOMIQUES ET PHYSIO",
			"4100" => "SCIENCES BIOLOGIQUES",
			"5703" => "SCIENCES BIOLOGIQUES (BIOCHIMI",
			"5700" => "SCIENCES BIOLOGIQUES, MEDECINE",
			"0600" => "SCIENCES DE GESTION",
			"7000" => "SCIENCES DE L'EDUCATION",
			"7100" => "SC. DE L'INFO.&DE LA COM.",
			"0700" => "LINGUISTIQUE & PHONET. GEN.",
			"4000" => "SCIENCES DU MEDICAMENT",
			"0500" => "SCIENCES ECONOMIQUES",
			"7400" => "ACTIVITES SPORT. ET PHYS.",
			"4200" => "SCIENCES MORPHOLOGIQUES",
			"3900" => "SC. PH-CHIM.&TECH. PHARM.",
			"5800" => "SCIENCES PHYSIQUES ET PHYSIOLO",
			"1900" => "SOCIOLOGIE DEMOGRAPHIE",
			"5500" => "SPECIALITES MEDICO-CHIRURGICAL",
			"5503" => "STOMATOLOGIE ET CHIRURGIE MAXI",
			"3500" => "STRUC EVOL TERRE",
			"9975" => "TECHNOLOGIE CHIMIQUE",
			"3600" => "TERRE SOLIDE",
			"7501" => "THEOLOGIE CATHOLIQUE",
			"7502" => "THEOLOGIE PROTESTANTE",
			"4804" => "THERAPEUTIQUE",
			"9990" => "TOPOGRAPHIE",
			"4005" => "TOXICOLOGIE",
			"9958" => "TRANSFORM. POLYMERES",
			"5204" => "UROLOGIE",
			"XXXX" => "CONVENTION",
			"7600" => "THEOLOGIE CATHOLIQUE",
			"7700" => "THEOLOGIE PROTESTANTE",
			"7500" => "THEOLOGIE",
			"2400" => "AMENAG. ESPACE URBANISME",
			"4201" => "ANATOMIE",
			"4203" => "ANATOMIE ET CYTOLOGIE PATHOLOG",
			"4801" => "ANESTHESIOLOGIE ET REANIMATION",
			"4800" => "ANESTHESIOLOGIE, PHARMACOLOGIE",
			"2000" => "ANTHROP. ETHNOL. PREHIST.",
			"9988" => "ARCHITECTURE",
			"1800" => "ARTS ET SCIENCES DE L'ART",
			"3400" => "ASTRONOMIE, ASTROPHYS.",
			"9969" => "AUTOMATIQUE",
			"9970" => "AUTOMATIQUE OPT. TEXT.",
			"4104" => "BACTERIOLOGIE & VIROLOGIE",
			"4501" => "BACTERIOLOGIE, VIROLOGIE-HYGIE",
			"4401" => "BIOCHIMIE ET BIOLOGIE MOLECULA",
			"6400" => "BIOCHIM. & BIOL. MOLECUL.",
			"4106" => "BIOCHIMIE GENERALE & CLINIQUE",
			"4400" => "BIOCHIMIE, BIOLOGIE CELLULAIRE",
			"4403" => "BIOLOGIE CELLULAIRE",
			"6500" => "BIOLOGIE CELLULAIRE",
			"4101" => "BIOLOGIE CELLULAIRE & MOLECULA",
			"6800" => "BIOLOGIE DES ORGANISMES",
			"6700" => "BIOLOGIE POPUL. & ECOLOGIE",
			"5405" => "BIOLOGIE DU DEVELOPPEMENT ET D",
			"3902" => "BIOMATHEMATIQUES",
			"3901" => "BIOPHYSIQUE",
			"4300" => "BIOPHYSIQUE ET IMAGERIE MEDICA",
			"4301" => "BIOPHYSIQUE ET TRAITEMENT DE L",
			"4604" => "BIOSTATISTIQUES ET INFORMATIQU",
			"4107" => "BOTANIQUE et CRYPTOGAMIE",
			"9994" => "BUREAU DES TRAVAUX",
			"4702" => "CANCEROLOGIE - RADIOTHERAPIE",
			"5102" => "CARDIOLOGIE ET MALADIES VASCUL",
			"9972" => "CHIM. OPT. MATERIAUX",
			"9973" => "CHIM. OPTION TEXTILE",
			"3904" => "CHIMIE ANALYTIQUE & BROMATOLOG",
			"3300" => "CHIMIE DES MATERIAUX",
			"3903" => "CHIMIE GENERALE ET MINERALE",
			"4001" => "CHIMIE ORGANIQUE",
			"3200" => "CHIMIE ORGA., MIN., INDUSTR.",
			"3100" => "CHIMIE THEOR., PHYS., ANAL.",
			"4002" => "CHIMIE THERAPEUTIQUE",
			"5702" => "CHIRURGIE BUCCALE, PATHOLOGIE",
			"5202" => "CHIRURGIE DIGESTIVE",
			"5302" => "CHIRURGIE GENERALE",
			"5402" => "CHIRURGIE INFANTILE",
			"5002" => "CHIRURGIE ORTHOPEDIQUE ET TRAU",
			"5004" => "CHIRURGIE PLASTIQUE, RECONSTRU",
			"5103" => "CHIRURGIE THORACIQUE ET CARDIO",
			"5104" => "CHIRURGIE VASCULAIRE",
			"2900" => "CONSTITUANTS ELEMENTAIRES",
			"9981" => "CONSTRUC. ELECTRIQUE",
			"9956" => "CONSTRUCTION MECANIQUE",
			"9989" => "CONSTR. TRAV. PUBL. BAT.",
			"9992" => "CONS.GC EQU.TECH.BAT.",
			"9993" => "CONS. GC.HYD. APP. ME. SO.",
			"7300" => "CULTURES & LANGUES REGION.",
			"5003" => "DERMATO-VENEREOLOGIE",
			"5600" => "DEVELOPPEMENT , CROISSANCE ET",
			"4009" => "DROIT & ECONOMIE DE LA SANTE",
			"0100" => "DROIT PRIVE & SC. CRIMIN.",
			"0200" => "DROIT PUBLIC",
		),
	),
	"REFERENS" => array(
		"supannActivite" => array(
			"C4G10" => "Souffleur de verre",
			"C4G11" => "Technicien en optique de prcision",
			"C5X02" => "Prparateur en lectronique/lectrotechnique",
			"C5A01" => "Adjoint technique en techniques exprimentales",
			"C5A02" => "Prparateur-conducteur d'expriences",
			"C5E04" => "Prparateur d'ensemble mcanique et mcano-soud",
			"C5E05" => "Oprateur sur machine-outil",
			"C5F06" => "Mtallier",
			"D1A01" => "Ingnieur d'analyse et de dveloppement en sciences humaines et sociales",
			"D1C03" => "Ingnieur en analyse de sources anciennes",
			"D1C04" => "Ingnieur en archologie de terrain",
			"D1C05" => "Ingnieur en archomtrie",
			"D2B02" => "Ingnieur en reprsentations de donnes  rfrence spatiale",
			"D2C03" => "Ingnieur d'tudes en sources anciennes",
			"D2C04" => "Ingnieur en techniques archologiques de terrain",
			"D2C05" => "Ingnieur en techniques archomtriques",
			"D2C06" => "Ingnieur en techniques anthropologiques ou archozoologiques",
			"D3B02" => "Assistant en reprsentation de donnes  rfrence spatiale : cartographe",
			"D3C03" => "Assistant en techniques archologiques de terrain",
			"D4A01" => "Technicien charg d'enqutes",
			"E1A01" => "Chef de projet en dveloppement d'applications",
			"E1A02" => "Ingnieur expert en dveloppement d'applications",
			"E1B04" => "Ingnieur rseaux- ressources informatiques et systmes d'information",
			"E1C05" => "Expert systme- rseaux et tlcommunications",
			"E1D06" => "Architecte de systmes d'information",
			"E1E07" => "Ingnieur de recherche en calcul scientifique",
			"E2A01" => "Ingnieur en dveloppement d'applications",
			"E2B02" => "Informaticien de laboratoire",
			"E2B03" => "Administrateur rseaux- ressources informatiques et systmes d'information",
			"E2D05" => "Administrateur de systmes d'information",
			"E2E06" => "Ingnieur statisticien",
			"E2E07" => "Ingnieur d'tudes en calcul scientifique/numricien",
			"E3X03" => "Gestionnaire de parc informatique et tlcommunications",
			"E3X05" => "Assistant informatique de proximit",
			"E3B02" => "Assistant informaticien de laboratoire",
			"E3D04" => "Gestionnaire de bases de donnes",
			"E3E06" => "Assistant statisticien",
			"E4X01" => "Technicien d'exploitation et de maintenance",
			"F1A01" => "Responsable de ressources documentaires",
			"F1A02" => "Ingnieur en bibliothconomie",
			"F1B04" => "Traducteur terminologue",
			"F1C05" => "Responsable de produits d'dition",
			"F1G07" => "Responsable de communication",
			"F1G08" => "Mdiateur scientifique",
			"F2A01" => "Documentaliste",
			"F2A02" => "Bibliothconomiste",
			"F2A03" => "Archiviste",
			"F2C05" => "Secrtaire d'dition et/ou de rdaction",
			"F2D06" => "Ingnieur designer/arts graphiques",
			"F2E07" => "Charg de fabrication",
			"F2F08" => "Concepteur/rdacteur de site web",
			"F2F10" => "Photographe scientifique",
			"F2G11" => "Charg de diffusion de produits culturels",
			"F2G12" => "Charg de communication",
			"F2G14" => "Charg de la mdiation scientifique",
			"F3C02" => "Assistant de rdaction/dition",
			"F3D03" => "Dessinateur/maquettiste/infographiste",
			"F3E04" => "Assistant de fabrication",
			"F3F06" => "Photographe",
			"F3G07" => "Assistant de diffusion de produits culturels",
			"F3G08" => "Assistant de communication",
			"F4A01" => "Technicien de bibliothque",
			"F4C02" => "Technicien en PAO",
			"F4D03" => "Technicien en graphisme",
			"F4F05" => "Technicien d'exploitation audiovisuelle ou multimdia",
			"F4F06" => "Technicien photographe",
			"F5A01" => "Manutentionnaire de bibliothque ou de documentation",
			"F5E03" => "Oprateur d'exploitation et de fabrication",
			"F6E02" => "Aide de reprographie",
			"G1A01" => "Architecte concepteur",
			"G1D03" => "Ingnieur de recherche en hygine et scurit",
			"G2A01" => "Conducteur d'oprations",
			"G2C03" => "Responsable d'exploitation de restaurants",
			"G2D04" => "Ingnieur hygine et scurit",
			"G2D05" => "Ingnieur en radioprotection",
			"G3X04" => "Assistant espaces verts/paysagiste",
			"G3A01" => "Assistant technique en maintenance et travaux immobiliers",
			"G3A03" => "Assistant technique en lectricit de btiment",
			"G3B05" => "Coordinateur des moyens gnraux",
			"G3C06" => "Grant responsable de production de restauration",
			"G4X08" => "Technicien jardinier",
			"G4A01" => "Conducteur de travaux",
			"G4A02" => "Technicien en amnagement intrieur de btiment",
			"A5C02" => "Animalier",
			"A5D03" => "Prparateur de production vgtale",
			"A6X03" => "Agent d'unit de production et d'levage",
			"A6C02" => "Agent animalier",
			"A6D04" => "Agent technique de production vgtale",
			"B1A01" => "Ingnieur en analyse de biomolcules",
			"B1C03" => "Ingnieur en analyse chimique",
			"B1D04" => "Ingnieur en synthse chimique",
			"B1E05" => "Ingnieur en sciences des matriaux/caractrisation",
			"B2A01" => "Ingnieur en techniques d'analyse de biomolcules",
			"B2B02" => "Ingnieur en techniques d'laboration de biomolcules",
			"B2C03" => "Ingnieur en techniques d'analyse chimique",
			"B2D04" => "Ingnieur en techniques de synthse chimique",
			"B2E05" => "Ingnieur en techniques des sciences des matriaux/caractrisation",
			"B2F06" => "Ingnieur en laboration de matriaux en couches minces",
			"B2F07" => "Ingnieur en laboration de matriaux massifs",
			"B3X04" => "Assistant chimiste",
			"B3A01" => "Assistant en techniques d'analyse de biomolcules",
			"B3B02" => "Assistant en techniques d'laboration de biomolcules",
			"B3C03" => "Assistant en techniques d'analyse chimique",
			"B3E06" => "Assistant en techniques des sciences des matriaux/caractrisation",
			"B3F07" => "Assistant en laboration de matriaux en couches minces",
			"B4X01" => "Technicien en technologie des biomolcules",
			"B4E03" => "Technicien en sciences des matriaux/caractrisation",
			"B4F04" => "Technicien en laboration de matriaux",
			"B5X01" => "Prparateur en chimie",
			"B5X02" => "Prparateur en traitement des matriaux",
			"B6X01" => "Agent de laboratoire",
			"B7X01" => "Agent de laboratoire",
			"C1A02" => "Ingnieur de recherche et de dveloppement en instrumentation scientifique et techniques exprimentales",
			"C1B03" => "Ingnieur lectrotechnicien en conception et dveloppement",
			"C1C04" => "Ingnieur lectronicien en conception et dveloppement",
			"C1E06" => "Ingnieur mcanicien de dveloppement et fabrication",
			"C2A01" => "Ingnieur d'tudes et d'exploitation en techniques exprimentales",
			"C2A03" => "Ingnieur en instrumentation scientifique et techniques exprimentales",
			"C2A04" => "Ingnieur d'exploitation sur grand instrument",
			"C2B05" => "Ingnieur lectrotechnicien",
			"C2C06" => "Ingnieur lectronicien d'tude et dveloppement",
			"G4A03" => "Technicien serrurier-mtallier du btiment",
			"G4A04" => "Technicien menuisier",
			"G4A05" => "Technicien plombier chauffagiste",
			"G4A06" => "Technicien en lectricit du btiment",
			"G4A07" => "Technicien dessinateur en btiment",
			"G4B09" => "Gestionnaire de magasin",
			"G4B11" => "Chef de site et d'quipes",
			"G4C12" => "Gestionnaire de produits de restauration",
			"G4D14" => "Technicien en hygine et scurit",
			"G4D15" => "Infirmier [EPST]",
			"G5X07" => "Jardinier",
			"G5A01" => "Adjoint en technique du btiment/amnagement intrieur",
			"G5A02" => "Serrurier-mtallier du btiment",
			"G5A03" => "Menuisier",
			"G5A04" => "Plombier chauffagiste",
			"G5A05" => "lectricien du btiment",
			"G5B08" => "Magasinier",
			"G5B10" => "Agent d'accueil/courrier",
			"G5C12" => "Commis de cuisine et de restauration",
			"G6A01" => "Aide technique du btiment",
			"G6B03" => "Aide logistique",
			"G6C04" => "Aide de cuisine et de restauration",
			"G7X02" => "Aide jardinier",
			"G7A01" => "Aide technique du btiment",
			"G7C04" => "Aide de cuisine et de restauration",
			"H1A01" => "Ingnieur en valorisation de la recherche",
			"H1B02" => "Responsable des relations internationales",
			"H1C03" => "Chef de projet ou d'tude en administration",
			"H1D04" => "Expert juridique",
			"H1F05" => "Responsable administratif sectoriel",
			"H1F06" => "Dirigeant administratif",
			"H1H08" => "Responsable de la gestion financire ou comptable",
			"H2A01" => "Charg de valorisation de la recherche",
			"H2C03" => "Charg d'tudes administratives",
			"H2D04" => "Juriste",
			"H2E05" => "Attach de direction",
			"H2F06" => "Administrateur gestionnaire d'unit",
			"H2G08" => "Charg de la gestion des ressources humaines",
			"H2H09" => "Charg de la gestion financire et/ou comptable",
			"H3X06" => "Assistant de service social",
			"H3D01" => "Assistant juridique",
			"H3E02" => "Assistant de direction",
			"H3F03" => "Assistant gestionnaire d'unit",
			"H3F04" => "Assistant en gestion administrative",
			"H3H07" => "Assistant en gestion financire et/ou comptable",
			"H4F02" => "Secrtaire/gestionnaire",
			"H4E01" => "Secrtaire",
			"H5X01" => "Adjoint en secrtariat et/ou gestion",
			"I1B02" => "Ingnieur en valorisation de la recherche",
			"I1C03" => "Ingnieu relations internationales",
			"I1D04" => "Responsable d'orientation et d'insertion professionnelle",
			"I1E05" => "Ingnieur en formation continue",
			"I1F06" => "Chef de projet ou d'tudes en administration",
			"I1F07" => "Spcialiste en organisation et rationalisation de gestion finalise",
			"A1A01" => "Ingnieur en recherche clinique et pidmiologie",
			"A1B02" => "Ingnieur en biologie",
			"A1C03" => "Ingnieur en exprimentation animale",
			"A1C04" => "Ingnieur en exprimentation animal et dveloppement",
			"A1D06" => "Ingnieur en exprimentation vgtale",
			"A1E07" => "Ingnieur en caractrisation des systmes naturels",
			"A2A01" => "Ingnieur en techniques de recherche clinique et pidmiologie",
			"A2C03" => "Ingnieur de gestion d'levage exprimental/exprimentation",
			"A2C04" => "Ingnieur en techniques d'exprimentation animale",
			"A2D05" => "Ingnieur en techniques d'exprimentation vgtale et dveloppement",
			"A2D06" => "Ingnieur en techniques d'exprimentation vgtale",
			"A2E07" => "Ingnieur en techniques d'tude des systmes naturels",
			"A3F08" => "Assistant ingnieur prothsiste dentaire",
			"A3A01" => "Infirmier en recherche clinique",
			"A3A02" => "Assistant en recherche clinique et pidmiologie",
			"A3B03" => "Assistant en techniques biologiques",
			"A3C05" => "Assistant en techniques d'exprimentation animale",
			"A3D06" => "Assistant en techniques d'exprimentation vgtale",
			"A4F08" => "Technicien prparateur en anatomie",
			"A4F09" => "Technicien prothsiste dentaire",
			"A4A01" => "Technicien en recherche clinique",
			"A4A02" => "Technicien charg d'enqutes",
			"A4B03" => "Technicien biologiste",
			"A4C04" => "Technicien en gestion d'levage exprimental",
			"A4C05" => "Technicien en exprimentation animale",
			"A4E07" => "Technicien des systmes naturels",
			"A5F05" => "Adjoint technique prothsiste dentaire",
			"A5F06" => "Prparateur taxidermiste",
			"A5B01" => "Prparateur en biologie",
			"F2F09" => "Ralisateur audiovisuel ou multimdia",
			"F2G13" => "Attach de presse",
			"F3A01" => "Assistant de bibliothque et de documentation",
			"F3F05" => "Assistant de production audiovisuelle ou multimdia",
			"F4E04" => "Technicien d'exploitation et de fabrication",
			"F5D02" => "Dessinateur",
			"F6A01" => "Aide de bibliothque",
			"G3A02" => "Assistant technique en gnie climatique",
			"G3D07" => "Assistant ingnieur en hygine et scurit",
			"G4B10" => "Gestionnaire du parc automobile",
			"G4C13" => "Chef de cuisine-cuisinier",
			"G5B09" => "Conducteur mcanicien",
			"G5B11" => "Oprateur de prvention et de surveillance",
			"G5X06" => "Oprateur de maintenance et de logistique de site ou d'unit",
			"G6X02" => "Aide jardinier",
			"G7B03" => "Aide logistique",
			"H1G07" => "Responsable de la gestion des ressources humaines",
			"H2B02" => "Charg des relations internationales",
			"H2F07" => "Cadre de gestion administrative",
			"H3G05" => "Assistant en gestion des ressources humaines",
			"H4F03" => "Gestionnaire",
			"I1A01" => "Ingnieur en appui  l'enseignement et  la recherche",
			"I1H09" => "Responsable des affaires juridiques et rglementaires",
			"G3C28" => "Assistant en hygine et scurit",
			"I2B02" => "Charg de valorisation de la recherche",
			"I2L11" => "Cadre de gestion administrative",
			"I3C03" => "Assistant en relations internationales",
			"I3G06" => "Assistant de gestion de personnels",
			"I7X02" => "Aide en administration scientifique et technique",
			"I4X01" => "Secrtaire en gestion scientifique et technique",
			"G1X02" => "Ingnieur du patrimoine immobilier et/ou logistique",
			"G2X02" => "Ingnieur en maintenance et travaux immobiliers et/ou logistique",
			"E5X0X" => "Oprateur d'exploitatio et de maintenance informatique",
			"G1X21" => "Ingnieur du patrimoine immobilier et/ou logistique",
			"G1X22" => "Ingnieur en prvention des risques",
			"G2X21" => "Ingnieur maintenance et travaux immobiliers et/ou logistique",
			"G2C22" => "Ingnieur en hygine et scurit",
			"G2C23" => "Ingnieur radio-protection (EPST)",
			"G2D24" => "Responsable d'exploitation d'un groupement de restaurants",
			"G3A21" => "Assistant gestion de donnes patrimoniales",
			"G3A22" => "Assistant technique gnie climatique",
			"G3A23" => "Assistant technique lectricit",
			"G3A24" => "Assistant technique courants faibles",
			"G3A25" => "Assistant technique maintenance et travaux immobiliers",
			"G3B26" => "Assistant espaces verts paysagiste",
			"G3B27" => "Assistant logistique",
			"F5C24" => "Oprateur d'exploitation et de fabrication",
			"F1D27" => "Responsable de production audiovisuelle et multimdia",
			"G7X21" => "Agent des services",
			"G6AP1" => "Aide technique du batiment - positionnement",
			"G6BP2" => "Aide jardinier-positionnement",
			"G6XP3" => "Aide logistique-positionnement",
			"G6DP4" => "Aide cuisine et restauration-positonnement",
			"G3D29" => "Assistant responsable d'une structure de restauration",
			"F2D34" => "Ingnieur des systmes et techniques audiovisuels et multimdia",
			"F2D35" => "Ralisateur audiovisuel multimdia",
			"F2D36" => "Ingnieur en imagerie scientifique",
			"F2D37" => "Concepteur rdacteur site WEB",
			"F2D38" => "Dveloppeur multimdia WEB",
			"F2D39" => "Ingnieur en technologie de la formation",
			"F3D31" => "Assistant systmes et techniques audiovisuelles et multimdia",
			"F3D32" => "Assistant de production AV multimdia et scne",
			"F3D33" => "Assistant des mtiers de l'image et du son",
			"F3D34" => "Intgrateur multimdia WEB",
			"F4D27" => "Technicien des mtiers de l'image et du son",
			"F4D28" => "Technicien photographe",
			"F5DP1" => "Ooprateur audiovisuel",
			"A3B24" => "Assistant en techniques d'exprimentation animale",
			"B3B22" => "Assistant en techniques d'laboration des biomolcules",
			"B4X22" => "Technicien en sciences physiques et en chimie",
			"D3E23" => "Assistant en archologie",
			"G4B27" => "Technicien jardinier",
			"C1A21" => "Responsable assurance produit",
			"C2A21" => "Ingnieur assurance produit",
			"C1B22" => "Ingnieur en conception et dveloppement en exprimentation",
			"C1B23" => "Chef de projet ou expert en conception ou intgration d'instruments",
			"C1B24" => "Ingnieur systme instrumentation",
			"C1C25" => "Chef de projet ou expert en conception du contrle/commande en instrumentation",
			"C1D26" => "Chef de projet ou expert lectronicien en conception et dveloppement",
			"G5A21" => "Plombier gnie climatique",
			"G5A22" => "Electricien courants forts",
			"G5A23" => "Electricien courants faibles",
			"G5A24" => "Oprateur de maintenance",
			"G5B25" => "Jardinier",
			"G5X26" => "Oprateur logistique",
			"G5D27" => "Commis de cuisine et de restauration",
			"A5E26" => "Prparateur en prothse dentaire",
			"A5E27" => "Prparateur spcimen naturalia",
			"B1A21" => "Ingnieur en analyse de biomolcules",
			"B2A21" => "Iingnieur en techniques d'analyse des biomolcules",
			"B3A21" => "Assistant en technique d'analyse des biomolcules",
			"B1B22" => "Ingnieur en laboration de biomolcules",
			"B4X21" => "Technicien en technologies de biomolcules",
			"B5X21" => "Prparateur en sciences physiques et en chimie",
			"B2B22" => "Ingnieur en techniques d'laboration de biomolcules",
			"B1C23" => "Ingnieur en analyse chimique",
			"D3D22" => "Assistant en production et analyse de donnes",
			"D4D22" => "Technicien en production et analyse de donnes",
			"D1E25" => "Ingnieur de recherche en archologie",
			"D2E25" => "Ingnieur d'tude en archologie",
			"D1E26" => "Ingnieur de recherche en archomtrie",
			"D2E26" => "Ingnieur d'tude en archomtrie",
			"F1AP1" => "Traducteur terminologue",
			"F2AP1" => "Traducteur",
			"F1A21" => "Responsable de ressources documentaires",
			"F1A22" => "Responsable des archives",
			"F1A23" => "Responsable de collections musales",
			"F2A21" => "Terminologue",
			"F2A22" => "Charg de systme d'information documentaire",
			"F2A23" => "Charg de ressources documentaires",
			"F2A24" => "Charg d'archives",
			"F2A25" => "Charg de collections musales",
			"F3A21" => "Assistant de ressources documentaires",
			"C5EP1" => "Adjoint en fabrication mcanique",
			"E2E25" => "Ingnieur en calcul scientifique",
			"G4C29" => "Technicien en hygine scurit",
			"G4D31" => "chef de cuisine cuisinier",
			"G4E32" => "Educateur sportif en natation ou quitation",
			"G5EP1" => "Oprateur des activits sportives",
			"G4AP1" => "Technicien plombier-positionnement",
			"F3A22" => "Assistant archiviste",
			"F3A23" => "Assistant de collections musales",
			"F4A21" => "Technicien d'information documentaire et de collections patrimoniales",
			"F5A21" => "Aide d'information documentaire et de collections patrimoniales",
			"C1D27" => "Chef de projet ou expert lectrotechnicien en conception et dveloppement",
			"C1E28" => "Chef de projet ou expert en conception mcanique",
			"C1E29" => "Chef de projet ou expert en fabrication mcanique",
			"C2B22" => "Ingnieur en techniques exprimentales",
			"C2B23" => "Ingnieur en conception instrumentale",
			"C2B24" => "Ingnieur d'exploitation sur grand instrument",
			"C2C25" => "Ingnieur en contrle/commande en instrumentation",
			"C2D26" => "Ingnieur lectronicien en dveloppement et/ou exprimentation",
			"C2D27" => "Ingnieur lctrotechnicien",
			"C2E28" => "Ingnieur en tudes mcaniques",
			"C2E29" => "Ingnieur en fabrication mcanique",
			"C2E30" => "Ingnieur en chaudronnerie",
			"C2E31" => "Ingnieur en fonderie",
			"C3B21" => "Assistant en instrumentation scientifique et techniques exprimentales",
			"C3B22" => "Conducteur sur grand instrument",
			"C3C23" => "Dveloppeur en contrle / commande en instrumentation",
			"C3D24" => "Assistant lectronicien",
			"C3D25" => "Assistant lectrotechnicien",
			"C3E26" => "Assistant en tudes mcaniques",
			"C3E27" => "Assistant en fabrication mcanique",
			"C3E28" => "Assistant en chaudronnerie et soudage",
			"C3E29" => "Assistant en fonderie",
			"C4B21" => "Technicien en instrumentation scientifique- exprimentation et mesure",
			"C4B22" => "Oprateur sur grand instrument",
			"C4D23" => "Technicien lectronicien",
			"C4D24" => "Technicien lectrotechnicien",
			"E6X0X" => "Oprateur d'exploitation et de maintenance informatique",
			"E7X0X" => "Oprateur d'expoitation et de maintenance informatiq",
			"A1A21" => "Ingnieur en analyse de donnes biologiques",
			"A1A22" => "Ingnieur biologiste en plateforme scientifique",
			"A1A23" => "Ingnieur en biologie",
			"A2A21" => "Ingnieur en traitement de donnes biologiques",
			"A2A22" => "Ingnieur en exprimentation et instrumentation biologiques",
			"A2A23" => "Ingnieur en techniques biologiques",
			"A3A21" => "Assistant en traitement de donnes biologiques",
			"A3A22" => "Assistant en exprimentation et instrumentation biologiques",
			"A3A23" => "Assistant en techniques biologiques",
			"A5A21" => "Prparateur en sciences de la vie et de la Terre- et biotechnologies",
			"A4A21" => "Technicien en sciences de la vie et de la Terre- et biotechnologies",
			"A1B24" => "Ingnieur en exprimentation animale",
			"A1B25" => "Ingnieur en levage et production animale",
			"A2B24" => "Ingnieur en techniques d'exprimentation animale",
			"A2B25" => "Ingnieur en techniques d'levage et production animale",
			"A3B25" => "Assistant en technIques d'levage et production animale",
			"C4E25" => "Technicien en tudes mcaniques",
			"A4B22" => "Technicien en exprimentation animale",
			"A4B23" => "Technicien en levage et production animale",
			"A5B22" => "Animalier",
			"A1C26" => "Ingnieur en production et exprimentation vgtales",
			"A2C26" => "Ingnieur en techniques de production et exprimentation vgtales",
			"A3C26" => "Assistant en techniques de production et exprimentation vgtales",
			"A4C24" => "Technicien en production et exprimentation vgtales",
			"A5C23" => "Prparateur en production et exprimentation vgtales",
			"A1D27" => "Ingnieur des milieux naturels et ruraux",
			"A2D27" => "Ingnieur en techniques d'tude des milieux naturels et ruraux",
			"A3D27" => "Assistant en techniques d'tude des milieux naturels et ruraux",
			"A4D25" => "Technicien en milieux naturels et ruraux",
			"B2C23" => "Ingnieur en techniques d'analyse chimique",
			"B3C23" => "Assistant en techniques d'analyse chimique",
			"C3F30" => "Assistant ingnieur en travail du verre",
			"B1D24" => "Ingnieur en synthse chimique",
			"B2D24" => "Ingnieur en techniques de synthse chimique",
			"B3D24" => "Assistant en techniques de synthse chimique",
			"B1E25" => "Ingnieur en sciences des matriaux/caractrisation",
			"B2E25" => "Ingnieur en techniques de sciences des matriaux/caractrisation",
			"F5X0X" => "Oprateur d'exploitation audiovisuelle et multimdia",
			"F6X0X" => "Oprateur d'exploitation audiovisuelle et multimdia",
			"F7X0X" => "Oprateur d'exploitation audiovisuelle et multimdia",
			"E1A21" => "Architecte des systmes d'information",
			"E1B22" => "Chef de projet ou expert en dveloppement et dploiement d'applications",
			"E1C23" => "Chef de projet ou expert systmes informatiques- rseaux et tlcommunications",
			"E1D24" => "Chef de projet ou expert en information statistique",
			"E1E25" => "Chef de projet ou expert en calcul scientifique",
			"E2A21" => "Administrateur de systmes d'information",
			"E2B22" => "Ingnieur en dveloppement et dploiement d'applications",
			"E2C23" => "Administrateur systmes informatiques- rseaux et tlcommunications",
			"E2D24" => "Ingnieur statisticien",
			"E3A21" => "Gestionnaire de base de donnes",
			"E3B22" => "Dveloppeur- intgrateur d'applications",
			"E3C23" => "Gestionnaire de parc informatique et tlcommunications",
			"E3D24" => "Assistant statisticien",
			"E4X21" => "Technicien d'exploitation- de maintenance et de traitement des donnes",
			"E5XP1" => "Oprateur d'exploitation et de maintenance informatique",
			"B3E25" => "Assistant en techniques de sciences des matriaux/caractrisation",
			"B4E23" => "Technicien en sciences des matriaux/caractrisation",
			"B5X22" => "Prparateur en traitement des matriaux",
			"B1F26" => "Ingnieur en laboration- mise en forme- traitement et contrle des matriaux",
			"B2F26" => "Ingnieur en laboration de matriaux en couches minces",
			"B3F26" => "Assistant en laboration de matriaux en couches minces",
			"B2F27" => "ingnieur en laboration et mise en forme des matriaux massifs",
			"B3F27" => "Assistant en laboration et/ou mise en forme de matriaux massifs",
			"B4F24" => "Technicien en laboration et/ou mise en forme des matriaux",
			"D1A21" => "Ingnieur de recherche en traitement et analyse de bases de donnes",
			"D2A21" => "Ingnieur d'tude en traitement et analyse de base de donnes",
			"D1B22" => "Ingnieur de recherche en traitement- analyse et reprsentation de l'information spatiale",
			"D2B22" => "Ingnieur d'tude en traitement- analyse et reprsentation de l'information spatiale",
			"D3B21" => "Assistant cartographe",
			"D4B21" => "Technicien cartographe",
			"D1C23" => "Ingnieur de recherche en analyse de sources",
			"D2C23" => "Ingnieur d'tude en analyse de sources",
			"D1D24" => "Ingnieur de recherche en production et analyse de donnes",
			"D2D24" => "Ingnieur d'tude en production et analyse de donnes",
			"G4A21" => "Technicien dessinateur",
			"G4A22" => "Technicien gnie climatique",
			"G4A23" => "Technicien lectricit",
			"G4A24" => "Technicien courants faibles",
			"G4A25" => "Conducteur de travaux",
			"G4A26" => "Technicien amnagement intrieur",
			"G4B28" => "Technicien logistique",
			"A5D24" => "Adjoint technique en milieux naturels et ruraux",
			"G4C30" => "Iinfirmier(EPST)",
			"A3EP1" => "Assistant en prothse dentaire",
			"A4E26" => "Technicien en prothse dentaire",
			"A5E25" => "Prparateur en anatomie",
			"C2D08" => "Ingnieur mcanicien d'tude et dveloppement",
			"C2E09" => "Ingnieur de fabrication mcanique",
			"C3A01" => "Assistant ingnieur d'exploitation en techniques exprimentales",
			"C3A02" => "Assistant en instrumentation scientifique et techniques exprimentales",
			"C3B04" => "Assistant lectrotechnicien",
			"C3C05" => "Assistant lectronicien",
			"C3E07" => "Assistant en fabrication mcanique",
			"C3F08" => "Assistant ingnieur chaudronnier-mtallier",
			"C3G09" => "Assistant en optique de prcision/travail du verre",
			"C4A01" => "Technicien d'exprimentation et d'exploitation en techniques exprimentales",
			"C4A02" => "Technicien d'instrumentation scientifique- d'exprimentation et de mesure",
			"C4B04" => "Technicien d'installation lectrotechnique",
			"C4B05" => "Technicien monteur en lectrotechnique",
			"C4D07" => "Dessinateur en construction mcanique",
			"C4F09" => "Chaudronnier-mtallier",
			"I1G08" => "Responsable de la gestion des ressources humaines",
			"I1L10" => "Responsable administratif de composante- d'un domaine d'activit ou d'un service commun",
			"I2A01" => "Charg d'tudes en appui  l'enseignement et  la recherche",
			"I2C03" => "Charg des relations internationales",
			"I2D04" => "Charg d'orientation et d'insertion professionnelle",
			"I2E05" => "Charg d'animation et d'ingnierie en formation continue",
			"I2F06" => "Charg d'tudes administratives",
			"I2G07" => "Cadre de gestion de personnels",
			"I2H08" => "Charg d'affaires juridiques",
			"I2K09" => "Cadre financier",
			"I2K10" => "Cadre comptable",
			"I3A01" => "Assistant ingnieur en appui  l'enseignement et  la recherche",
			"I3B02" => "Assistant en valorisation de la recherche",
			"I3D04" => "Assistant d'orientation et d'insertion professionnelle",
			"I3E05" => "Assistant en ingnierie de formation continue",
			"I3H07" => "Assistant juridique",
			"I3K08" => "Assistant financier et comptable",
			"I3L09" => "Assistant ingnieur de gestion administrative",
			"G4D16" => "Educateur sportif des activits de natation",
			"G5D13" => "Educateur sportif des activits de natation",
			"I4X02" => "Gestionnaire en administration scientifique et technique",
			"I5X01" => "Aide en gestion scientifique et technique",
			"I5X02" => "Aide en administration scientifique et technique",
			"I6X01" => "Aide en gestion scientifique et technique",
			"I6X02" => "Aide en administration scientifique et technique",
			"I7X01" => "Aide en gestion scientifique et technique",
			"B3D05" => "Assistant en techniques de synthse chimique",
			"B3F08" => "Assistant en laboration de matriaux massifs",
			"B4X02" => "Technicien chimiste",
			"C1A01" => "Ingnieur en conception d'instruments scientifiques",
			"C1D05" => "Ingnieur mcanicien en conception et dveloppement",
			"C2A02" => "Ingnieur d'tudes pour la conception d'instruments",
			"C2C07" => "Ingnieur lectronicien de laboratoire",
			"C2F10" => "Ingnieur chaudronnier-mtallier",
			"C3A03" => "Conducteur sur grand instrument",
			"C3D06" => "Dessinateur projeteur en construction mcanique",
			"C4A03" => "Oprateur sur grand instrument",
			"A1D05" => "Ingnieur en exprimentation vgtale et dveloppement",
			"A2B02" => "Ingnieur en techniques biologiques",
			"A2C05" => "Ingnieur en techniques d'exprimentation animale et dveloppement",
			"A3C04" => "Assistant en gestion d'levage exprimental/exprimentation",
			"A3E07" => "Assistant en techniques d'tude des systmes naturels",
			"A4D06" => "Technicien en exprimentation vgtale",
			"A4F10" => "Taxidermiste/gestionnaire de collections",
			"A5F04" => "Prparateur en anatomie",
			"A6F05" => "Agent prparateur",
			"A6X01" => "Agent de laboratoire",
			"A7X01" => "Agent de laboratoire",
			"B1B02" => "Ingnieur en laboration de biomolcules",
			"B1F06" => "Ingnieur en laboration- traitement- contrle des matriaux",
			"C4C06" => "Technicien lectronicien",
			"C4E08" => "Technicien de fabrication en construction mcanique",
			"D1B02" => "Ingnieur en analyse et en traitement de donnes  rfrence spatiale",
			"D2A01" => "Ingnieur mthodes en sciences humaines et sociales",
			"D3A01" => "Assistant charg d'enqutes",
			"D3C04" => "Assistant en techniques anthropologiques ou archozoologiques",
			"E1A03" => "Ingnieur nouvelles technologies ducatives",
			"E2C04" => "Administrateur systmes- rseaux et tlcommunications",
			"E3A01" => "Dveloppeur d'applications",
			"F1A03" => "Responsable des archives",
			"F1F06" => "Producteur-diteur de produits audiovisuels ou multimdia",
			"F2B04" => "Traducteur rviseur",
			"F1B24" => "Responsable de mdiation scientifique",
			"F1B25" => "Responsable de communication",
			"F2B26" => "Charg de mdiation scientifique",
			"F2B27" => "Charg de communication et des mdia",
			"F2B28" => "Charg de l'action culturelle",
			"F3B24" => "Assistant de mdiation scientifique",
			"F3B25" => "Assistant de communication",
			"F3B26" => "Assistant de l'action culturelle",
			"F4B22" => "Technicien en mdiation scientifique et culturelle",
			"F4B23" => "Technicien des mtiers de la scne",
			"F1C26" => "Responsable ditorial multi supports",
			"F2C29" => "Secrtaire d'dition",
			"F2C30" => "Secrtaire de rdaction",
			"F2C31" => "Charg de diffusion",
			"F2C32" => "Designer Arts graphiques",
			"F2C33" => "Charg de fabrication",
			"F3C27" => "Assistant de rdaction/dition",
			"F3C28" => "Assistant de diffusion",
			"F3C29" => "Dessinateur maquettiste infographiste",
			"F3C30" => "Assistant de fabrication",
			"F4C24" => "Technicien en PAO multisupports",
			"F4C25" => "Technicien en graphisme",
			"F4C26" => "Technicien d'exploitation et de fabrication",
			"F5C22" => "Oprateur de composition",
			"F5C23" => "Oprateur en graphisme",
			"C4E26" => "Technicien en fabrication mcanique",
			"C4E27" => "Chaudronnier soudeur",
			"C4F28" => "Souffleur de verre",
			"C5B21" => "Adjoint en instrumentation scientifique- exprimentation et mesure",
			"F1D28" => "Responsable TICE",
			"C5D22" => "Prparateur en lectronique lectrotechnique",
			"J1A21" => "Responsable de la valorisation de la recherche",
			"J1A22" => "Responsable de la coopration internationale",
			"J1B23" => "Responsable des affaires juridiques",
			"J1E27" => "Responsable de l'orientation et de l'insertion professionnelle",
			"J1F28" => "Responsable de la gestion financire et comptable",
			"J2B23" => "Charg des affaires juridiques",
			"J2C24" => "Charg de gestion administrative et d'aide au pilotage",
			"J2C25" => "Charg du contrle de gestion et/ou d'tudes",
			"J2C26" => "Qualiticien",
			"J3D23" => "Assistant de service social (EPST)",
			"J3E24" => "Assistant en ingienerie de formation continue",
			"J3E25" => "Assistant d' orientation et d'insertion professionnelle",
			"J3F26" => "Assistant en gestion financire et comptable",
			"J4X21" => "Technicien en gestion administative",
			"J4D22" => "Gestionnaire de ressources humaines",
			"J4E23" => "Technicien en formationet et en orientation-insertion professionnelle",
			"J4F24" => "Gestionnaire financier et comptable",
			"J5X21" => "Adjoint en gestion administrative",
			"J1E26" => "Responsable de la formation continue",
			"J2D27" => "Charg de la GPEEC",
			"J2D28" => "Charg de la formation des personnels",
			"J2D29" => "Charg de la gestion des ressources humaines",
			"J2E30" => "Charg d'animation et d'ingnerie en formation continue",
			"J2E31" => "Charg d'orientation et d'insertion professionnelle",
			"J2F32" => "Charg de la gestion financire et/ou comptable",
			"J2F33" => "Charg des contrats de recherche",
			"J2F34" => "Charg des achats et des marchs",
			"J3X21" => "Assistant en gestion administrative",
			"J3D22" => "Assistant en gestion des ressources humaines",
			"J2A21" => "Charg de valorisation de la recherche",
			"J2A22" => "Charg de la coopration internationale",
			"J1C24" => "Responsable de l'administration et du pilotage",
			"J1D25" => "Responsable de la gestion des ressources humaines",
		),
	),
);
