{extends file='ls:base_connected.tpl'}
{block name="content"}
    {if $pagetitle != ''}<h1 id='LSview_title'>{$pagetitle|escape:"htmlall"}</h1>{/if}

<div class='LSform'>
<form action='object/{$LSobject|escape:"url"}/import' method='post' enctype="multipart/form-data">
<input type='hidden' name='LSobject' value='{$LSobject}'/>
<input type='hidden' name='validate' value='import'/>
<dl class='LSform'>
  <dt class='LSform'><label for='importfile'>{tr msg='File'}</label></dt>
  <dd class='LSform'><input type='file' name='importfile'/></dd>

  <dt class='LSform'><label for='ioFormat'>{tr msg='Format'}</label></dt>
  <dd class='LSform'>
    <select name='ioFormat'>
      {if isset($result['ioFormat'])}
        {html_options options=$ioFormats selected=$result.ioFormat}
      {else}
        {html_options options=$ioFormats}
      {/if}
    </select>
  </dd>

  <dt class='LSform'><label for='justTry'>{tr msg='Update objects if exists'}</label></dt>
  <dd class='LSform'>
    <input type='radio' name='updateIfExists' value='yes' {if isset($result['updateIfExists']) && $result['updateIfExists']}checked{/if}/>{tr msg='yes'}
    <input type='radio' name='updateIfExists' value='no'  {if !isset($result['updateIfExists']) || !$result['updateIfExists']}checked{/if}/>{tr msg='no'}
  </dd>

  <dt class='LSform'><label for='justTry'>{tr msg='Only validate data'}</label></dt>
  <dd class='LSform'>
    <input type='radio' name='justTry' value='yes' {if isset($result['justTry']) && $result['justTry']}checked{/if}/>{tr msg='yes'}
    <input type='radio' name='justTry' value='no'  {if !isset($result['justTry']) || !$result['justTry']}checked{/if}/>{tr msg='no'}
  </dd>

  <dd class='LSform'><input type='submit' value='{tr msg='Valid'}'/></dd>
</dl>
</form>
</div>
{if $result}
<h1>{tr msg='Result'}</h1>
{if !empty($result.errors)}
<h2>{tr msg='Errors'}</h2>
{foreach $result.errors as $error}
<h3 class='LSio'>{tr msg="Object %(idx)" idx=$error@iteration}</h3>
<div class='LSio_error'>
{if !empty($error.errors.globals)}
  <ul class='LSio_global_errors'>
  {foreach $error.errors.globals as $e}
    <li>{$e}</li>
  {/foreach}
  </ul>
{/if}
{if $error.messages}
<ul class="LSio_global_messages">
  {foreach $error.messages as $m}
  <li>{$m}</li>
  {/foreach}
</ul>
{/if}
<ul class='LSio_data_errors'>
{foreach $error.data as $key => $val}
  <li>
    <strong>{$key|escape:"htmlall"} :</strong>
    {if empty($val)}{tr msg='No value'}{else}{LSio_implodeValues values=$val}{/if}
    {if isset($error.errors.attrs[$key])}
    <ul class='LSio_attr_errors'>
      {foreach $error.errors.attrs.$key as $e}
      <li>{$e|escape:"htmlall"}</li>
      {/foreach}
    </ul>
    {/if}
  </li>
{/foreach}
{foreach $error.errors.attrs as $a => $es}
  {if !in_array($a,$error.data)}
  <li>
    <strong>{$a|escape:"htmlall"} :</strong>
    <ul class='LSio_attr_errors'>
      {foreach $es as $e}
        <li>{$e|escape:"htmlall"}</li>
      {/foreach}
    </ul>
  </li>
  {/if}
{/foreach}
</ul>
</div>
{/foreach}
{/if}

<h2 class='LSio_imported_objects'>{tr msg='Imported objects'} ({count($result.imported)})</h2>
<ul class='LSio_imported_objects'>
{foreach $result.imported as $dn => $obj}
  <li>
    <a href='object/{$LSobject|escape:"url"}/{$dn|escape:"url"}'>{$obj.name|escape:"htmlall"}</a>
    {if $obj.errors}
    <h3>{tr msg="Errors"}</h3>
    <ul class="LSio_object_errors">
      {foreach $obj.errors as $e}
      <li>{$e|escape:"htmlall"}</li>
      {/foreach}
    </ul>
    {/if}
    {if $obj.messages}
    <h3>{tr msg="Messages"}</h3>
    <ul class="LSio_object_messages">
      {foreach $obj.messages as $e}
      <li>{$e|escape:"htmlall"}</li>
      {/foreach}
    </ul>
    {/if}
  </li>
{foreachelse}
  <li>{tr msg='No imported object'}</li>
{/foreach}
</ul>

{if !empty($result.updated)}
<h2 class='LSio_updated_objects'>{tr msg='Updated objects'} ({count($result.updated)})</h2>
<ul class='LSio_updated_objects'>
{foreach $result.updated as $dn => $obj}
  <li>
    <a href='object/{$LSobject|escape:"url"}/{$dn|escape:"url"}'>{$obj.name|escape:"htmlall"}</a>
    {if $obj.errors}
    <h3>{tr msg="Errors"}</h3>
    <ul class="LSio_object_errors">
      {foreach $obj.errors as $e}
      <li>{$e|escape:"htmlall"}</li>
      {/foreach}
    </ul>
    {/if}
    {if $obj.messages}
    <h3>{tr msg="Messages"}</h3>
    <ul class="LSio_object_messages">
      {foreach $obj.messages as $e}
      <li>{$e|escape:"htmlall"}</li>
      {/foreach}
    </ul>
    {/if}
  </li>
{/foreach}
</ul>
{/if}

{foreach $result.hooks as $hook => $info}
{if $info.errors || $info.messages}
<h2>{tr msg="Hook: %(name)" name=$hook}</h2>
<div class="LSio_hook">
{if $info.errors}
<h3>{tr msg="Errors"}</h3>
<ul class="LSio_hook_errors">
  {foreach $info.errors as $e}
  <li>{$e|escape:"htmlall"}</li>
  {/foreach}
</ul>
{/if}
{if $info.messages}
<h3>{tr msg="Messages"}</h3>
<ul class="LSio_hook_messages">
  {foreach $info.messages as $e}
  <li>{$e}</li>
  {/foreach}
</ul>
{/if}
</div>
{/if}
{/foreach}

{/if}
{/block}
