<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/*
 ***********************************************
 * OrgChart configuration
 ***********************************************
 */

// OrgChart entity object types
$GLOBALS['ORGCHART_ENTITY_OBJECT_TYPES'] = array(
  // Object type included in chart and its parameters
  'LSpeople' => array(
    // Attribute name that contening parent object reference (optional)
    'parent_id_attr' => 'lsGodfatherDn',

    // Value of the parent attribute : could be 'dn' or another attribute of this type of object.
    // Optional, default: 'dn'
    // Note: in the chart, all entities are known by their DN. If you specify here an attribute,
    // the first object matching with the value of the parent ID attribute will be keeped.
    //'parent_id_attr_value' => 'dn',

    // Parent object types
    // Optional, default: all object types included in the chart
    //'parent_object_types' => array('LSpeople', ...),

    // Other attributes to load from LDAP : map here keys to attribute. These attributes values
    // will be available in chart node template (as array).
   'other_attrs' => array(
     'name' => 'cn',
   ),
 ),
);

// Optional chart root entity
// If defined, all objects found without parent entity will be linked to this root entity. It's
// could be usefull when you have multiple root entities (no support by the d3-org-chart lib used).
// You could define here all information of the root entity and they will be available in the chart
// node template.
$GLOBALS['ORGCHART_ROOT_ENTITY'] = array(
  'id' => 'root',
  'name' => array('LSexample'),
);

// Chart node template
// The Mustache templating system is used here:
// https://github.com/janl/mustache.js
$GLOBALS['ORGCHART_TEMPLATE'] = <<<EOF
<div class="chart-node"><a href="{{url}}">{{name.0}}</a></div>
EOF;

// Additional CSS files to load on chart page
$GLOBALS['ORGCHART_ADDITIONAL_CSS_FILES'] = array();
