<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ******************************************************************************/

/**
 * Règle de validation par comparaison de valeurs.
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSformRule_compare extends LSformRule {

  // Validate values one by one or all together
  const validate_one_by_one = False;

  // CLI parameters autocompleters
  protected static $cli_params_autocompleters = array(
    'operator' => null,
  );

  // Operators mapping
  static protected $_operators_aliases = array(
      '=='  => 'eq',
      '!='  => 'neq',
      '>'  => 'gt',
      '>='  => 'gte',
      '<'  => 'lt',
      '<='  => 'lte',
  );
  static protected $_operators_to_compare_function = array(
      'eq'  => function($a, $b) {return floatval($a) == floatval($b);},
      'neq' => function($a, $b) {return floatval($a) != floatval($b);},
      'gt'  => function($a, $b) {return $a > $b;},
      'gte' => function($a, $b) {return $a >= $b;},
      'lt'  => function($a, $b) {return $a < $b;},
      'lte' => function($a, $b) {return $a <= $b;},
  );

  /**
   * Return the compare function associated with the specified operator
   *
   * @access private
   * @param  string  The operator name
   *
   * @return function  The compare function
   */
  private static function _findOperatorCompareFunction($operator_name) {
    if (empty($operator_name))
      $operator_name = 'eq';
    elseif (isset(self :: $_operators_aliases[$operator_name]))
      $operator_name = self :: $_operators_aliases[$operator_name];
    elseif (!isset(self :: $_operators_to_compare_function[$operator_name]))
      $operator_name = 'eq';
    return self :: $_operators_to_compare_function[$operator_name];
  }

  /**
   * Vérification des valeurs.
   *
   * @param string $values Valeurs à vérifier
   * @param array $options Options de validation :
   *                              - Operateur : $options['params']['operator']
   * @param object $formElement L'objet formElement attaché
   *
   * @return boolean true si la valeur est valide, false sinon
   */
  public static function validate($values, $options, &$formElement) {
    $operator = LSconfig :: get('params.operator', null, 'string', $options);
    if (!$operator) {
      LSerror :: addErrorCode('LSformRule_01',array('type' => 'compare', 'param' => 'operator'));
      return;
    }
    $compareFn = self :: _findOperatorCompareFunction($operator);
    return $compareFn($values[0], $values[1]);
  }

}
