<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

LSsession :: loadLSclass('LSlog_staticLoggerClass');

/**
 * Base d'un type d'attribut HTML
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSattr_html extends LSlog_staticLoggerClass {

  /**
   * The attribute name
   * @var string
   */
  var string $name;

  /**
   * Attribute configuration (LSobjects.<type>.attrs.<attr_name>)
   * @var array<string,mixed>
   */
  var array $config;

  /**
   * The reference of the parent LSattribute object
   * @var LSattribute
   */
  var LSattribute $attribute;

  /**
   * The corresponding LSformElement object type
   * Note: Must be set in implemented classes
   * @var string
   */
  var string $LSformElement_type = '';

  /**
   * If true, this LSattr_html type is considered as able to only support
   * the first and unique value of the attribute. If more than one value
   * is passed to this LSattr_html type, an LSattr_html_03 error will be
   * triggered.
   * @var bool
   */
  protected bool $singleValue = false;

  /**
   * Constructeur
   *
   * Cette methode construit l'objet et définis la configuration.
   *
   * @author Benjamin Renard <brenard@easter-eggs.com>
   *
   * @param string $name Nom de l'attribut ldap
   * @param array $config Configuration de l'objet
   * @param LSattribute &$attribute  L'objet LSattribut parent
   *
   * @return boolean Retourne true.
   */
  public function __construct($name, $config, &$attribute) {
    $this -> name = $name;
    $this -> config = $config;
    $this -> attribute =& $attribute;
  }

  /**
   * Allow conversion of LSattr_html to string
   *
   * @return string The string representation of the LSattr_html
   */
  public function __toString() {
    return "<".get_class($this)." ".$this -> name.">";
  }

  /**
   * Retourne le label de l'attribut
   *
   * Retourne le label de l'attribut ou son nom si aucun label n'est défini
   * dans la configuration.
   *
   * @return string Le label de l'attribut.
   */
  public function getLabel() {
    return __($this -> getConfig('label', $this -> name));
  }

  /**
   * Ajoute l'attribut au formualaire passer en paramètre
   *
   * @param LSform &$form  Le formulaire
   * @param string $idForm L'identifiant du formulaire
   * @param array|string|null $data Valeur du champs du formulaire
   *
   * @return LSformElement|false L'element du formulaire ajouté, ou false
   */
  public function addToForm (&$form,$idForm,$data=NULL) {
    if (!$this -> LSformElement_type) {
      LSerror :: addErrorCode('LSattr_html_01',$this -> name);
      return false;
    }
    $element=$form -> addElement($this -> LSformElement_type, $this -> name, $this -> getLabel(), $this -> config, $this);
    if(!$element) {
      LSerror :: addErrorCode('LSform_06',$this -> name);
      return false;
    }
    if (!is_null($data)) {
      $data = ensureIsArray($data);
      if ($this -> singleValue) {
        if (count($data) > 1)
          LSerror :: addErrorCode('LSattr_html_03', get_class($this));
        $element -> setValue($data[0]);
      }
      else
        $element -> setValue($data);
    }
    return $element;
  }

  /**
   * Effectue les tâches nécéssaires au moment du rafraichissement du formulaire
   *
   * @param mixed $data The attribute value
   *
   * @return mixed La valeur formatée de l'attribut
   **/
  public function refreshForm($data) {
    return $data;
  }

  /**
   * Return the values to be displayed in the LSform
   *
   * @param array $data The values of attribute
   *
   * @return array The values to be displayed in the LSform
   **/
  public function getFormVal($data) {
    return $this -> attribute -> getDisplayValue($data);
  }

  /**
   * Return a configuration parameter (or default value)
   *
   * @param string $param      The configuration parameter
   * @param mixed $default    The default value (default : null)
   * @param string $cast       Cast resulting value in specific type (default : disabled)
   *
   * @return mixed The configuration parameter value or default value if not set
   **/
  public function getConfig($param, $default=null, $cast=null) {
    return LSconfig :: get($param, $default, $cast, $this -> config);
  }

}

/*
 * Error Codes
 */
LSerror :: defineError('LSattr_html_01',
___("LSattr_html : The method addToForm() of the HTML type of the attribute %{attr} is not defined.")
);
// 02 : not yet used
LSerror :: defineError('LSattr_html_03',
___("%{type} : Multiple data are not supported for this field type.")
);
