<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

LSsession :: loadLSclass('LSattr_html_select_box');

/**
 * HTML attribute type for sambaAcctFlags
 */
class LSattr_html_sambaAcctFlags extends LSattr_html_select_box {

  var string $LSformElement_type = 'sambaAcctFlags';

  /**
   * Retourne un tableau des valeurs possibles de la liste
   *
   * @param array|false $options Attribute options (optional)
   * @param string|false $name Attribute name (optional)
   * @param LSldapObject|false &$ldapObject Related LSldapObject (optional)
   *
   * @author Benjamin Renard <brenard@easter-eggs.com>
   *
   * @return array Tableau associatif des valeurs possible de la liste avec en clé
   *               la valeur des balises option et en valeur ce qui sera affiché.
   */
  public static function _getPossibleValues($options=false, $name=false, &$ldapObject=false) {
    $translate_labels = LSconfig :: get('translate_labels', true, 'bool', $options);
    $retInfos = array();
    if (!LSsession :: loadLSclass('LSattr_ldap_sambaAcctFlags', null, true))
      return $retInfos;
    foreach(LSattr_ldap_sambaAcctFlags :: get_available_flags() as $group_label => $flags) {
      if ($translate_labels)
        foreach ($flags as $flag => $label)
          $flags[$flag] = _($label);
      $retInfos[] = array(
        'label' => ($translate_labels?_($group_label):$group_label),
        'possible_values' => $flags,
      );
    }
    return $retInfos;
  }

}
