{extends file='ls:base_connected.tpl'}
{block name="content"}
<h1>{$pagetitle}</h1>
{include file='ls:LSview_actions.tpl'}

<table class='LStable'>
  <thead>
    <tr>
      <th>{tr msg="Date"}</th>
      <th>{tr msg="Author"}</th>
      <th>{tr msg="Operation"}</th>
      <th>{tr msg="Result"}</th>
      <th>{tr msg="Details"}</th>
    </tr>
  </thead>
  <tbody>
  {foreach $page.logs as $log}
    <tr>
      <td>{$log.start->format('Y/m/d H:i:s')}</td>
      <td class="center">{if $log.author_dn}<span title='{$log.author_dn|escape:quotes}' class='LStips'>{$log.author_rdn}</span>{/if}</td>
      <td class="center">{$log.type}</td>
      <td class="center">{$log.result}{if $log.message} <img class='LStips' src="{img name='help'}" alt="?" title='{$log.message|escape:quotes}'/>{/if}</td>
      <td>
        {if $log.mods}
        <table style='margin: auto'>
          <thead>
           <tr>
             <th>{tr msg="Attribute"}</th>
             <th>{tr msg="Operation"}</th>
             <th>{tr msg="Value"}</th>
             <th>{tr msg="Old value(s)"}</th>
           </tr>
         </thead>
         <tbody>
           {foreach $log.mods as $attr => $info}
           <tr>
             <td class="center" {if count($info.changes)>1}rowspan={$info.changes|count}{/if}>{$attr}</td>
             <td class="center">{$info.changes.0.op|escape:htmlall}</td>
             <td>{$info.changes.0.value|escape:htmlall}</td>
             <td {if count($info.changes)>1}rowspan={$info.changes|count}{/if}>
               {if $info.old_values}
                 {if count($info.old_values) == 1}
                   {$info.old_values[0]|escape:'htmlall'}
                 {else}
                   <ul>
                   {foreach $info.old_values as $old_value}
                     <li>{$old_value|escape:'htmlall'}</li>
                   {/foreach}
                   </ul>
                 {/if}
               {/if}
             </td>
           </tr>
             {if count($info.changes) > 1}
               {section name=change loop=$info.changes step=1 start=1}
               <tr>
                 <td>{$info.changes[change].op|escape:htmlall}</td>
                 <td>{$info.changes[change].value|escape:htmlall}</td>
               </tr>
               {/section}
             {/if}
           {/foreach}
         </tbody>
        </table>
        {/if}
      </td>
    </tr>
  {foreachelse}
    <tr>
      <td class="center" colspan="4">{tr msg="No access log found for this object."}</td>
    </tr>
  {/foreach}
  </tbody>
</table>
<p style='text-align: right; padding: 1em;'>{count($page.logs)} {tr msg="event(s) found for this object."}</p>

{include file='ls:pagination.tpl'}
{/block}
