# Les formulaires (LSform)

Cette section décrit la manière de paramétrer les formulaires d'LdapSaisie pour un type
[LSobject](index.md#configuration-lsobject) donné. Pour chaque type
d'[LSobject](index.md#configuration-lsobject), il faut configurer plusieurs formulaires
correspondant aux vues gérées par LdapSaisie (création, modification, ...). Les formulaires se
configurent par plusieurs biais :

- Via la configuration des attributs : La configuration des attributs détermine la présence ou non
  des attributs dans les formulaires. Elle permet également de définir si on souhaite bloquer leur
  présence en lecture seulement.

- Via les droits de l'utilisateur connecté sur les attributs de l'objet à éditer : en fonction des
  droits de l'utilisateur sur un attribut, celui-ci apparaîtra en lecture-écriture ou en lecture
  uniquement voir pas du tout.

- Via la configuration au niveau de chaque type d'[LSobject](index.md#configuration-lsobject) : il
  y est possible de définir le comportement globale du formulaire comme la validation via Ajax ou
  encore la disposition logique des attributs dans le formulaire.

  ```
  $GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSform'] = array (
    'ajaxSubmit' => [booléen],
    'layout' => array (
      // Configuration de la disposition logique des attributs
    ),
    'dataEntryForm' => array (
      // Configuration des masques de saisie
    )

  );
  ```

  - `ajaxSubmit`

    Booléen définissant si le formulaire sera envoyé via une requête Ajax plutôt qu'à travers un
    rafraîchissement de la page. Par défaut : `True`.

  - `layout`

    Tableau contenant la configuration de l'affichage du formulaire : il est possible de définir la
    disposition des attributs dans le formulaire en les regroupant dans des onglets et en les
    faisant apparaître dans un ordre logique.
    [Voir la section concernée.](#configuration-de-laffichage)

  - `dataEntryForm`

    Tableau contenant la configuration des masques de saisie : il est possible de définir des
    masques de saisie pour faire en sorte que lors de la création d'un objet, seul un certain nombre
    d'élements soit demandé à l'utilisateur.
    [Voir la section concernée.](#configuration-des-masques-de-saisie)

## Configuration de l'affichage

La configuration des *layout* se situe dans la configuration des
[LSobjects](index.md#configuration-lsobject), dans la variable `layout`
(`$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSform']['layout']`). Cette variable est un
tableau associatif dont la clé est l'identifiant de l'onglet et dont la valeur associée est la
configuration de l'onglet.

```php
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSform']['layout'] = array (
  'onglet1' => array(
    'label' => '[label de l'onglet]',
    'img' => 1, // Valeur possible 1 ou 0
    'args' => array (
      'arg1',
      'arg2',
      ...
    )
  ),
  ...
);
```

- `label`

  Le label de l'onglet.

- `img`

  Affiche ou non l'image d'un éventuel attribut de type HTML
  [LSattr_html_image](LSattribute/LSattr_html/LSattr_html_image.md#lsattr_html_image).

- `args`

  Tableau associatif contenant une liste ordonnée des attributs qui apparaîtront dans l'onglet.

!!! important

    Lorsqu'un *layout* est défini, celui-ci est *"suivi à la lettre"* pour l'affichage du
    [LSform](#lsform). Ainsi, si un attribut est défini dans la configuration de l'objet comme
    présent dans le [LSform](#lsform) courant, mais que celui-ci n'est pas présent dans le *layout*,
    il ne sera pas du tout affiché.

### Configuration des masques de saisie

La configuration des masques de saisie (*dataEntryForm*) se situe dans la configuration des
[LSobjects](index.md#configuration-lsobject), dans la variable `dataEntryForm`
(`$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSform']['dataEntryForm']`). Cette variable est
un tableau associatif dont la clé est l'identifiant du masque de saisie et dont la valeur associée
est sa configuration.

```php
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSform']['dataEntryForm'] = array (
  'masque1' => array(
    'label' => '[label du masque de saisie]',
    'disabledLayout' => [booleen],
    'displayedElements' => array (
      'attr1',
      'attr2',
      ...
    ),
    'defaultValues' => array (
      'attr3' => [value],
      'attr4' => [value],
      ...
    ),
    'requiredAllAttributes' => [booleen],
    'requiredAttributes' => array (
      'attr1',
      'attr2',
      ...
    ),
    'forceGeneration' => array (
      'attr1',
      'attr2',
      ...
    ),
  ),
  ...
);
```

- `label`

  Le label du masque de saisie.

- `disabledLayout`

  Active ou non les [layouts](#configuration-de-laffichage) pour ce masque de saisie.

- `displayedElements`

  Tableau contenant la liste des attributs qui devront être saisie dans le masque de saisie.

- `defaultValues`

  Tableau associatif contenant la liste des valeurs par défaut des attributs. Les valeurs multiples
  sont possibles en utilisant des tableaux.

  !!! important

      Les valeurs seront vue comme des valeurs retournées par le formulaire et non comme des valeurs
      des attribus LDAP eux-même. Ainsi et par exemple, un attribut traité comme un booléen dans un
      formulaire pourra prendre comme valeur par défaut `yes` ou `no`.

- `requiredAttributes`

  Tableau contenant la liste des attributs obligatoires du masque de saisie. Cette liste d'attributs
  obligatoires viendra en complément de la configuration des attributs. Il est ainsi possible de
  rendre des attributs obligatoires durant la saisie d'un masque tout en les laissant facultatif le
  reste du temps.

- `requiredAllAttributes`

  Si ce parametre vaut `True`, tout les attributs du masque de saisie seront tous obligatoires de la
  même manière qu'avec le paramètre `requiredAttributes`.

- `forceGeneration`

  Tableau contenant la liste des attributs dont la génération sera forcée lors de la validation du
  formation.
