# LSaddon_accesslog

Cet [LSaddon](index.md#configuration-des-lsaddons) fournit la fonction `showObjectAccessLogs()`
pouvant être utilisée comme [customActions](../LSobject/customActions.md#customactions) et
permettant d'afficher les logs d'accès produits par
[l'overlay OpenLDAP accesslog](https://www.openldap.org/doc/admin24/overlays.html#Access%20Logging)
sur un objet de l'annuaire.

La constante `LS_ACCESSLOG_BASEDN` du fichier de configuration de l'addon
(`conf/LSaddons/config.LSaddons.accesslog.php`) permet d'indiquer le base DN de la base stockant les
logs :

```
// Accesslog base DN
define('LS_ACCESSLOG_BASEDN', 'cn=ldapsaisie-accesslog');
```

!!! warning

    LdapSaisie se connectera à la base stockant les logs d'accès de l'annuaire avec les mêmes
    paramètres de connexion que pour la base principale (excepté le base DN). Pensez à ajuster les
    ACLs de la base stockant les logs d'accès pour autoriser l'utilisateur d'LdapSaisie à se
    connecter et lire les informations qu'elle contient.

    **Exemple d'ACL à mettre en place :**
    ```
    to *
          by dn.exact=uid=ldapsaisie,ou=sysaccounts,o=ls read
          by * break
    ```

Ci-dessous, vous trouverez un exemple de configuration de la fonction `showObjectAccessLogs()` comme
[customActions](../LSobject/customActions.md#customactions) :

**Exemple d'utilisation :**

```php
$GLOBALS['LSobjects']['LSpeople'] = array (
  [...]
  'customActions' => array (
    'showObjectAccessLogs' => array (
      'function' => 'showObjectAccessLogs',
      'label' => 'Show access logs',
      'hideLabel' => true,
      'noConfirmation' => true,
      'disableOnSuccessMsg' => true,
      'icon' => 'clock',
      'rights' => array (
        'admin'
      ),
    ),
  ),
  [...]
);
```
