# LSattr_html_postaladdress

Ce type est utilisé pour la gestion des attributs du type de l'attribut standard *postalAddress*.
Ce type d'attribut permet d'afficher, en plus de l'adresse, un lien composé à partir d'informations
de l'objet permettant par exemple d'afficher un lien vers une carte géocalisant l'adresse postale.

Par défaut, le lien ajouté sera un lien de recherche de l'adresse postale générée à partir de la
valeur de l'attribut (en remplaçant les retours à la ligne (`\n`) par des espaces) via le service
[Nominatim d'OpenStreetMap](http://nominatim.openstreetmap.org/).

!!! note

    Dans le cadre du fonctionnement par défaut et pour maîtriser les valeurs stockées dans
    l'annuaire, il faut coupler ce type d'attribut HTML avec le type d'attribut LDAP
    [postaladdress](../LSattr_ldap/LSattr_ldap_postaladdress.md#lsattr_ldap_postaladdress)

```
'html_options' => array(
  'map_url_pattern_format' => '[LSformat]',
  'map_url_pattern_generate_function' => '[callable]',
  'map_url_format' => '[LSformat]',
),
...
```

- `map_url_pattern_format`

  Ce [LSformat](../../../global/LSformat.md#format-parametrable) doit permettre de générer la valeur
  de l'adresse postale qui sera insérée dans l'URL du lien ajouté dans l'interface.

- `map_url_pattern_generate_function`

  Ce paramètre permet de définir une fonction qui sera utilisée à la place du paramètre
  `map_url_pattern_format` pour générer la valeur de l'adresse postale qui sera insérée dans l'URL
  du lien ajouté dans l'interface. Cette fonction prendra en paramètre l'objet *LSformElement*
  courant et devra retourner une chaîne de caractères correspondant à l'adresse postale à insérer
  dans le lien de l'interface. Par défaut, la fonction
  `LSformElement_postaladdress__generate_pattern` est utilisée.

- `map_url_format`

  Ce [LSformat](../../../global/LSformat.md#format-parametrable) doit permettre de générer l'URL du
  lien ajouté dans l'interface. Il sera composé avec les informations de l'objet LDAP, y compris le
  mot clé `%{pattern}` correspondant à la valeur de l'adresse postale générée à l'aide des
  paramètres précédents. Par défaut, la format suivant sera utilisé :
  `http://nominatim.openstreetmap.org/search.php?q=%{pattern}`
