# LSaddon_exportSearchResultAsCSV

Cet [LSaddon](index.md#configuration-des-lsaddons) fournie une fonction du même nom pouvant être
utilisée comme [customActions](../LSobject/LSsearch.md#customactions_1) et permettant de télécharger
le résultat d'une recherche au format CSV. L'export généré reprend exactement le contenu des
colonnes du tableau du résultat de la recherche. Le DN de l'objet LDAP correspondant est également
fournis dans une colonne.

Des paramètres de configuration sont disponibles dans le fichier de configuration
`config.LSaddons.exportSearchResultAsCSV.php`. Ils permettent notamment de contrôller le format du
fichier CSV généré.

```php
// CSV file delimiter
define('LS_EXPORTSEARCHRESULTASCSV_DELIMITER',',');

// CSV file enclosure
define('LS_EXPORTSEARCHRESULTASCSV_ENCLOSURE','"');

// CSV file escape character (available since PHP 5.5.4)
define('LS_EXPORTSEARCHRESULTASCSV_ESCAPE_CHAR','\\');
```

Ci-dessous, vous trouverez un exemple de configuration de la fonction `exportSearchResultAsCSV()`
comme [customActions](../LSobject/LSsearch.md#customactions_1) :

```php
$GLOBALS['LSobjects']['LSpeople']['LSsearch'] = array (
        [...]
        'customActions' => array (
                'exportSearchResultAsCSV' => array (
                        'label' => 'Export result as CSV',
                        'icon' => 'export_csv',
                        'function' => 'exportSearchResultAsCSV',
                        'noConfirmation' => true,
                        'disableOnSuccessMsg' => true,
                        'rights' => array (
                                'admin'
                        )
                ),
        ),
        [...]
);
```

/// note
Le label et l'icône fournis dans cet exemple sont traduits et délivrés avec LdapSaisie.
///
