# LSauthMethod_CAS

Cette [LSauthMethod](index.md#configuration-des-lsauthmethods) est utilisée pour gérer
l'authentification via un service SSO CAS. Cette librairie doit être configurée en éditant le
fichier de configuration `conf/LSauth/config.LSauthMethod_CAS.php`.

**Structure du fichier :**

```php
/*
 *****************************************************
 * Configuration of the CAS authentification support *
 *****************************************************
 */

// phpCAS Path (http://www.ja-sig.org/wiki/display/CASC/phpCAS)
define('PHP_CAS_PATH','/usr/share/php/CAS.php');

// phpCAS Debug File
// define('PHP_CAS_DEBUG_FILE','/tmp/phpCAS.log');

// Disable logout
define('LSAUTH_CAS_DISABLE_LOGOUT',false);

// CAS Server version (used constant name know by phpCAS : CAS_VERSION_1_0 or CAS_VERSION_2_0)
define('LSAUTH_CAS_VERSION','CAS_VERSION_2_0');

// CAS Server hostname
define('LSAUTH_CAS_SERVER_HOSTNAME','cas.univ.fr');

// CAS Server port
define('LSAUTH_CAS_SERVER_PORT',443);

// CAS Server URI (empty by default)
// define('LSAUTH_CAS_SERVER_URI','cas/');

// No SSL validation for the CAS server
define('LSAUTH_CAS_SERVER_NO_SSL_VALIDATION',false);

// CAS server SSL CA Certificate path
//define('LSAUTH_CAS_SERVER_SSL_CACERT','');
```

- `PHP_CAS_PATH`

  Le chemin d'accès du fichier `CAS.php` de la librairie
  [phpCAS](http://www.ja-sig.org/wiki/display/CASC/phpCAS). Le chemin d'exemple correspond au chemin
  résultant d'une installation via [PEAR](http://pear.php.net/) sur une Debian (Lenny).

- `PHP_CAS_DEBUG_FILE`

  Chemin du fichier de log de la librairie [phpCAS](http://www.ja-sig.org/wiki/display/CASC/phpCAS).
  Commenter la ligne pour désactiver les logs.

- `LSAUTH_CAS_DISABLE_LOGOUT`

  Booléen définissant si l'utilisateur peut se déconnecter du serveur CAS depuis l'interface.

  /// note
  Remarque : l'appel de l'URL de déconnexion via une requête `GET` supprimera la session PHP et
  donc la session LdapSaisie sans déconnecter pour autant l'utilisateur au niveau du serveur
  CAS. Cela peut donc permettre de gérer la déconnexion automatique au niveau d'LdapSaisie suite
  à une déconnexion au niveau du CAS à traver le concepte de `Global Logout`.
  ///

- `LSAUTH_CAS_VERSION`

  Nom de la constant [phpCAS](http://www.ja-sig.org/wiki/display/CASC/phpCAS) permettant de définir
  la version CAS du serveur. Actuellement, la librairie
  [phpCAS](http://www.ja-sig.org/wiki/display/CASC/phpCAS) ne reconnait que la constante
  `CAS_VERSION_1_0` pour la version 1 de CAS ou la constante `CAS_VERSION_2_0` pour la version 2 de
  CAS.

  /// note
  Remarque : Des tests on montrés que l'utilisation d'une compatibilité CAS version 2 peut
  également fonctionner sur un version 3 du serveur CAS.
  ///

- `LSAUTH_CAS_SERVER_HOSTNAME`

  Le nom d'hôte du serveur CAS.

- `LSAUTH_CAS_SERVER_PORT`

  Le port d'écoute du serveur CAS.

- `LSAUTH_CAS_SERVER_URI`

  Le dossier HTTP dans lequel se trouve le service CAS. Exemple : Pour un service CAS accessible via
  l'URL `https://cas.univ.fr/cas/`, la constante devra valoir `cas/`.

- `LSAUTH_CAS_SERVER_NO_SSL_VALIDATION`

  Booléen permettant de désactiver la validation du certificat SSL du serveur CAS lors des requêtes
  de validation des tickets CAS.

- `LSAUTH_CAS_SERVER_SSL_CACERT`

  Chemin d'accès du fichier contenant le certificat SSL de la CA du serveur CAS au format PEM.
  Commenter la ligne pour désactiver ce paramètre.
