# Les formats d'import/export (ioFormat)

Cette section décrit la manière de paramétrer les formats d'import/export pour un type d'
[LSobject](index.md#configuration-lsobject) donné.

La configuration des *ioFormats* se situe dans la configuration des
[LSobjects](index.md#configuration-lsobject), dans la variable `ioFormat`
(`$GLOBALS['LSobjects']['[nom du type d'LSobject]']['ioFormat']`). Cette variable est un tableau
associatif dont la clé est l'identifiant du format et dont la valeur associée est la configuration
du format.

/// warning | Attention
Le moteur d'importation simule la validation d'un formulaire de création du type
d'[LSobject](index.md#configuration-lsobject) (ou de modification en cas d'activation du mode
mise à jour uniquement, voir ci-dessous). En conséquence :

- seul les attributs présent dans le formulaire de création peuvent être importés.

- tous les attributs obligatoires présents dans le formulaire de création doivent être fournis
  par le fichier source ou générer à partir des autres attributs.

- Les valeurs des attributs issus de l'importation seront vue comme des valeurs retournées par
  le formulaire et non comme des valeurs des attribus LDAP eux-même. Ainsi et par exemple, un
  attribut traité comme un booléen dans un formulaire pourra prendre comme valeur par
  défaut `yes` ou `no`.
///

```
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['ioFormat'] = array (
  '[ioFormat ID]' => array (
    'label' => '[Label du type de fichier]',
    'driver' => '[Pilote d'ioFormat utilisé]',
    'driver_options' => array([Options du pilote d'ioFormat utilisé]),
    'update_only' => '[Booléen]',
    'fields => array (
      '[champ 1]' => '[attribut 1]',
      '[champ 2]' => '[attribut 2]',
      [...]
    ),
    'generated_fields' => array (
      '[attribute 3]' => '[LSformat]',
      '[attribute 4]' => array('[LSformat1]', '[LSformat2]', ...)
      '[attribute 5]' => function($attrs, $row) {
        return array([...]);
      },
      [...]
    ),
    'before_import' => array('function1', 'function2'),
    'after_import' => 'function3',
  ),
  [...]
);
```

- `label`

  Le label du format

- `driver`

  Le pilote a utilisé pour ce format. Le pilote permet de gérér la lecture et l'écriture dans un
  type de fichier d'import/export. Pour plus d'information sur les pilotes disponibles,
  [Voir la section concernée.](#pilote-dioformat)

- `driver_options`

  Tableau associatif des options du pilote utilisé pour ce format. Pour plus d'informations,
  consulter la documentation du pilote utilisé.

- `update_only`

  Booléen permettant d'activer le mode mise à jour uniquement pour ce format. Dans ce mode, les
  données de l'objet LDAP correspondant seront chargées depuis l'annuaire avant toutes validations
  des données fournies dans le fichier d'import, et ce, dans un formulaire de modifications et non
  pas un formulaire de création autrement. Pour que cela soit possible, il est indispensable que le
  DN de l'objet puisse être déduit depuis les données fournies dans le fichier d'import. Pour cela,
  vous pouvez le fournir via un champ du fichier d'import associé à la clé `dn` ou à défaut il sera
  généré à partir du RDN dont la valeur devra être fournie dans le fichier d'import. Vous pouvez
  également le générer via le paramètre `generated_fields` (voir ci-dessous).

- `fields`

  Tableau associatif permettant d'associer un champ du fichier source (la clé) avec attribut de
  l'objet LDAP (la valeur). Il est également possible d'associé un champ avec la valeur `dn` pour
  fournir le DN de l'objet en mode mise à jour uniquement (voir ci-dessus).

- `generated_fields`

  Tableau associatif permettant de définir soit des
  [LSformats](../global/LSformat.md#format-parametrable), soit un *callable* (au sens PHP) pour
  générer les valeurs d'attributs automatiquement. Ce tableau contient en clé, le nom de l'attribut
  à générer (ou `dn` pour la génération du DN de l'objet en mode mise à jour uniquement), et en
  valeur associée, un ou plusieurs [LSformat](../global/LSformat.md#format-parametrable) ou un
  *callable* à utiliser pour générer ses valeurs.
  En cas de [LSformat](../global/LSformat.md#format-parametrable), ils seront composés à l'aide des
  valeurs des autres attributs de l'objet. En cas d'un *callable*, il sera appeler avec en paramètre
  le tableau des valeurs des autres attributs (`$attrs`), le tableau des données issues du fichier
  source (`$row`) et devra retourner le tableau des valeurs générées de l'attribut ou `false` en cas
  d'erreur.

- `before_import`

  Chaîne de caractères (ou tableau de chaîne de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées avant chaque import. [Voir la section concernée](#declencheurs)

- `after_import`

  Chaîne de caractères (ou tableau de chaîne de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées après chaque import. [Voir la section concernée](#declencheurs)

## Pilote d'ioFormat

Cette section décrit la manière de configurer les pilotes d'ioFormat utilisés lors des
imports/exports d'[LSobjects](index.md#configuration-lsobject).

### Pilote de fichiers CSV

Ce pilote permet de gérer l'import/export de [LSobject](index.md#configuration-lsobject) à partir
d'un fichier `CSV`. Depuis la version 4 d'LdapSaisie, ce pilote utilise les fonctions standards
`fgetcsv()` et `fputcsv` fournis par PHP. Avant cela, la classe PEAR
[File_CSV_DataSource](http://pear.php.net/package/File_CSV_DataSource) était utilisée. Par défaut,
les paramètres de lecture et d'écriture des fichiers sont : la virgule sert de délimiteur, le
caractère `"` peut être utilisé pour encadrer les valeurs des champs et la longueur maximale d'une
ligne est infini. Ces paramètres peuvent être modifiés en configurant les options du pilote.

```
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['ioFormat']['[ID ioFormat]']['driver_options'] = array (
  'delimiter' => '[délimiteur]',
  'enclosure' => '[caractère d'encadrement de texte]',
  'length' => [longueur maximale d'une ligne],
  'escape' => '[caractère d'échappement]',
  'multiple_value_delimiter' => '[délimiteur]',
);
```

- `delimiter`

  Le caractère utilisé pour délimiter les champs (Par défaut, une virgule).

- `length`

  La longueur maximale d'une ligne du fichier. Si zéro est spécifié, la longueur d'une ligne ne sera
  pas limité, mais la lecture du fichier sera ralentie. (Par défaut : `0`)

- `enclosure`

  Le caractère utilisé pour encadrer les valeurs des champs (Par défaut : `"`).

- `escape`

  Le caractère d'échappement utilisé si un des champs d'une ligne de fichier contient le caractère
  utilisé pour encadrer les valeurs. (Par défaut : `\`).

  /// note
  Selon la RFC4180, l'echappement du caractère utilisé pour encadrer les valeurs des champs doit
  se faire en le doublant. Le caractère défini ici est une alternative à ce comportement par
  défaut. Pour désactiver ce caractère d'échappement alternatif, il est possible depuis de la
  version 7.4.0 de PHP de mettre ici une chaine vide.
  ///

- `multiple_value_delimiter`

  Le caractère utilisé pour délimiter au sein d'un champs, les valeurs valeurs multiples d'un
  attribut (Par défaut : `|`).

## Déclencheurs

Cette section décrit la manière de paramétrer des déclencheurs afin que LdapSaisie exécute durant
ses processus, et à des moments bien précis des traitements d'un [ioFormat](#ioformat), des
fonctions que vous pourrez développer vous même. De plus, le résultat de l'exécution de vos
fonctions pourra influer sur le déroulement des processus.

Actuellement, les évenements suivant sont gérés :

| Nom             | Description      | Bloquant |
| --------------- | ---------------- | -------- |
| `before_import` | Avant l'import.  | Oui      |
| `after_import`  | Après l'import'. | Non      |

/// note
Si un événement est dit *bloquant*, lors de l'exécution des actions liées, si une des fonctions
retourne `false`, le processus s'arrêtera.
///

### Configuration

La configuration des déclencheurs se fait dans la définition des types d'[ioFormat](#ioformat). Par
exemple, pour définir les fonctions à exécuter après l'import des LSobjects de type *LSpeople* avec
son LSioFormat *mycsv*, c'est à dire lors de leur évènement `after_import`, il faut définir la
variable suivante :

```php
$GLOBALS['LSobjects']['LSpeople']['ioFormat']['mycsv']['after_import']
```

Cette variable peut contenir soit une chaine de caractères correspondant au nom de la fonction à
exécuter, soit un tableau de chaînes de caractères correspondant aux noms des fonctions à exécuter.
Il est également possible de mettre ici directement des
[fonctions anonymes](https://www.php.net/manual/fr/functions.anonymous.php).

### Ecriture d'une fonction

Une fonction exécutée par un déclencheur d'un ioFormat se déclare de la manière suivante :

```php
/*
 * Ma fonction à exécuter lors de l'evenement [event]
 *
 * Paramètres :
 *     - $ioFormat : Le LSioFormat sur lequel l'évènement survient
 *     - $data : Les données de contexte de l'évènement
 *
 * Valeurs retournées :
 *     - True : Tout s'est bien passé
 *     - False : Une erreur est survenue ou la fonction souhaite bloquer le
 *               processus lors d'un évènement bloquant.
 */
function maFonction (&$ioFormat, &$data) {

  // Actions

}

```

Cette fonction doit accepter deux paramètres, le LSioFormat sur lequel l'évènement survient et un
tableau des données contextuelles de l'évènement. Elle doit par ailleurs retourner `True` si tout
s'est bien passé ou `False` en cas de problème. Dans le cas d'un événement bloquant, si la fonction
retourne `False`, le processus est arrêté.

Les données contextuelles de l'évènement, passées en paramètre, pourront dépendre du contexte et de
l'évènement déclencheur, mais pour les moments, il s'agit toujours d'un tableau telque décrit
ci-dessous :

```php
array(
  'input_file' => "[/path/of/import.file]",
  'updateIfExists' => [boolean],
  'justTry' => [boolean],
  'objectsData' => array(
    [Données des objets chargés depuis le fichier d'import]
  ),
  'return' => array(
    'success' => [boolean],
    'LSobject' => "[nom du type d'LSobject]",
    'ioFormat' => "[nom du type d'ioFormat]",
    'updateIfExists' => [boolean],
    'justTry' => [boolean],
    'imported' => array([objets importés]),
    'updated' => array([objets mis à jour]),
    'errors' => array(
      array(
        'data' => [données de l'objet importé ayant déclenché l'erreur],
        'errors' => array (
          'globals' => array("Erreur 1", [...]),
          'attrs' => array(
            'attr1' => array("Erreur 1", [...]),
            [...]
          ),
        ),
      ),
      [...]
    ),
  ),
)
```

/// note
Les clés `objectsData` et `return` sont des références. En cas de modification, cela influencera
respectivement sur les données utilisées pour l'import et sur le résultat de l'import tel
qu'affiché dans l'interface.
///
