# Configuration des serveurs LDAP

Cette section décrit le tableau de configuration des différents serveurs LDAP utilisés par
l'application. Ce tableau contient lui même un tableau par serveur LDAP.

```php
$GLOBALS['LSconfig'] = array(
  ...
  'ldap_servers' => array(
    array (
      'name' => [nom de l'annuaire],
      'ldap_config'=> array(
        // Définition des paramètres de connexion à l'annuaire
      ),
      'useUserCredentials' => [boolean],
      'useAuthzProxyControl' => [boolean],
      'LSauth' => array (
        'method' => [LSauth method],
        'api_method' => [LSauth method],
        'LSobjects' => array(
          '[object type 1]',
          '[object type 2]' => array(
            'filter' => '[LDAP filter]',
            'filter_function' => [callable],
            'password_attribute' => '[attribute name]',
            'web_access' => [booléen],
            'api_access' => [booléen],
          )
        )
      ),
      'LSprofiles' => array (
        // Définition des LSprofiles
      ),
      'cacheLSprofiles' => [boolean],
      'cacheSearch' => [boolean],
      'globalSearch' => [boolean],
      'LSaccess' => array (
        [Type LSobject 1],
        [Type LSobject 2],
        ...
      ),
      'subDn' => array(
        // Définition des sous-niveaux de l'annuaire
      ),
      'subDnLabel' => [nom des sous-niveaux],
      'recoverPassword' => array(
        // Définition des paramètres de configuration de la récupération de mot de passe
      ),
      'defaultView' => [view],
      'emailSender' => [email],
      'keepLSsessionActive' => [booléen]
    )
  ...
);
...
```

- `name`

  Le nom d'affichage de ce serveur Ldap (utilisé lorsque plusieurs serveur LDAP sont déclarés).

- `ldap_config`

  Informations de connexion au serveur LDAP. Ces informations sont structurées selon les attentes de
  la librairie [Net_LDAP2](http://pear.php.net/package/Net_LDAP2).
  [Plus d'informations](http://pear.php.net/manual/fr/package.networking.net-ldap.connecting.php)

- `useUserCredentials`

  Booléen définissant si il faut utiliser les identifiants de l'utilisateur pour se connecter à
  l'annuaire (*false* par défaut). Si cette option est activée, la connexion à l'annuaire LDAP sera
  établie avec la configuration fournie dans le paramètre *ldap_config* en écrasant les informations
  de connexion (*binddn* et *bindpwd*) par ceux de l'utilisateur. Si l'utilisateur n'est pas encore
  connecté, la connexion sera étalie sans modifier la configuration fournie.

- `useAuthzProxyControl`

  Booléen définissant si, lorsqu'on utilise les identifiants de l'utilisateur pour se connecter à
  l'annuaire, il faut utiliser une authentification via *proxy authorization*. Dans ce cas, les
  identifiants de l'utilisateur ne seront pas, à proprement parlé, utilisés pour se connecter à
  l'annuaire, mais une demande de *proxy authorization* en tant que l'utilisateur connecté sera
  faites à l'aide des identifiants de l'application. Ce mode nécessite une configuration
  particulière au niveau de l'annuaire pour autoriser le compte de l'application à faire des
  demandes de *proxy authorization* en tant que les autres utilisateurs de l'annuaire.

- `LSprofiles`

  Définition des profils d'utilisateurs se connectant à l'annuaire.
  [Voir la section concernée](LSprofile.md#profils-dutilisateurs).

- `LSauth`

  Ce tableau défini les paramètres d'authentification à l'application.

  - `method`

    Nom de la méthode d'authentification
    [LSauthMethod](../../LSauthMethod/index.md#configuration-des-lsauthmethods). Exemple : pour
    utiliser la classe `LSauthMethod_HTTP`, la valeur de ce paramètre sera `HTTP`.
    *Paramètre facultatif, méthode par défaut : `basic`.*

  - `api_method`

    Nom de la méthode d'authentification
    [LSauthMethod](../../LSauthMethod/index.md#configuration-des-lsauthmethods) à utilisée lors
    d'une connexion à l'API. Exemple : pour utiliser la classe `LSauthMethod_HTTP`, la valeur
    de ce paramètre sera `HTTP`. *Paramètre facultatif, méthode par défaut : `HTTP`.*

    /// warning | Attention
    Toutes les [LSauthMethod](../../LSauthMethod/index.md#configuration-des-lsauthmethods) ne
    supportent pas forcément le mode API.
    ///

  - `LSobjects`

    Tableau listant les types [LSobjects](../../LSobject/index.md#configuration-lsobject) pouvant se
    connecter à l'application. Les valeurs de ce tableau peuvent être un nom de type d'objet ou bien
    tableau détaillant les paramètres de connexion de ce type d'objet.

    - `filter`

      [LSformat](../LSformat.md#format-parametrable) du filtre de recherche de l'utilisateur à sa
      connexion. Ce format sera composé avec l'identifiant fourni par l'utilisateur. Cela peut par
      exemple permettre à l'utilisateur de se connecter en fournissant son login ou son email comme
      identifiant. Exemple de valeur : `(|(uid=%{user})(mail=%{user}))`.
      *Paramètre facultatif, filtre par défaut composé à l'aide de l'attribut RDN.*

    - `filter_function`

      *Callable* (au sens PHP) utilisé pour filtrer les utilisateurs trouvés dans l'annuaire à
      partir des autres paramètres : cette fonction, si elle est définie, sera appelée pour chaque
      utilisateur trouvé, avec pour unique paramètre, une référence à l'objet LDAP correspondant
      (`LSldapObject`). Cette méthode devra alors retourner `true` ou `false` pour respectivement
      autoriser ou interdire l'accès à l'application à l'utilisateur.

      /// note
      Si un utilisateur est exclus par cette méthode et qu'aucun autre utilisateur correspondant
      n'a été trouvé dans l'annuaire, une page d'erreur sera affichée et indiquera que l'accès à
      l'application est refusée.
      ///

    - `password_attribute`

      Nom de l'attribut stockant le mot de passe de ce type
      d'[LSobject](../../LSobject/index.md#configuration-lsobject).
      *Paramètre facultatif, valeur par défaut : `userPassword`.*

      /// note
      C'est cet attribut de l'utilisateur qui sera modifié par la fonctionnalité de récupération de
      mot de passe.
      ///

    - `web_access`

      Permet de définir si ce type d'objet à le droit d'utiliser l'interface web (facultatif, par
      défaut : `True`).

    - `api_access`

      Permet de définir si ce type d'objet à le droit d'utiliser l'API (facultatif, par défaut :
      `False`).

  - `allow_multi_match`

    Booléen permettant de définir si un doublon d'identifiant utilisateur est autorisé. Si c'est le
    cas et lorsqu'un identifiant fourni par l'utilisateur a sa connexion a permi de trouver plus
    d'un utilisateur possible correspondant, l'application tentera de déterminer lequel de ces
    utilisateurs correspond à la tentative d'authentification. La méthodologie employée dépendra de
    la [LSauthMethod](../../LSauthMethod/index.md#configuration-des-lsauthmethods) configurée. Par
    exemple, la [LSauthMethod](../../LSauthMethod/index.md#configuration-des-lsauthmethods) `basic`
    tentera de s'identifier avec le mot de passe. Dans tous cas, si cette méthode n'a pas permis
    d'identifier un seul utilisateur, l'authentification échoura. *Paramètre facultatif, valeur par
    défaut : `False`.*

- `cacheLSprofiles`

  Activation/Désactivation de la mise en cache des [LSprofiles](LSprofile.md#profils-dutilisateurs)
  des utilisateurs connectés à ce serveur.

  Valeur par défaut : *valeur de la variable globale du même nom*

- `cacheSearch`

  Activation/Désactivation de la mise en cache du résultat des recherches sur ce serveur.

  Valeur par défaut : *valeur de la variable globale du même nom*

- `globalSearch`

  Activation/Désactivation de la recherche globale sur ce serveur en particulier. Par défaut, la
  valeur du paramètre global `globalSearch` est utilisée.

  Valeur par défaut : *valeur de la variable globale du même nom*

- `LSaccess`  <a name="LSaccess"></a>

  Définition des types d'[LSobjects](../../LSobject/index.md#configuration-lsobject) devant
  apparaître dans le menu de l'interface.

  /// note
  Ce paramètre n'est utilisé que pour les annuaires n'ayant pas de sous-niveaux
  ([subDn](subDn.md#sous-niveaux-de-connexion)).
  ///

- `subDn`

  Définition des sous-niveaux de connexion à l'annuaire.
  [Voir section concernée](subDn.md#sous-niveaux-de-connexion).

  /// note
  Ce paramètre remplace le paramètre [LSaccess](#LSaccess) dans le cas d'un annuaire
  multi-niveaux.
  ///

- `subDnLabel`

  Définition du label utilisé pour qualifier les sous-niveaux de connexion.

  /// note
  Ce paramètre est utile uniquement dans le cas d'un annuaire multi-niveaux.
  ///

- `recoverPassword`

  Définition des paramètres de la récupération de mot de passe.
  [Voir la section concernée](recoverPassword.md#recuperation-de-mot-de-passe).

- `defaultView`

  Définition de la vue par défaut de l'application. Par défaut, une page blanche est affichée et il
  est possible de définir à l'aide de ce paramètre la vue qui s'affichera. Ce paramètre peut prendre
  comme valeur :

  - `SELF` pour la vue *Mon compte*

  - Le nom d'un [LSobject](../../LSobject/index.md#configuration-lsobject) pour afficher la liste de
    ce type d'objet

  - Le nom d'une vue d'un [LSaddon](../../LSaddon/index.md#configuration-des-lsaddons) au format
    `[addon]::[viewId]` pour afficher cette vue

- `emailSender`

  Adresse mail utilisée par LdapSaisie pour envoyer des e-mails en relation avec cet annuaire. Cette
  adresse est celle utilisée par défaut. L'adresse utilisée peut également être configurée dans le
  contexte de configuration du module devant envoyer des e-mails.

- `keepLSsessionActive`

  Activation/Désactivation du maintient de la LSsession active.

  Valeurs possibles : `True` ou `False`

  Valeur par défaut : *valeur de la variable globale du même nom*
