# Les éléments des formulaires (LSformElement)

Les [LSformElements](#lsformelements) sont les types de champs de formulaire supportés par
l'application.

Pour chaque type implémenté, on devra trouver :

- Une classe PHP dérivée de la classe `LSattr_html` et devant s'appeler
  `LSattr_html_[nom du type d'attribut HTML]`. Dans celle-ci, il devra être défini à minima la
  variable de classe `LSformElement_type` permettant de référencer le type
  d'[LSformElement](#lsformelements) à utiliser ;

- Une classe PHP dérivée de la classe `LSformElement` et devant s'appeler
  `LSformElement_[nom du type d'LSformElement]`. Cette classe implémentera tout ce qui concerne
  l'affichage du champ dans le formulaire et le traitement d'une valeur retournée par ce dernier.
  Cela concerne notamment les méthodes suivantes :

  - `getDisplay()`

    Retourne les informations d'affichage du champ dans un formulaire sous la forme d'un tableau
    *(implémentation obligatoire, pas de méthode par défaut)*. Il sera possible de s'appuyer sur la
    méthode `getLabelInfos()` permettant de générer et récupérer tout ce qui concerne le label du
    champ du formulaire. Il faudra cependant à minima fournir également la clé `html` dans le
    tableau retourné qui devra contenir le bout de code HTML correspondant au champ du formulaire.
    Communément, ce code HTML est généré en appelant la méthode `fetchTemplate()`.

  - `fetchTemplate()`

    Retourne le code HTML du champ dans le formulaire. L'implémentation de cette méthode est
    facultative et par défaut, cette méthode utilisera la variable de classe `$template` pour
    connaître le fichier de template à utiliser. Ce fichier de template permettra la génération de
    la liste de tous les champs associés à chacune des valeurs de l'attribut. Individuellement, le
    champ d'une des valeurs de l'attribut est généré à l'aide du fichier de template référencé dans
    la variable de class `$fieldTemplate`.

    /// note
    La variable de classe `$fieldTemplate` est également utilisée par la méthode
    `LSformElement :: getEmptyField()` qui sert à générer le code HTML d'un champ du formulaire
    pour une nouvelle valeur de l'attribut. Cette méthode est notamment utilisée lorsque l'on
    clique sur le bouton permettant d'ajouter une valeur à un champ du formulaire.

  - `getPostData()`

    Récupère dans les données postées par le formulaire, celle concernant ce champ. Cette méthode
    devra potentiellement traiter l'ensemble des valeurs de l'attribut envoyées par le formulaire
    et les définir dans le tableau passé en référence en tant que premier argument, les valeurs de
    l'attribut. L'implémentation de cette méthode est facultative et par défaut, un tableau de
    valeurs portant le nom de l'attribut LDAP correspondant sera récupérée comme valeur de
    l'attribut.

    /// note
    Pour plus d'informations sur le rôle et fonctionnement de cette méthode, référer à la
    méthode par défaut, définie dans la classe PHP parente `LSformElement`.
    ///

  - `setValueFromPostData()`

    Définit les valeurs de l'attribut à partir des données reçues du formulaire (et récupérées par
    la méthode `getPostData`). L'implémentation de cette méthode est facultative et par défaut,
    aucune transformation ne sera faites à cette étape sur les données récupérées depuis le
    formulaire. Implémenter cette méthode pourra cependant se révéler utile en cas de champs de
    formulaire complexe (attribut composite par exemple).

  - `autocomplete_attr_values()`

    Génère de la liste des valeurs possibles de l'attribut dans un contexte *CLI*.

    /// note
    Pour plus d'informations sur le rôle et fonctionnement de cette méthode, référer aux
    commentaires de la méthode par défaut, définie dans la classe PHP parente `LSformElement`.
    Vous pouvez également vous inspirer des exemples d'implémentations fournies avec les autres
    type d'[LSformElement](#lsformelements).
    ///

- Un (ou plusieurs) fichier template pour la génération du code HTML du champ du formulaire.
  Communément, le fichier `LSformElement.tpl` est utilisé pour générer la structure de la liste des
  champs correspondant aux différentes valeurs de l'attribut. Ce template utilise une variable
  `$fieldTemplate` pour définir quel fichier template devra être utilisé pour générer le code HTML
  de chaque champ associés à une valeur. C'est ce second fichier de template qui est en général à
  fournir à minima avec votre [LSformElement](#lsformelements).

/// note
Il peut être utile d'étendre un type d'[LSformElement](#lsformelements) existant pour faciliter
l'implémentation d'un nouveau type. Pour cela, vous devez utiliser l'héritage de classe PHP en
faisant dériver vos nouvelles classes des classes du [LSformElement](#lsformelements) dont vous
vous inspirer, plutôt que les classes génériques. Vous pouvez prendre exemple sur le type
d'[LSformElement](#lsformelements) `pre` qui s'inspire du type `textarea`, ou encore du type
`url` dérivé du type `text`.
///
