# Les règles de validation syntaxiques (LSformRule)

Les [LSformRules](#lsformrules) sont les règles syntaxiques applicables aux champs des formulaires.
Ces règles serviront à s'assurer que les valeurs des champs récupérées des formulaires sont
syntaxiquement correctes. Elles seront configurables via le paramètre `check_data` des attributs des
[LSobjects](../conf/index.md#configuration-lsobject).

Pour chaque type implémenté, on trouvera une classe PHP dérivée de la classe `LSformRule` et devant
s'appeler `LSattr_rule_[nom du type]`. Dans celle-ci, il devra être défini la méthode statique
`validate()` qui implémentera le contrôle syntaxique. Cette méthode prendra en paramètres :

- `$value`

  La valeur à tester.

- `$options`

  Un tableau des options définies dans la configuration pour ce contrôle syntaxique.

- `$formElement`

  Une référence au champ du formulaire (objet [LSformElement](#lsformelements)).

Cette méthode devra retourner `True` ou `False` si la valeur testée est respectivement valide ou
invalide. Elle pourra également déclencher une exception `LSformRuleException` qui lui permettra de
donner des messages d'erreurs elle-même sur le(s) problème(s) detecté(s) durant l'analyse de la
valeur passée. Le constructeur de ce type d'exception prend en tant que premier paramètre un tableau
de messages d'erreurs (ou un simple message d'erreur) qui seront retournés à l'utilisateur.

/// note
Par défaut, les valeurs de l'attribut sont testées une à une via la méthode `validate()`.
Cependant, il est possible d'implémenter une méthode de validation pour toutes les valeurs de
l'attribut en une seule fois en affectant la valeur `false` à la constante de classe
`validate_one_by_one`. Dans ce cas, l'ensemble des valeurs de l'attribut seront passées via le
paramètre `$value` à la méthode `validate()` (sous la forme d'un tableau). Cela pourra par
exemple être utile pour implémenter une validation de la cohérence des valeurs les unes vis à
vis des autres (unicité, nombre maximum de valeurs, …).
///
