# Tutoriel d'installation

Cette section décrit les différentes étapes de l'installation de LdapSaisie. Deux méthodes
d'installation sont présentées ici, l'une à partir des sources du projet et l'autre à partir du
paquet Debian.

Dans ce tutoriel, nous partirons du principe que vous avez pleinement la main sur votre serveur
(installation de nouveau paquet et configuration de votre serveur web). Nous partons également du
principe que votre annuaire LDAP est déjà en place. Nous utiliserons pour cette exemple de mise en
oeuvre l'annuaire correspondant au schéma et à la configuration présente dans les sources du projet
dans le dossier `lsexample`.

La première étape consiste à installer le locigiel en tant que tel. Pour cela, référez vous au
chapitre [Téléchargement](#telechargement).

En cas d'installation à partir du paquet Debian, la configuration du logiciel se fera dans le
dossier `/etc/ldapsaisie/local/`. Les fichiers placés dans ce dossier prévaleront toujours aux
fichiers fournis par le paquet Debian, vous permettant facilement de modifier un composant existant
ou dans écrire de nouveaux. Ainsi, pour modifier un fichier CSS par exemple, il vous suffira de le
placer dans le dossier `/etc/ldapsaisie/local/css/`.

Pour une installation à partir du code source, il vous faut cloner le dépôt Git du projet dans le
dossier `/var/www/ldapsaisie`. Pour cela il vous faut avoir installés les outils de Git contenu,
dans Debian, dans le paquet `git-core`. Le dépôt Git doit ensuite être récupéré anonymement en
utilisant la commande suivante :

```
git clone https://gitlab.easter-eggs.com/ee/ldapsaisie.git /var/www/ldapsaisie
```

/// note
Pour que cette commande se déroule correctement, vous devez avoir accès au port TCP 443 du
serveur `gitlab.easter-eggs.com`. En cas de problème vérifiez votre parefeu.
///

La suite des opérations se déroulera donc maintenant dans le dossier `/var/www/ldapsaisie`. Pour
avoir plus de détails sur les élements qu'on retrouve dans ce dossier, vous pouvez consulter
[la section concernée](#arborescence-du-projet). Nous allons nous instérésser plus particulièrement :

* au script `upgradeFromGit.sh` permettant la mise à jour de votre repos tout en concervant les
  adaptations que nous ferons pour l'usage d'LdapSaisie adapté à notre annuaire ;

* au dossier `config.local` dans lequel seront stockés vos fichiers et vos adaptations de
  l'application ;

* au dossier `src/public_html` qui correspond à la futur racine du site web de l'application.

Le principe de l'adaptation est ici de mettre vos fichiers personnalisés dans le dossier
`config.local`, de les déclarer dans votre fichier `config.local/local.sh` contenant la liste des
fichiers devant être installés. Le fichier `local.sh` est la source de configuration du script
`upgradeFromGit.sh`. Il faut donc dans un premier temps créer votre fichier `local.sh` en copiant le
fichier d'example `local.sh.example`. Ce fichier est un script bash déclarant les variables de
configurations suivantes :

- `LOCAL_FILES`

  La liste des chemins des fichiers à installer dans l'arboressence du site. Cette élément doivent
  être séparés par des espaces ou des retour à la liste. Exemple :

  ```
  conf/config.inc.php
  lang/fr_FR.UTF8/lang.php
  ```

- `LOG_FILE`

  Nom du fichier de log des mises à jour.

- `THEME`

  Le nom du theme à installer (facultatif et non traité dans ce tutoriel).

  /// note
  Il est possible d'utiliser dans ce fichier de configuration la variable bash `$ROOT_DIR`
  correspondant au chemin du dossier d'installation, c'est à dire dans notre exemple
  `/var/www/ldapsaisie`.
  ///

La deuxième étape concerne la configuration globale de l'application : Cette partie est
principalement contenue dans le fichier `src/conf/config.inc.php` (ou
`/etc/ldapsaisie/local/conf/config.inc.php` en cas d'installation à partir du paquet Debian). En cas
d'installation à partir du code source, il faut donc dans un premier temps copier ce fichier dans le
dossier `config.local` et le déclarer dans la liste des fichiers à déployer lors des mises à jour
(variable `LOCAL_FILES` dans le fichier `local.sh`). Il s'agit en particulier dans ce fichier de
configurer la connexion à votre annuaire. Vous pouvez vous inspirer du fichier d'exemple fourni et
pour plus de détails, reportez-vous à [la section concernée](#configuration-globale).

/// note
Notez qu'il est possible de passer l'application en mode *debug* ce qui peut être utile par la
suite.
///

La troisième étape concerne la configuration des types de
[LSobjects](../conf/LSobject/index.md#configuration-lsobject) : Chaque type d'objet manipulé par
LdapSaisie doit correspondre avec un type de LSobject.

1. Création du fichier de classe *(optionnel)* : Ce fichier contient la déclaration de la classe PHP
  correspondant au type de LSobject. Cette classe étend la classe `LSldapObject` qui contient pour
  ainsi dire toute les méthodes et proprités nécessaires pour les types de LSobject simples. Si
  votre type de LSobject nécessite des méthodes ou propriétés particulières, vous pouvez implémenter
  cette classe. À défaut, une classe vierge d'adaptation sera automatiquement déclarée.

  Les fichiers des classes sont contenus dans le dossier `/includes/class/` et portent les noms
  composés de la manière suivante :

  ```
  class.LSobjects.[nom du type d'LSobject].php
  ```

2. Configurer vos LSobject : Cette partie est certainement la plus longue et consiste à déclarer
  l'ensemble des informations relatives aux types des objets LDAP manipulés. Les fichiers d'exemples
  fournis vous seront alors d'une aide précieuse. Basez vous sur l'un de pour créer le votre. Pour
  cela le fichier de configuration du type d'LSobjet `LSpeople` est le plus complet et est un bon
  point de départ. Pour plus de détails sur les élements de configuration de ce fichier,
  reportez-vous à [la section concernée](../conf/LSobject/index.md#configuration-lsobject).

3. Configurer si nécessaire les relations entre les objets appelés [LSrelations](#lsrelation). Les
  relations les plus simples (via un attribut de liaison) pourront être implémentées à l'aide d'un
  simple paramètrage. Pour des relations, plus complexes, il sera possible d'implémenter des
  méthodes personnalisées pour les gérer. Pour plus de détails, reportez-vous à
  [la section concernée](../conf/index.md#lsrelation).

  /// note
  Pour avoir un exemple de fichier de classe PHP implémentant des methodes de gestion de
  [LSrelations](#lsrelation) complexes, vous pouvez consulter le fichier de classe `LSgroup`.
  ///

/// warning | Attention
En cas d'installation à partir du code source, pensez à déclarer les fichiers que vous venez de
créer dans la variable `LOCAL_FILES` du fichier `local.sh`. Exemple pour le type d'LSobjet
portant comme nom `LSexample` :

```
src/conf/LSobjects/config.LSobjects.LSexample.php
src/includes/class/class.LSobjects.LSexample.php
```
///

/// note
Vous pouvez également personnaliser l'interface : Il est possible de personnaliser à votre goût
l'interface en écrivant votre template ou en modifiant simplement les fichiers CSS. Une partie
de cette documentation concernera bientôt cette problématique. Patience...
///

En cas d'installation à partir du code source, une dernière étape à ce niveau consiste à lancer le
script `upgradeFromGit.sh` pour qu'il installe les fichiers que vous venez de créer. Ce script est
conçu pour dire tout ce qu'il fait donc en cas de problème vous devriez rapidement comprendre où
cela coince. Dans tout les cas, n'hésitez pas à poser vos questions à la communauté sur la liste
<ldapsaisie-users@lists.ldapsaisie.org>.
