# Mise à jour 2.4.1 -> 3.0.0

Cette mise à jour majeure apporte de nombreuses nouveautés auxquelles il est important de prêter
attention. Cette section ne parlera pas particulièrement de ces nouveautés, mais vous pouvez
consulter le fichier
[debian/ldapsaisie.NEWS](https://gitlab.easter-eggs.com/ee/ldapsaisie/-/raw/master/debian/ldapsaisie.NEWS)
pour cela. Cette section listera en outre les points de vigilances à avoir et les adaptations à
apporter sur votre configuration et votre code personnalisé.

## Fichier config.inc.php

- ajout du paramètre `ConsoleTable` avec pour valeur par défaut sous  Debian
  `/usr/share/php/Console/Table.php`

- ajout du paramètre `public_root_url` avec pour valeur par défaut sous Debian `/ldapsaisie`

- paramètre `$GLOBALS['defaultCSSfiles']` : il est nécessaire de modifier les URLs des fichiers
  listés : seul le nom du fichier doit rester, sa localisation sera détectée automatiquement. Par
  exemple, `$GLOBALS['defaultCSSfiles'] = array('../light-blue.css');` devient
  `$GLOBALS['defaultCSSfiles'] = array('light-blue.css');`.

- les paramètres `authObjectType`, `authObjectFilter` et `authObjectTypeAttrPwd` sont remplacés par
  le tablau `LSobjects` dans le paramètre `LSauth`.

  Par exemple:

  ```
  'authObjectType' => 'LSpeople',
  'authObjectFilter' => '(|(uid=%{user})(mail=%{user}))',
  'authObjectTypeAttrPwd' => 'userPassword',
  ```

  Devient:

  ```
  'LSauth' => array (
    'LSobjects' => array(
      'LSpeople' => array(
        'filter' => '(|(uid=%{user})(mail=%{user}))',
        'password_attribute' => 'userPassword',
      ),
    ),
    [...]
  ),
  ```

- Une erreur de frappe historique a été corrigé dans le nom de la variable
  `$GLOBALS['defaultJSscripts']`, à savoir un *"R"* manquant.

- Les fichiers Javascript utilisés par défaut par l'application ne sont désormais plus listés dans
  la variable `$GLOBALS['defaultJSscripts']`. Seul doit y demeurer vos propres fichiers. Voici la
  liste des fichiers concernés et qui n'ont plus à être inclus via ce paramètre :

    - `mootools-core.js`
    - `mootools-more.js`
    - `functions.js`
    - `LSdefault.js`
    - `LSinfosBox.js`

## Fichiers CSS

/// note
Les fichiers `light-*.css` ont été retravaillés pour tous *hériter* du fichier `light-blue.css`
qui défini les couleurs de l'interface au travers des variables. Ainsi, il est très simple
d'ajuster ce thème à vos couleurs. Si cela vous intéresse, vous pouvez prendre exemple sur les
autres fichiers `light-*.css`.

Au passage, ce thème a été retravaillé pour prendre en compte la mise en forme d'un maximum de
composants de l'application tout en profitant du côté responsive de l'interface apporter par
cette mise à jour. Si vous avez un thème personnalisé, il est conseillé de regarder si celui-ci
ne pourrait pas tirer partie du fichier `light-blue.css` en le surchargeant. À minima, vous
pouvez analyser les évolutions de ce fichier pour identifier les modifications intéressantes à
reporter sur votre thème personnel.
///

- Si vous utilisez un des fichiers `light-*.css` autre que le fichier `light-blue.css`, vous devez
  désormais également charger ce dernier en premier.

- corriger les URL des images : `url(../../images/default/find.png)` devient `url(../image/find)`.
  Pour identifier les fichiers CSS concernés, vous pouvez utiliser les commandes suivantes :

  ```bash
  grep -Er 'url\(.*images' /etc/ldapsaisie/local/css
  grep -Er 'url\(.*\.(png|gif|jpg)' /etc/ldapsaisie/local/css
  ```

- modification CSS page `fatal_error` (fichier `base.css`) : `#fatal_error` devient `#error`

## Fichiers PHP

- `LSsession :: redirect()` devient `LSurl :: redirect()`. Pour identifier les fichiers CSS
  concernés, vous pouvez utiliser la commande suivante :

  ```bash
  grep -Er 'LSsession *:: *redirect *\(' /etc/ldapsaisie/local/
  ```

- Les méthodes de gestion des Javascript et CSS additionels ont été migrées de la classe `LSsession`
  vers la classe `LStemplate` :

  - `LSsession :: addJSscript()` devient `LStemplate :: addJSscript()`.

    Par ailleurs le paramètre `$path` disparait et la méthode `addLibJSscript` a été ajoutée pour
    permettre spécifiquement l'inclusion des fichiers Javascript des librairies. Voici quelques
    exemples d'utilisation et leur équivalent à présent:

    - `LSsession :: addJSscript('../../local/includes/js/LSformElement_eetelephone.js');`
      devient `LStemplate :: addJSscript('LSformElement_eetelephone.js');`

    - `LSsession :: addJSscript('../../local/includes/js/LSformElement_eetelephone.js');`
      devient `LStemplate :: addJSscript('LSformElement_eetelephone.js');`

    - `LSsession :: addJSscript('click-to-dial_view.js', 'local/includes/js/');` devient
      `LStemplate :: addJSscript('click-to-dial_view.js');`

    - `LSsession :: addJSscript('Picker.js',LS_LIB_DIR.'arian-mootools-datepicker/');`
      devient `LStemplate :: addLibJSscript('arian-mootools-datepicker/Picker.js');`

  - `LSsession :: addJSconfigParam()` devient `LStemplate :: addJSconfigParam()`.

  - `LSsession :: addHelpInfos()` devient `LStemplate :: addHelpInfo()`.

  - `LSsession :: addCssFile()` devient `LStemplate :: addCssFile()`.

    Par ailleurs le paramètre `$path` disparait et la méthode `addLibCssFile` à été ajoutée pour
    permettre spécifiquement l'inclusion des fichiers CSS des librairies. Voici quelques exemples
    d'utilisation et leur équivalent à présent:

    - `LSsession :: addCssFile('test.css', '../../local/css/');`  devient
      `LStemplate :: addCssFile('test.css');`. Doit donc être conservé, que le nom du fichier CSS,
      pas de chemin vers celui-ci.

    - `LSsession :: addCssFile('datepicker_vista.css',LS_LIB_DIR.'arian-mootools-datepicker/datepicker_vista/');`
      devient
      `LStemplate :: addLibCssFile('arian-mootools-datepicker/datepicker_vista/datepicker_vista.css');`

  Pour identifier les fichiers concernés, vous pouvez utiliser les commandes suivantes :

  ```bash
  grep -Er 'LSsession *:: *(addJSscript|addLibJSscript|addJSconfigParam|addHelpInfos|addCssFile|addLibCssFile) *\(' /etc/ldapsaisie/local/
  grep -Er '(LSsession|LStemplate) *:: *addJSscript\(.*local' /etc/ldapsaisie/local/
  grep -Er '(LSsession|LStemplate) *:: *addJSscript\(.*\.\.\/' /etc/ldapsaisie/local/
  grep -Er '(LSsession|LStemplate) *:: *addCssFile\(.*local' /etc/ldapsaisie/local/
  grep -Er '(LSsession|LStemplate) *:: *addCssFile\(.*\.\.\/' /etc/ldapsaisie/local/
  ```

- `LSlog` vs `LSdebug` : L’utilisation de `LSdebug` est dépriorisée en faveur de `LSlog`. Ce dernier
  ajoute désormais la notion de *logger*, permettant d’identifier la source des logs. Ce mécanisme
  permet la configuration d’un niveau de log spécifique pour un *logger* donné, ainsi que la mise en
  place de filtres au niveau des *handers* pour ne logger par exemple que certains *loggers*, ou à
  l’inverse en exclure d’autres.

  - Pour vos classes personnalisées : si celles-ci héritent d’une classe standard, il est fort
    probable qu’il soit possible d’utiliser des méthodes fournies par cette classe pour logguer
    au travers un *logger* dédié (voir les méthodes `log_debug`, `log_info`, …). À défaut, il est
    possible d’utiliser la classe `LSlog_staticLoggerClass` qui facilite l’implémentation.

  - Pour vos [LSaddons](../conf/index.md#configuration-des-lsaddons) : il est conseillé d’utiliser un
    *logger* `LSaddon_[addon]` dédié. Le *logger* peut facilement être récupéré de la manière
    suivante :

    ```php
    LSlog :: get_logger("LSaddon_[addon]")
    ```

    Cette méthode retourne une référence au *logger* et il est possible d’appeler directement une
    méthode de log, par exemple :

    ```php
    LSlog :: get_logger("LSaddon_[addon]") -> debug("message");
    ```

## Fichiers templates :

### Changement de l’inclusion des templates

- Le cas des fichiers `top.tpl` et `bottom.tpl`

  ```
  {include file='ls:top.tpl'}

  [...]

  {include file='ls:bottom.tpl'}
  ```

  devient :

  ```
  {extends file='ls:base_connected.tpl'}
  {block name="content"}

  [...]

  {/block}
  ```

  /// note
  Pages à l’état connecté uniquement (incluant le menu, l’entête…).
  ///

- Fichiers avec entête HTML :

  ```html
  <html>
    <head>
      [...]
    </head>
    <body>
      [...]
    </body>
  </html>
  ```

  devient :

  ```
  {extends file='ls:base.tpl'}
  {block name="body"}
  [...]
  {/block}
  ```

  Au besoin, si vous avez besoin :

  - de remplacer les fichiers CSS chargés par défaut (`base.css` par  exemple) : ajouter le block
    `css` :

    ```
    {block name="css"}
      <link rel="stylesheet" type="text/css" href="{css name='custom.css'}" media="screen" title="Normal" />
      {include file='ls:css.tpl'}
    {/block}
    ```

    /// note
    Ce block contient tous les CSS, y compris ceux gérés par `LSsession :: addCssFile()`.
    Pensez à ajouter `{include file='ls:css.tpl'}` pour conserver ces derniers.
    ///

  - d’ajouter des infos dans `<head>` : ajouter le block `head` (vide par défaut) :

    ```
    {block name="head"}
    [...]
    {/block}
    ```

  - d’ajouter des fichiers Javascript personnalisés : ajouter le block `js` (vide par défaut):

    ```
    {block name="js"}
    [...]
    {/block}
    ```

    /// note
    Ce block sera ajouté *APRÈS* les autres fichiers Javascript chargés (ceux par défaut et ceux
    ajoutés via `LSsession :: addJSscript()`.
    ///

- Autres fichiers remplacés :

  - `blank.tpl` remplacé par `base.tpl`
  - `empty.tpl` remplacé par `base_connected.tpl`
  - `accueil.tpl` remplacé par `homepage.tpl`

Pour identifier les fichiers concernés, vous pouvez utiliser la commande suivante :

```bash
grep -Er '(accueil|blank|empty|top|bottom)\.tpl' /etc/ldapsaisie/local/
```

### Fichiers templates fournis par défaut :

Vérifier les modifications des fichiers templates fourni avec l’application et que vous auriez
personnalisé. Pour cela, vous pouvez utiliser la commande suivante :

```bash
for i in $( ls /etc/ldapsaisie/local/templates/* )
do
    default_file="/usr/share/ldapsaisie/templates/default/$( basename "$i" )"
    [ ! -e "$default_file" ] && continue
    vi -d $default_file $i
done
```

/// note
Une attention particulière doit être porté aux fichiers `login.tpl` et `recoverpassword.tpl` qui
ont particulièrement changés.
///

### Corriger les URL des images :

`../../images/default/find.png` devient `../image/find`

Pour identifier les fichiers concernés, vous pouvez utiliser les commandes suivantes :

```bash
grep -Er 'images' /etc/ldapsaisie/local/templates
grep -Er '\.(png|gif|jpg)' /etc/ldapsaisie/local/templates
```

### Le cas de variable de template `{$LSsession_css}` et `{$LSsession_js}` :

/// note
Ceci est déjà géré si vous étendez bien vos templates du fichier `base.tpl` (pour les pages
non-connectées) ou `base_connected.tpl` (pour les pages connectées).
///

- `{$LSsession_css}` doit être remplacé par `{include file='ls:css.tpl'}`

- `{$LSsession_js}` doit être remplacé par `{include file='ls:js.tpl'}`

## Tous les fichiers : Modification des URLs

- `view.php` :

  - page recherche : `view.php?LSobject=LSpeople` devient `object/LSpeople`

  - page d'un objet : `view.php?LSobject=LSpeople&dn=$dn` devient `object/LSpeople/$dn`

- `addon_view.php` : `addon_view.php?LSaddon=ee&view=copyContract` devient `addon/ee/copyContract`

- `index_ajax.php` :

  - Pour les méthodes Ajax de classes :

    ```js
    var data = {
      template:   'LSformElement_eetelephone',
      action:     'make_call',
      telephoneNumber: tel,
      name: name,
    };
    new Request({url: 'index_ajax.php', data: data, onSuccess: ...});
    ```

    Devient :

    ```
    var data = {
      telephoneNumber: tel,
      name: name,
    };
    new Request({url: 'ajax/class/LSformElement_eetelephone/make_call', data: data, onSuccess: ...});
    ```

  - Pour les méthodes Ajax d'addon :

    ```js
    var data = {
      addon: 'asterisk',
      action: 'LSasterisk_make_call',
      telephoneNumber: tel,
      name: name,
      nocache: new Date().getTime()
    };
    new Request({url: 'index_ajax.php', data: data, onSuccess: ...});
    ```

    Devient :

    ```
    var data = {
      telephoneNumber: tel,
      name: name,
      nocache: new Date().getTime()
    };
    new Request({url: 'ajax/addon/asterisk/LSasterisk_make_call', data: data, onSuccess: ...});
    ```

- `global_search.php` : `global_search.php?refresh` devient `search?refresh`

- `index.php` : `index.php?LSsession_recoverPassword` devient `index?LSsession_recoverPassword`

- `create.php` : `create.php?LSobject=LSpeople` devient `object/LSpeople/create`

- `modify.php` : `modify.php?LSobject=LSpeople&dn=$dn` devient `object/LSpeople/$dn/modify`

- `import.php` : `import.php?LSobject=LSpeople` devient `object/LSpeople/import`

- `remove.php` : `remove.php?LSobject=LSpeople&dn=$dn` devient `object/LSpeople/$dn/remove`

  Avec validation : `remove.php?LSobject=LSpeople&dn=$dn&valid` devient
  `object/LSpeople/$dn/remove?valid`

- `select.php` : `select.php?LSobject=LSpeople` devient `object/LSpeople/select`

- `custom_action.php` :
  `custom_action.php?LSobject=LSpeople&dn=$dn&customAction=$customAction`
  devient `object/LSpeople/$dn/customAction/$customAction`

  Avec validation :
  `custom_action.php?LSobject=LSpeople&dn=$dn&customAction=$customAction&valid`
  devient `object/LSpeople/$dn/customAction/$customAction?valid`

- `custom_search_action.php` :
  `custom_search_action.php?LSobject=LSpeople&customAction=$customAction`
  devient `object/LSpeople/customAction/$customAction`

  Avec validation :
  `custom_search_action.php?LSobject=LSpeople&customAction=$customAction&valid`
  devient `object/LSpeople/customAction/$customAction?valid`

Pour identifier les fichiers concernés, vous pouvez utiliser la commande suivante :

```bash
grep -Er '(index|global_search|view|select|create|modify|import|remove|index_ajax|custom_action|custom_search_action|addon_view)\.php' /etc/ldapsaisie/local/
```
