# ldapSearchURI

Cette règle vérifie que la valeur est une URI de recherche LDAP valide, c'est à dire, par exemple,
`ldaps://ldap.example.com:636/o=example?attr1,attr2?one?(gidNumber=100)`

Cette vérification commence par découper la valeur à l'aide du sépérateur `?` et elle s'assure
ensuite :

- Que la première partie est bien une URI LDAP valide. Si l'hôte LDAP est spécifié, elle s'assure
  qu'il soit une adresse IP ou un nom de domaine valide. Si le port LDAP est spécifié, elle s'assure
  également qu'il soit correct et que l'hôte est également bien spécifié.

- Si la base de recherche est spécifiée, elle s'assure qu'elle soit compatible avec la racine de
  l'annuaire connecté.

- Si un ou plusieurs attributs sont spécifiés, elle les vérifie un à un afin de vérifier qu'il
  s'agit de nom d'attribut valide.

- Que le scope de recherche soit bien spécifié et valide.

- Si le filtre de recherche est spécifié, elle vérifie qu'il soit valide.

**Paramêtres de configuration :**

- `check_resolving_ldap_host`

  Si l'hôte du serveur LDAP est spécifié et qu'il s'agit d'un nom de domaine valide, un tentative de
  résolution DNS sera également faite (optionnel, par défaut : `True`).

- `host_required`

  Booléen détermintant si une erreur est relevée en cas d'absence de l'hôte LDAP. (optionnel,
  par défaut : `False`)

- `basedn_required`

  Booléen détermintant si une erreur est relevée en cas d'absence de base de recherche. (optionnel,
  par défaut : `False`)

- `scope_required`

  Booléen détermintant si une erreur est relevée en cas d'absence de portée de recherche.
  (optionnel, par défaut : `True`)

- `attr_required`

  Booléen détermintant si une erreur est relevée en cas d'absence d'attribut recherché. (optionnel,
  par défaut : `False`)

- `max_attrs_count`

  Nombre maximum d'attribut recherchés. (optionnel, par défaut : pas de limite)

- `filter_required`

  Booléen détermintant si une erreur est relevée en cas d'absence de filtre de recherche.
  (optionnel, par défaut : `False`)
