# Configuration globale

La plus grande partie de la configuration globale se trouve dans le fichier `config.inc.php`.

```
// Variables globales
$GLOBALS['LSconfig'] = array(
  // Variables globales
);

// Variables et constantes indépendantes
$var1 = 'val1'
$var2 = 'val2'
...
define('CONST1','val1')
define('CONST2','val2')
...
```

## Variables globales

- `NetLDAP2`

  Chemin vers la librairie [PEAR](http://pear.php.net/)
  [Net_LDAP2](http://pear.php.net/package/Net_LDAP2).

  ```
  /usr/share/php/Net/LDAP2.php
  ```

- `Smarty`

  Chemin vers le moteur de template [Smarty](http://www.smarty.net/).

  ```
  /usr/share/php/smarty/libs/Smarty.class.php
  ```

- `public_root_url`

  URL publique de la racine web de l'application. Il peut s'agir d'une URL relative bien qu'une URL
  absolue soit préférable, notament pour éviter l'auto-détection de celle-ci lorsque nécessaire
  (lien dans un e-mail par exemple. Par défaut : `/`.)

  !!! important

      Il est indispensable que ce paramètre soit configuré en adéquation avec votre environement
      pour que l'application fonctionne correctement (notament en cas en cas de déploiement dans un
      sous-dossier ou encore dans le cadre d'un accès à l'application au travers un
      *reverse-proxy*).

- `lang`

  Paramètre utilisé pour l'internationalisation : code de la langue (`fr_FR` ou `en_US`)

- `encoding`

  Encodage de caractère (`UTF8`)

- `ldap_servers`

  Configuration des serveurs LDAP.
  [Voir section concernée](ldap/index.md#configuration-des-serveurs-ldap).

### Préférences globales

!!! important

    Les variables globales suivantes ont une action globale, mais non-prioritaire sur le
    comportement de l'application. Il peux être redéfini pour chacun des serveurs LDAP.

- `cacheLSprofiles`

  Activation/Désactivation de la mise en cache des profils des utilisateurs connectés
  ([LSprofiles](ldap/LSprofile.md#profils-dutilisateurs)).

  Valeurs possibles : `True` ou `False`

  Valeur recommandée : `True`

  Valeur par défaut : `False`

- `cacheSubDn`

  Activation/Désactivation de la mise en cache des niveaux de connexion
  ([subDn](ldap/subDn.md#sous-niveaux-de-connexion)) dans l'annuaire.

  Valeurs possibles : `True` ou `False`

  Valeur recommandée : `True`

  Valeur par défaut : `False`

- `cacheSearch`

  Activation/Désactivation de la mise en cache du résultat des recherches dans l'annuaire.

  Valeurs possibles : `True` ou `False`

  Valeur recommandée : `True`

  Valeur par défaut : `False`

- `globalSearch`

  Activation/Désactivation de la recherche globale dans l'annuaire.

  Valeurs possibles : `True` ou `False`

  Valeur par défaut : `True`

- `keepLSsessionActive`

  Activation/Désactivation du maintient de la LSsession active.

  Valeurs possibles : `True` ou `False`

  Valeur par défaut : `False`

## Variables et constantes indépendantes

- `LS_THEME`

  Constante déterminant le nom du theme utilisé.

  Valeur par défaut : *default*

- `LS_TEMPLATES_DIR`

  Constante déterminant le chemin du dossier des templates.

  Valeur par défaut : *templates*

- `LS_IMAGES_DIR`

  Constante déterminant le chemin du dossier des images.

  Valeur par défaut : *images*

- `LS_CSS_DIR`

  Constante déterminant le chemin du dossier des CSS.

  Valeur par défaut : *css*

- `LSdebug`

  Variable booléenne déterminant si le débogage à l'écran est activé.

- `$GLOBALS['LSlog']`

  Variable permettant de configurer la journalisation de l'application.
  [Voir section concernée](LSlog.md#configuration-de-la-journalisation).

- `NB_LSOBJECT_LIST`

  Constante déterminant le nombre d'objet affichés par page de résultat de recherche.

- `NB_LSOBJECT_LIST_SELECT`

  Constante déterminant le nombre d'objet affichés par page de résultat de recherche dans une
  fenêtre _LSselect_.

- `$GLOBALS['NB_LSOBJECT_LIST_CHOICES']`

  Variable permettant de configurer la liste des choix proposés à l'utilisateur pour le nombre
  maximum d'objets affichés par page de résultat de recherche.

- `MAX_SEND_FILE_SIZE`

  Constante déterminant la taille maximale d'un fichier envoyé à travers les formulaires.

- `$GLOBALS['defaultJSscripts']`

  Tableau déterminant les fichiers Javascript à charger sur toute les pages.

- `$GLOBALS['defaultCSSfiles']`

  Tableau déterminant les fichiers CSS à charger sur toute les pages. Ces fichiers seront chargés
  dans l'ordre et en dernier permettant de surcharger tous paramètres de style.
