#!/bin/bash

cd $( dirname $0 )
DIST="$1"

# Need to use Dockerfile+ (https://github.com/edrevo/dockerfile-plus)
export DOCKER_BUILDKIT=1
export COMPOSE_DOCKER_CLI_BUILD=1
DISTS=(bookworm bullseye buster)
LATEST_DIST=${DISTS[0]}

for dist in ${DISTS[@]}
do
	[ -n "$DIST" -a "$DIST" != "$dist" ] && continue
	docker build -t docker.io/brenard/ldapsaisie:$dist -f Dockerfile.$dist .
	[ $? -eq 0 ] && docker push docker.io/brenard/ldapsaisie:$dist
done

[ -n "$DIST" -a "$DIST" != "latest" ] && exit

docker build -t docker.io/brenard/ldapsaisie:latest -f Dockerfile.$LATEST_DIST .
[ $? -eq 0 ] && docker push docker.io/brenard/ldapsaisie:latest
