# Configuration des règles de vérification d'intégrité

Cette section décrit la manière de configurer des règles de vérification d'intégrité sur les données
des attributs. Il est possible de valider la valeur de l'attribut par l'intermédiraire de la
vérification de résultat d'une recherche paramètrable dans l'annuaire ou encore d'appeler une
fonction de votre choix pour effectuer la vérification voulue.

## Validation par l'analyse du résultat d'une recherche dans l'annuaire

Une telle règle permet de vérifier si les valeurs des attributs n'entrent pas en conflit avec
d'autres objets de l'annuaire. Ce test peut également permetre de vérifier si les valeurs devant
faire référence à d'autres objets de l'annuaire sont correctes.

```
'validation' => array (
  ...
  array(
    'msg' => "[LSformat du message d'erreur]",
    'filter' => '[LSformat du filtre de la recherche]',
    'object_type' => '[Type d'LSobject recherché]',
    'basedn' => '[BaseDn de la recherche]',
    'scope' => '[Scope de la recherche]',
    'result' => '[Résultat positif de la recherche]',
    'except_current_object' => '[Exclure l'objet courant]'
  ),
  ...
),
...
```

- `msg`

  [LSformat](../../global/LSformat.md#format-parametrable) du message d'erreur à afficher lorsque la
  validation échoue. Ce format est construit avec les valeurs du
  [LSobject](../index.md#configuration-lsobject).

- `filter`

  [LSformat](../../global/LSformat.md#format-parametrable) du filtre de la recherche. Ce format peut
  être construit avec toutes les valeurs du LSobject (attributs, DN, ...) et également avec la
  valeur à valider en utilisant pour mot clé `%{val}`.

- `object_type`

  Le nom du type d'LSobject recherché. Si un type est spécifié, le filtre de la recherche sera une
  combinaison de celui du paramètre `filter` et du filtre composé à partir des *objectClass* du type
  d'[LSobject](../index.md#configuration-lsobject). *Paramètre facultatif.*

- `basedn`

  Le *basedn* de la recherche *(Paramètre facultatif, par défaut : racine de l'annuaire)*.

- `scope`

  Le *scope* de la recherche *(Paramètre facultatif, par défaut : `sub`)*.

- `result`

  Le résultat de la recherche : si `result` vaut zéro, la recherche ne devra retourner aucun objet
  pour que la validation soit réussie. Sinon, la recherche devra retourner au moins un objet.

- `except_current_object`

  Booléen définissant si l'objet courrant doit être exclu du résultat de la recherche. Ce paramètre
  n'est évalué quand cas de création (formulaire `create`).

## Validation par l'exécution d'une fonction

Il est possible d'effectuer la validation de l'attribut par l'exécution d'une fonction de votre
choix. Il lui sera passé en paramètre une référence à l'objet `LSldapObject` courant. Si la fonction
ne retourne pas *true*, la validation échouera.

```
'validation' => array (
  ..
  array(
    'msg' => "[LSformat du message d'erreur]",
    'function' => '[Nom de la fonction de validation]'
  ),
  ...
),
...
```

- `msg`

  [LSformat](../../global/LSformat.md#format-parametrable) du message d'erreur à afficher lorsque la
  validation échoue. Ce format est construit avec les valeurs du
  [LSobject](../index.md#configuration-lsobject).

- `function`

  Le nom de la fonction à exécuter. Si cette fonction n'existe pas, un message d'erreur sera affiché
  et la validation échouera.
