# LSaddon_mailquota

Cet [LSaddon](index.md#configuration-des-lsaddons) fournie une fonction `mailquota_get_usage`
pouvant être utilisée pour récupérer l'utilisation du quota d'une boîte mail IMAP. Pour cela,
LdapSaisie se connecte au serveur IMAP en utilisant un compte maître.

Cet [LSaddon](index.md#configuration-des-lsaddons) fournie une également une fonction
`mailquota_show_usage` pouvant être utilisée comme
[customActions](../LSobject/customActions.md#customactions) et permettant d'afficher l'utilisation
du quota de la boîte mail correspondante via une message dynamique (`LSinfo`).

Des paramètres de configuration sont disponibles dans le fichier de configuration
`config.LSaddons.mailquota.php`.

```php
// IMAP Mailbox connection string LSformat (composed with LSldapObject attributes)
// See : https://php.net/imap_open (parameter $mailbox)
define('MAILQUOTA_IMAP_MAILBOX','{localhost}');

// IMAP Master user
define('MAILQUOTA_IMAP_MASTER_USER', 'ldapsaisie');

// IMAP Master user's password
define('MAILQUOTA_IMAP_MASTER_USER_PWD', 'secret');

// IMAP Master user LSformat composed with :
//  * masteruser = master username (MAILQUOTA_IMAP_MASTER_USER)
//  * LSldapObject attributes
define('MAILQUOTA_IMAP_MASTER_USER_FORMAT', '%{mail}*%{masteruser}');

// IMAP quota root mailbox
define('MAILQUOTA_IMAP_QUOTA_ROOT_MAILBOX', 'INBOX');
```

Ci-dessous, vous trouverez un exemple de configuration de la fonction `mailquota_show_usage()`
comme [customActions](../LSobject/customActions.md#customactions) :

```php
$GLOBALS['LSobjects']['LSpeople'] = array (
        [...]
        'customActions' => array (
                'showmailquotausage' => array (
                        'function' => 'mailquota_show_usage',
                        'label' => 'Show mail quota usage',
                        'noConfirmation' => true,
                        'disableOnSuccessMsg' => true,
                        'icon' => 'mail',
                        'rights' => array (
                                'admin'
                        )
                ),
                [...]
        ),
        [...]
);
```
