# Sous-niveaux de connexion

Cette section décrit la manière de définir des sous-niveaux de connexion à l'annuaire (*subDn*). Le
concept de sous-niveau de connexion sert à déclarer les niveaux logiques de l'annuaire. Par exemple,
dans un annuaire dans lequel sont stockés des objets concernant plusieurs organisations et que
celles-ci se distinguent grâce à la présence d'une séparation dans l'arbre, il sera alors possible
de définir des sous-niveaux de connexion pour chacune des organisations.

**Exemple d'arborescence d'annuaire utilisant le concept de sous-niveaux correspondant à des sociétés :**

```
|- o=ls
| |- ou=companies
| | |- ou=company1
| | | |- ou=people
| | | |- ou=groups
| | |- ou=company2
| | | |- ou=people
| | | |- ou=groups
| |- ou=people
| |- ou=groups
```

Explications : Il est possible dans cet exemple de définir des sous-niveaux de connexion
correspondants aux sociétés. Dans chacune de ces sociétés, on retrouve les *OU* correspondant au
type d'*LSobjets*. Lors de la connexion à l'interface, l'utilisateur devra choisir dans quel
sous-niveau de l'annuaire il souhaite se connecter. Une fois connecté, l'utilisateur manipulera
uniquement les objets du sous-niveau de l'annuaire dans lequel il se trouve. Il lui sera également
possible de changer de sous-niveau de connexion à travers l'interface : une liste déroulante est
disponible pour cela dans le menu.

Il existe deux manières de déclarer des sous-niveaux de connexion à l'annuaire :

- En déclarant manuellement un *subDn* de l'annuaire et en lui donnant un nom.

- En listant les *LSobjets* d'un type précis et en utilisant leurs données pour constituer le nom
  des sous-niveaux. Cette liste est constituée en effectuant une recherche dans l'annuaire. Il est
  possible de définir un *basedn* particulier pour cette recherche.

Pour chacune de ces méthodes on définira également les types d'*LSobjets* qui sont présents dans
cette branche de l'annuaire.

```
'subDn' => array(
  // Déclaration manuelle
  '[Nom du sous-niveau]' => array(
    'dn' => '[basedn du sous-niveau]',
    'nologin' => true, // Désactive la connection dans ce subDn
    'LSobjects' => array( // Liste des types d'LSobjets présents dans le sous-niveau
      [LSobject1],
      [LSobject2],
      ...
    )
  ),
  // Liste de LSobjets
  'LSobject' => array(
    '[type d'LSobject]' => array( // le type d'LSobjet à lister
      'basedn' => '[basedn]', // Le basedn de la recherche
      'displayValue' => '[format]', // Format du nom des sous-niveaux
      'nologin' => true, // Désactive la connection dans ces subDn
      'onlyAccessible' => True, // Pour que seul les LSobjet accessible à l'utilisateur soit listé
      'LSobjects' => array( // Liste des types d'LSobjets présents dans les sous-niveaux
        [LSobject1],
        [LSobject2],
        ...
      )
    )
  )
),
...
```
