<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * Règle de validation d'une valeur ne contenant que des lettres.
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSformRule_lettersonly extends LSformRule {

  /**
   * Validate form element value
   *
   * @param mixed $value The value to validate
   * @param array $options Validation options
   * @param LSformElement &$formElement The related LSformElement object
   *
   * @return boolean True if value is valid, False otherwise
   */
  public static function validate($value, $options, &$formElement) {
    $regex = '/^[a-zA-Z]+$/';
    LSsession :: loadLSclass('LSformRule_regex');
    return LSformRule_regex :: validate($value,$regex,$formElement);
  }

}
