<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/**
 * LSformRule to check GPG public key
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 */
class LSformRule_gpg_pub_key extends LSformRule {

  /**
   * Validate SSH public key value
   *
   * @param string $value The value to validate
   * @param array $options Validation options
   * @param LSformElement &$formElement The related formElement object
   *
   * @return boolean true if the value is valide, false if not
   */
  public static function validate($value, $options, &$formElement) {
    if (!class_exists('gnupg')) {
      LSerror :: addErrorCode('LSformRule_gpg_pub_key_01');
      return false;
    }
    // The home_dir parameter passed to gnupg_init() is not correctly handled in PHP 7.3, also set
    // the GNUPGHOME environment variable.
    putenv('GNUPGHOME='.LS_TMP_DIR_PATH);
    $gpg = new gnupg(["home_dir" => LS_TMP_DIR_PATH]);
    // Don't warn about (GNUPG_ERROR_SILENT is currently the default but ensure it)
    $gpg -> seterrormode(GNUPG_ERROR_SILENT);
    $info = $gpg -> import($value);
    // @phpstan-ignore-next-line
    return is_array($info) && ($info['imported'] + $info['unchanged']) == 1 && $info['fingerprint'];
  }

}

/*
 * Error Codes
 */
LSerror :: defineError('LSformRule_gpg_pub_key_01',
___("LSformRule_gpg_pub_key: PHP GnuPG extension is missing, can't validate value.")
);
