# Configuration de la journalisation (LSlog)

Cette section décrit le tableau de configuration de la journalisation de l'application.

```php
$GLOBALS['LSlog'] = array(
  'enable' => [booléen],
  'level' => '[niveau]',
  'log_errors_context' => [booléen],
  'log_errors_context_with_args' => [booléen],
  'handlers' => array(
    '[handler 1]',
    array (
      'handler' => [handler 2],
      'enabled' => [booléen],
      'level' => '[niveau]',
      'loggers' => array('logger1', [...]),
      'excluded_loggers' => array('logger2', [...]),
      'format' => '[LSformat]',
      'cli_format' => '[LSformat]',
      'datetime_prefix' => [booléen],
      'datetime_format' => '[format date()]',
      // Autres paramètres propre à ce handler
      [...]
    ),
    [...]
  ),
  'loggers' => array (
    'logger1' => array (
      'level' => 'DEBUG',
    ),
    'logger2' => array (
      'enabled' => false,
    ),
    [...]
  );
);
...
```

- `enable`

  Booléen permatant d'activer ou désactiver complètement la journalisation. Par défaut : `False`

- `level`

  Ce paramètre défini le niveau minimum de la journalisation : tous les messages des niveaux
  inférieurs ne seront pas inclus dans le journal de l'application. Les niveaux de journalisation
  gérés par l'application sont (dans l'ordre du plus petit au plus grand) :

  - `TRACE`
  - `DEBUG`
  - `INFO`
  - `WARNING`
  - `ERROR`
  - `FATAL`

- `log_errors_context`

  Booléen permatant de définir si le contexte _(=backtrace)_ doit être inclus lors de la
  journalisation d'une erreurs.

- `log_errors_context_with_args`

  Booléen permatant de définir si les arguments des méthodes/fonctions appelées doivent être
  inclus lors de la journalisation du contexte des erreurs.
  __Note :__ ce paramètre n'as aucun effet si le paramètre `log_errors_context` n'est pas activé.

- `handlers`

  Tableau permettant de configurer les *handlers* de la journalisation. Chaque *handler* gère les
  messages journalisés d'une manière qui lui est propre.

  Plusieurs *handlers* peuvent être configurés en même temps (y compris plusieurs *handlers* du même
  type).

  Ce tableau peut contenir simplement le nom du type de *handler* à  utiliser ou bien des tableaux
  configurant un à un chacun des *handlers*. Dans ce second cas, la structure de la configuration
  d'un *handler* est la suivante :

  ```php
  array(
    'handler' => [type],
    'level' => '[niveau]',
    'loggers' => array('logger1', [...]),
    'excluded_loggers' => array('logger2', [...]),
    'format' => '[LSformat]',
    'cli_format' => '[LSformat]',
    'datetime_prefix' => [booléen],
    'datetime_format' => '[format date()]',
    // Autres paramètres propre à ce handler
    [...]
  )
  ...
  ```

  - `handler`

    Type du *handler* (voir ci-dessous).

  - `level`

    Ce paramètre défini le niveau minimum de la journalisation spécifique à cet *handler*. Si ce
    paramètre est omis, le niveau global sera utilisé. Les valeurs possibles de ce paramètre sont
    les mêmes que pour le paramètre ` $GLOBALS['LSlog']['level']`.

  - `enabled`

    Booléen permettant d'activer ou désactiver cet *handler* (paramètre facultatif, par défaut :
    `True`).

  - `loggers`

    Liste exhautive des composants dont les messages doivent être traités par ce handler (paramètre
    facultatif, par défaut : tous les composants).

  - `excluded_loggers`

    Liste exhautive des composants dont les messages ne doivent pas être traités par ce handler
    (paramètre facultatif, par défaut : aucun composant).

  - `format`

    [LSformat](LSformat.md#format-parametrable) des messages de cet journalisé par ce handler. Ce
    format est composé à partir des informations décritent ci-dessous. Par défaut :

    ```
    %{requesturi} - %{remoteaddr} - %{ldapservername} - %{authuser} - %{logger} - %{level} - %{message}
    ```

    - `level`

      Le niveau du message.

    - `message`

      Le message.

    - `logger`

      Le composant ayant déchenché cette journalisation.

    - `clibinpath`

      Le nom du script ayant déclenché cette jounalisation (uniquement en cas d'exécution en ligne
      de commande).

    - `requesturi`

      L'URL de la page courante (uniquement dans un contexte Web).

    - `remoteaddr`

      L'adresse IP du client (uniquement dans un contexte Web).

    - `ldapservername`

      Le nom du serveur LDAP courant.

    - `authuser`

      Le DN de l'utilisateur connecté (uniquement dans un contexte Web).

  - `cli_format`

    [LSformat](LSformat.md#format-parametrable) des messages de cet journalisé par ce handler dans
    le cas d'une exécution en ligne de commande. Ce format est composé à partir des même
    informations que le paramètre `format` (voir ci-dessus). Par défaut :
    ```
    %{clibinpath} - %{logger} - %{level} - %{message}
    ```

  - `datetime_format`

    Booléen permettant de définir si le message doit être préfixé de la date et heure courante. La
    valeur par défaut dépends de l'handler (en règle général, toujours actif sauf lorsque le canal
    de journalisation l'ajoute déjà).

  - `datetime_format`

    Format de la date et heure lorsque celle-ci est ajoutée en préfixe du message (voir paramètre
    `datetime_format`). Le format correspond à celui attendu par la function `date()` de
    [PHP](http://www.php.net/). Consultez la [documentation officielle](http://php.net/date) pour
    plus de détails (Par défaut : `Y/m/d H:i:s`).

  Il existe plusieurs types d'*handlers* gérés par l'application :

  - `file`

    Journalisation dans un simple fichier texte. Le chemin du fichier peut être configuré via le
    paramètre `path`. Si ce paramètre est omis, le chemin du fichier par défaut est soit la
    valeur de la variable `$GLOBALS['LSlog']['filename']` (pour la rétro-compatibilité avec les
    anciennes versions d'LdapSaisie) ou à défaut : `tmp/LS.log`.

  - `syslog`

    Journalisation via le service *syslog*. Il est possible de configurer une priorité
    systématique pour les messages journalisés. À défaut, la priorité sera déterminée
    automatiquement en fonction du niveau du message. Les valeurs
    possibles de ce paramètre sont : `EMERG, ALERT, CRITICAL,ERROR, WARNING, NOTICE, INFO, DEBUG`

  - `system`

    Journalisation via le gestionnaire d'erreurs PHP. Cet *handler* utilise la fonction
    [PHP](http://www.php.net/) `error_log`. Pour plus d'informations sur comment configurer le
    gestionnaire d'erreurs PHP, consulter la
    [documentation officielle](https://www.php.net/error_log).

  - `email`

    Journalisation via l'envoi d'un email : chaque message journalisé déclenchera l'envoi d'un email
    au destinataire configuré. L'adresse email du destinataire peut-être configurée via le paramètre
    `recipient`.

    !!! note

        Il est conseillé d'utiliser ce type d'*handler* avec un niveau minimum de journalisation
        important (`FATAL` recommandé) pour ne pas déclencher un nombre trop important d'envois
        d'emails.

- `loggers`

  Tableau permettant de configurer la journalisation composant par composant. Chaque composant peut
  avoir son propre `logger` ce qui permet alors, par exemple, de configurer le niveau de log
  spécifiquement pour ce composant.

  Le nom des composant correspond en général au nom de la classe PHP correspondante, ou bien encore
  le nom d'une commande (lors d'une exécution en ligne de commande).

  !!! note

      Par défaut, le nom du composant ayant déclenché un message journalisé est affiché juste avant
      le niveau de log.

  - `enabled`

    Booléen permettant de désactiver complètement les logs du composant (par défaut: `True`).

  - `level`

    Niveau de log spécifique pour ce composant (par défaut: le niveau de log global).
