<?php
/*******************************************************************************
 * Copyright (C) 2022 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

// Accesslog base DN
define('LS_ACCESSLOG_BASEDN', 'cn=ldapsaisie-accesslog');

/*
 * Enable logging write events on LDAP entries managed by LdapSaisie in the accesslog base
 *
 * The feature permit to LdapSaisie to write it self log entries in accesslog base about
 * modifications made with its system account with the right author DN.
 *
 * Note: If your LDAP directory ACL permit to your users to do them self modifications on LDAP
 * directory, the recommanded way is to use authz proxy authentication (see useAuthzProxyControl
 * configuration parameter).
 */
define('LS_ACCESSLOG_LOG_WRITE_EVENTS', false);
