# Pré-requis

- Le service Apache HTTP avec le module mod_rewrite d'activé. Les règles de réécriture d'URL sont
  définies dans le fichier `.htaccess` fourni avec l'application et il est donc nécessaire
  d'autoriser une telle configuration à ce niveau via la directive `AllowOverride` devant inclure à
  minima `FileInfo`.

- L'utisateur exécutant le serveur web doit avoir les droits d'écriture sur le dossier `tmp`. En cas
  d'installation à partir du paquet Debian, ce dossier est remplacé par un lien symbolique vers
  le dossier `/var/cache/ldapsaisie/`.

- PHP 5.6 (ou supérieur) avec `magic_quotes_gpc` et `register_globals` à `off`. L'outil CLI de PHP
  est par ailleurs nécessaire pour l'utilisation des outils CLI fournis avec l'application (fourni
  par le paquet `php-cli` dans Debian).

- Le support LDAP dans PHP (paquet `php-ldap` dans Debian)

- Le support mhash dans PHP (paquet `php5-mhash` dans Debian Lenny, intégré à `php-common` dans les
  versions supérieurs)

- Le support json dans PHP (`pear install pecl/json` sur RedHat, intégré au paquet `php5-common`
  précédement)

- [Net_LDAP2](http://pear.php.net/package/Net_LDAP2) (paquet `php-net-ldap2` dans Debian ou
  `pear install net_ldap2`)

- Le support mbstring dans PHP (paquet `php-mbstring` depuis Debian Stretch, intégré au paquet
  `php-common` dans Debian)

- [Smarty](http://www.smarty.net/) (paquet `smarty3` dans Debian)

- La librairie [Console_Table](https://pear.php.net/package/Console_Table) (nécessaire pour le
  fonctionnement de l'outil CLI, paquet `php-console-table` dans Debian)

- Les librairies [Mail](https://pear.php.net/package/Mail) et
  [PEAR_Mail_Mime](https://pear.php.net/package/Mail_Mime) (nécessaire pour l'envoi de courriels,
  paquets `php-mail` et `php-mail-mime` dans Debian)

- L'[extension PHP `ftp`](https://www.php.net/manual/fr/intro.ftp.php) (nécessaire pour le
  fonctionnement du [LSaddon](../conf/index.md#configuration-des-lsaddons) FTP, paquet `php-ftp`
  dans Debian)

- La librairie [PhpSecLib](https://github.com/phpseclib/phpseclib) (nécessaire pour le
  fonctionnement du [LSaddon](../conf/index.md#configuration-des-lsaddons) SSH, paquet
  `php-phpseclib` dans Debian)

!!! warning

    La librairie [Net_LDAP2](http://pear.php.net/package/Net_LDAP2) oblige le fait que la racine DSE
    de l'annuaire soit lisible en anonyme sinon la connexion à l'annuaire échouera systématiquement.

!!! note

    Cette documentation est écrite à l'aide du langage Markdown et est mis en forme pour une
    consultation en ligne à l'aide de [mkdocs](https://www.mkdocs.org/) et son thème
    [mkdocs-material](https://squidfunk.github.io/mkdocs-material/). Le dépendances pour construire
    cette documentation sont listées dans le fichier `doc/requirements.txt` et sont installables à
    l'aide de la commande `pip install -r doc/requirements.txt`.
