# LSattr_html_jsonCompositeAttribute

Ce type est utilisé pour la gestion des attributs dont les valeurs sont des dictionnaires de valeurs
encodées aux formats *JSON*.

Exemple de valeur gérée :

```json
{"component1": "value1", "component2": "value2", "component3": "value3"}
```

Le principe est que ces dictionnaires contienent plusieurs composants référencés par leur clé et
stockant une valeur dont le type peut être un texte libre ou bien être issue d'une liste déroulante
configurable selon le même principe que le type d'attribut
[LSattr_html_select_list](LSattr_html_select_list.md#lsattr_html_select_list).

```
'html_options' => array (
   'components' => array (
     '[clé composant 1]' => array (
       'label' => '[Label du composant]',
       'help_info' => '[Message d'aide sur le composant]',
       'type' => '[Type de la valeur stocké]',
       'required' => [Booléen],
       'multiple' => [Booléen],
       'check_data' => => array (
         // Régle de vérification syntaxique des données saisies
       ),
     ),
     '[clé composant 2]' => array (
       'label' => '[Label du composant 2]',
       'type' => 'select_list',
       'required' => [Booléen],
       'options' => array (
         [Configuration équivalente à un attribut LSattr_html_select_list]
       )
     ),
     [...]
   ),
   'fullWidth' => [booléen],
),
...
```

- `components`

  Tableau associatif obligatoire contenant en valeur clé, l'identifiant des composants,
  correspondant à la clé dans le dictionnaire *JSON*, et en valeurs associés, la configuration du
  composant.

  - `label`

    Le label du composant.

  - `help_info`

    Message d'aide sur le composant (affiché uniquement en mode édition).

  - `type`

    Le type de valeur du composant. Les types possibles sont `text` ou `select_list` pour
    respectivement soit une valeur saisie librement, soit une valeur sélectionnée parmis une liste
    déroulante.

  - `options`

    Dans le cadre d'un composant de type `select_list`, cela correspond à la configuration de la
    liste déroulante. Cette configuration utilise la même syntaxe de configuration que celle du type
    d'attribut [LSattr_html_select_list](LSattr_html_select_list.md#lsattr_html_select_list) et son
    paramètre `html_options`.

  - `multiple`

    Booléen définissant si ce composant peut stocker plusieurs valeurs (Par défaut : `False`).

  - `required`

    Booléen définissant si ce composant doit obligatoirement être défini (Par défaut : `False`).

  - `check_data`

    Tableau associatif contenant les règles de vérification syntaxique des données du composant. Ces
    règles sont configurables de la même manière que les celles des valeurs attributs.
    [Voir la section concernée.](../check_data/index.md#configuration-des-regles-de-verification-syntaxique)

- `fullWidth`

  Booléen permettant de définir si l'affichage dans le formulaire doit se faire sur toute la largeur
  disponible de la page (Par défaut : `False`).
