{extends file='ls:base_connected.tpl'}
{block name="content"}
<h1>{$pagetitle}</h1>

{include file='ls:LSview_actions.tpl'}

<ul class="LStabs">
  <li{if $tab=="subject"} class="LStabs_active"{/if}>
    <a href="addon/mail/templates?name={$template.name}&tab=subject">{tr msg="Subject"}</a>
  </li>
  <li{if $tab=="html"} class="LStabs_active"{/if}>
    <a href="addon/mail/templates?name={$template.name}&tab=html">{tr msg="HTML content"}</a>
  </li>
  <li{if $tab=="txt"} class="LStabs_active"{/if}>
    <a href="addon/mail/templates?name={$template.name}&tab=txt">{tr msg="Text content"}</a>
  </li>
</ul>

<div class='LStabs_content LStabs_content_active'>
  <form action="addon/mail/templates?name={$template.name}&tab={$tab}" method="POST">
    {if $tab == "subject"}
      <input type="text" name="subject" value="{$template.subject|escape:"htmlall"}"
        {if !$writable}disabled="disabled" class="LStips"
        title="{tr msg="No writable path to save your changes on the subject of this template."}"
        {/if}
      />
    {elseif $tab == "html"}
      <textarea name="html" {if !$writable}disabled="disabled"
      title="{tr msg="No writable path to save your changes on the HTML message of this template."}"
      {/if}
      >{$template.html}</textarea>
    {else}
      <textarea name="txt" {if !$writable}disabled="disabled" class="LStips"
      title="{tr msg="No writable path to save your changes on the text message of this template."}"
      {/if}
      >{$template.txt}</textarea>
    {/if}
    <div class="form-footer">
      <button type="submit">{tr msg="Save"}</button>
    </div>
  </form>
</div>
{/block}
{*
// vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
*}
