# LSaddon_ppolicy

Cet [LSaddon](index.md#configuration-des-lsaddons) fourni :

- une fonction `ppolicy_extraDisplayColumn_password_expiration` pouvant être utilisée pour la
  génération d'une *extraDisplayedColumn* affichant l'état d'expiration du mot de passe des objets
  d'une recherche.

  **Exemple d'utilisation :**

  ```
  $GLOBALS['LSobjects']['LSpeople']['LSsearch'] = array (
    [...]
    'extraDisplayedColumns' => array (
      [...]
      'password_expiration' => array (
        'label' => 'Password expiration',
        'generateFunction' => 'ppolicy_extraDisplayColumn_password_expiration',
        'additionalAttrs' => array('pwdChangedTime', 'pwdPolicySubentry'),
        'escape' => false,
        'cssStyle' => 'width: 14em; text-align: center;'
      ),
      [...]
    ),
    [...]
  );
  ```

- une fonction `ppolicy_export_search_info` pouvant être utilisée comme
  [actions personnalisées sur les recherches d'LSobjects](../LSobject/LSsearch.md#customactions_1)
  pour exporter au format CSV les informations des politiques de mots de passe des objets retournés
  par la recherche.

  **Exemple d'utilisation :**

  ```php
  $GLOBALS['LSobjects']['LSpeople']['LSsearch'] = array (
    [...]
    'customActions' => array (
      'exportPpolicyInfo' => array (
        'label' => 'Export password policy info',
        'icon' => 'export_csv',
        'function' => 'ppolicy_export_search_info',
        'noConfirmation' => true,
        'disableOnSuccessMsg' => true,
        'rights' => array (
          'admin',
        ),
      ),
    ),
    [...]
  );
  ```

- la méthode d'API `exportPpolicyInfo` permettant d'exporter les informations des politiques de mots
  de passe de tous les objets d'un type donné. Cette méthode est accessible via l'URL au format
  suivant : `/api/1.0/exportPpolicyInfo/[object type]`

- la commande CLI `export_ppolicy_info` permettant d'exporter les informations des politiques de
  mots de passe de tous les objets d'un type donné.

  **Utilisation :**

  ```bash
  ldapsaisie export_ppolicy_info [object type] [-o|--output filepath] [-j|--json [-p|--pretty]]
  ```

Des paramètres de configuration sont disponibles dans le fichier de configuration
`config.LSaddons.ppolicy.php`.

```php
// Default password policy object DN (set to null if no default policy is configured)
define('LS_PPOLICY_DEFAULT_DN', null);

// Ppolicy password warning expiration threshold (in seconds)
define('LS_PPOLICY_WARNING_EXPIRATION_THRESHOLD', 7 * 86400);

// Ppolicy password critical expiration threshold (in seconds)
define('LS_PPOLICY_CRITICAL_EXPIRATION_THRESHOLD', 2 * 86400);

// CSV file delimiter
define('LS_PPOLICY_CSV_DELIMITER',';');

// CSV file enclosure
define('LS_PPOLICY_CSV_ENCLOSURE','"');

// CSV file escape character (available since PHP 5.5.4)
define('LS_PPOLICY_CSV_ESCAPE_CHAR','\\');

// List of LSprofiles who are granted to use the exportPpolicyInfo API method
$GLOBALS['LS_PPOLICY_API_GRANTED_PROFILES'] = array('admin');

// List of extra attributes to include in Ppolicy info export
$GLOBALS['LS_PPOLICY_INFO_EXPORT_EXTRA_ATTRS'] = array();
```

- `LS_PPOLICY_DEFAULT_DN`

  Constante définissant le DN de la politique par défaut. Si aucune politique par défaut n'est
  définie, ce paramètre doit valoir `null`.

- `LS_PPOLICY_WARNING_EXPIRATION_THRESHOLD`

  Constante définissant le seuil d'alerte pour l'expiration des mots de passe (en seconde). Par
  défaut : 7 jours.

- `LS_PPOLICY_CRITICAL_EXPIRATION_THRESHOLD`

  Constante définissant le seuil critique pour l'expiration des mots de passe (en seconde). Par
  défaut : 2 jours.

- `LS_PPOLICY_CSV_DELIMITER`

  Constante définissant le caractère utilisé lors de la génération de l'export CSV comme séparateur
  de champ. Par défaut : un point-virgule.

- `LS_PPOLICY_CSV_ENCLOSURE`

  Constante définissant le caractère utilisé lors de la génération de l'export CSV pour
  l'encadrement des champs. Par défaut : un guillemet double.

- `LS_PPOLICY_CSV_ESCAPE_CHAR`

  Constante définissant le caractère utilisé lors de la génération de l'export CSV pour
  l'échappement des champs. Par défaut : une barre oblique inverse.

- `$GLOBALS['LS_PPOLICY_API_GRANTED_PROFILES']`

  Tableau global listant les [LSprofiles](../global/ldap/LSprofile.md#profils-dutilisateurs)
  autorisés à utiliser la méthode d'API `exportPpolicyInfo`.

- `$GLOBALS['LS_PPOLICY_INFO_EXPORT_EXTRA_ATTRS']`

  Tableau global listant les attributs supplémentaires à inclure lors de l'export des informations
  de politique de mots de passe.
