# LSattr_html_text

Ce type est utilisé pour la gestion des attributs dont la valeur est une chaîne de caractères devant
être affichée dans un champ *input* HTML de type *text*.

```
'html_options' => array(
  'generate_value_format' => '[LSformat pour la génération de la valeur]',
  'autoGenerateOnCreate' => [booléen],
  'autoGenerateOnModify' => [booléen],
  'withoutAccent' => [booleen],
  'replaceSpaces' => "[chaîne de remplacement]",
  'upperCase' => [booleen],
  'lowerCase' => [booleen],

  // Autocomplétion
  'autocomplete' => array (
    'object_type' => '[Type d'LSobject]', // facultatif (voir ci-dessous)
    'value_attributes' => array (
      '[attr1]',
      '[attr2]',
      [...]
    ),
    'filter' => '[filtre LDAP]',
    'basedn' => '[base DN spécifique]',
    'scope' => '[scope de recherche]',
    'displayFormat' => '[LSformat]',
    'onlyAccessible' => [booléen],
  ),

),
...
```

- `generate_value_format`

  [LSformat](../../../global/LSformat.md#format-parametrable) de la valeur utilisée pour la
  génération automatique de celle-ci à partir des informations saisies dans le formulaire. Les
  valeurs clefs du format sont les noms des attributs de l'objet. Seuls les attributs affichés au
  moins en lecture seule dans le formulaire peuvent être utilisés dans le format. Une seule valeur
  par attribut sera utilisée pour la génération : celle du premier champ (dans l'ordre d'apparition
  dans le formulaire).

  !!! important

      Seuls les éléments du formulaire de type HTML *input*, *select* ou *textarea* peuvent être
      utilisés.

- `autoGenerateOnCreate`

  Activation de la génération automatique lorsque celui-ci est vide au moment du chargement du
  formulaire (par défaut : `False`).

- `autoGenerateOnModify`

  Activation de la génération automatique lors de chaque modification de la valeur des champs du
  formulaire lié (par défaut : `False`).

- `withoutAccent`

  Activation de la suppression des accents dans la chaîne de caractères générée automatiquement
  (par défaut : `False`).

- `withoutAccent`

  Activation du remplacement des accents dans la chaîne de caractères générée automatiquement. La
  valeur de remplacement est celle du paramètre (par défaut : `False`).

- `upperCase`

  Activation de la mise en majuscule de la valeur générée automatiquement (par défaut : `False`).

- `lowerCase`

  Activation de la mise en minuscule de la valeur générée automatiquement (par défaut : `False`).

- `autocomplete`

  Paramètrage de l'autocomplétion des valeurs saisies : on paramètre ici la recherche des valeurs
  possibles de l'attribut dans l'annuaire qui peut se faire :

  - Sur la base d'un type d'[LSobject](../../../index.md#configuration-lsobject) donné :
    l'autocomplétion se fera alors comme n'importe quelle recherche d'un type d'objet donné.

  - Sur la base d'une recherche brute dans l'annuaire : l'autocomplétion se fera alors au travers
    une recherche brute dans l'annuaire sur n'importe quels objets ayant un des attributs spécifiés
    dans le paramètre `value_attributes` correspondant.

  Les paramètres associés à ces deux cas de figure sont décrits ci-dessous :

  - `object_type`

    Le type d'[LSobject](../../../index.md#configuration-lsobject) recherché.

  - `value_attributes`

    Le(s) nom de l'attribut stockant les valeurs possibles recherchées. Il peut s'agir d'une chaîne
    de caractères ou d'un tableau s'il y a plusieurs attributs.

  - `pattern_filter`

    Le [LSformat](../../../global/LSformat.md#format-parametrable) du filtre de recherche à partir
    du mot clé recherché. Ce paramètre est facultatif et utile que dans le cas d'une recherche sans
    type d'[LSobject](../../../index.md#configuration-lsobject) précis. S'il est défini, ce
    [LSformat](../../../global/LSformat.md#format-parametrable) sera composé à l'aide du mot clé
    recherché. À défaut, le filtre de recherche sera composé à l'aide des différents
    `value_attributes` configurés.

  - `filter`

    Un filtre de recherche facultatif venant en plus de celui calculé automatiquement à partir du
    mot clé de recherche.

  - `basedn`

    Le *basedn* de la recherche. *Paramètre facultatif.*

  - `scope`

    Le *scope* de la recherche. *Paramètre facultatif, par défaut : `sub`.*

  - `display_name_format`

    Le [LSformat](../../../global/LSformat.md#format-parametrable) d'affichage des objets trouvés.
    Ce paramètre est facultatif et par défaut, il s'agira du format d'affichage propre au type
    d'[LSobject](../../../index.md#configuration-lsobject) (si défini) et à défaut, la valeur
    possible trouvée sera affichée. Si est configuré, ce
    [LSformat](../../../global/LSformat.md#format-parametrable) sera composé à l'aide des valeurs
    brutes des attributs des objets correspondants avec en plus la valeur possible trouvée dans le
    mot clé `value`.

  - `only_accessible`

    Booléen falcultatif définissant si seul les
    [LSobjects](../../../index.md#configuration-lsobject) auxquels l'utilisateur connecté à accès
    doivent être considérés comme sélectionnables (Faux par défaut). Ce paramètre n'est appliqué que
    dans le cas d'une recherche pour un type d'[LSobject](../../../index.md#configuration-lsobject)
    donné.
