# LSattr_ldap_naiveDate

Ce type est utilisé pour la gestion des attributs dont la valeur est une date dont la *timezone*
doit être ignorée. Côté LDAP, les dates seront stockées au format UTC étant donnée que la syntaxe
LDAP exige une *timezone*, cependant celle-ci sera complètement ignorée. Ce type peut-être utilisé
à la place du type [LSattr_ldap_date](LSattr_ldap_date.md#lsattr_ldap_date).

```
'ldap_options' => array (
  'format' => '[Format de stockage]', // Default : "%Y%m%d%H%M%SZ"
),
...
```

- `format`

  Format de stockage de la date dans l'annuaire. Ce format est composé à partir des motifs clés
  gérés par la fonction `strftime()` de PHP. Pour plus d'information, consulter
  [la documentation officielle](http://www.php.net/strftime).

  !!! note

      La valeur par défaut est *%Y%m%d%H%M%SZ*, correspondant à la syntaxe `Generalized Time` (sans
      les micro-secondes) telle que définie dans la [RFC4517](https://tools.ietf.org/html/rfc4517).
      Exemple : `20091206230506Z` *(=2009/12/06 23:05:66 UTC)*.
