renderChart = function () {
  var chart;
  d3.json(
    'addon/orgchart/orgchartdata'
  ).then(data => {
    chart = new d3.OrgChart()
      .container('.chart-container')
      .nodeWidth((d) => 300)
      .initialZoom(0.7)
      .nodeHeight((d) => 70)
      .childrenMargin((d) => 40)
      .compactMarginBetween((d) => 15)
      .compactMarginPair((d) => 80)
      .data(data)
      .nodeContent(function (d, i, arr, state) {
        var template = document.getElementById('nodeTemplate').innerHTML;
        return Mustache.render(template, d.data);
      })
      .render();
  });
};

// vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
