# LSattr_ldap_date

Ce type est utilisé pour la gestion des attributs dont la valeur est une date.

!!! note

    Au sein d'LdapSaisie, les dates manipulées au travers ce type d'attribut LDAP, sont au format
    *timestamp*. Il s'agit donc de nombres entiers correpondants au nombre de secondes depuis le 1
    janvier 1970.

    Le type d'attribut HTML utilisé conjointement avec ce type d'attribut LDAP devra être prévu pour
    recevoir et fournir des dates au format *timestamp*, comme c'est le cas pour le [type d'attribut
    HTML *date*](../LSattr_html/LSattr_html_date.md#lsattr_html_date).

```
'ldap_options' => array (
  'timestamp' => [Booléen], // Si la date est stockée au format timestamp
  'formats' => array(
    '[Format de stockage principal]', // Par défaut : "YmdHisO"
    '[Formats de stockage alternatifs]', // Par défaut : "YmdHis.vO" & "YmdHis.uO"
    [...]
  ),
  'timezone' => '[Fuseau horaire]', // Default : "UTC"
),
...
```

- `timestamp`

  Booléen définissant si la date est stockée sous la forme d'un timestamp Unix (nombre de secondes
  depuis le 1er janvier 1970 à 00:00:00 UTC)­.

  Si `timestamp` est vrai, LdapSaisie ne tient pas compte du paramètre format.

- `formats`

  Formats de stockage de la date dans l'annuaire. Ces formats sont composés à partir des motifs clés
  gérés par la fonction `date()` de PHP. Pour plus d'information, consulter
  [la documentation officielle](http://www.php.net/date). Plusieurs formats peuvent être définis,
  mais en cas de stockage d'une nouvelle valeur, se sera le premier format défini qui sera utilisé.

  !!! note

      La valeur par défaut est *["YmdHisO", "YmdHis.vO", "YmdHis.uO"]*, correspondant à la syntaxe
      `Generalized Time` (sans et avec les milli-secondes ou micro-secondes) telle que définie dans
      la [RFC4517](https://tools.ietf.org/html/rfc4517).
      Exemples : `20091206230506Z` *(=2009/12/06 23:05:66 UTC)*, `20190613143537+0200`
      *(=2019/06/13 14:35:37 UTC+0200)* ou `20230818121005.307+0200`
      *(=2023/08/18 12:10:05.307 UTC+0200)*.

  !!! warning

      Si vous exploitez un attribut stockant une date incluant les milli-secondes ou les
      micro-secondes, ce type d'attribut LDAP sera capable de gérer l'interpratation des valeurs
      stockées, en outre le type d'attribut
      [LSattr_html_date](../LSattr_html/LSattr_html_date.md#lsattr_html_date), s'appuyant sur les
      méthodes standards `strftime()` et `strptime()`, ne permettra pas aujourd'hui leur saisie et
      affichage.

- `timezone`

  Fuseau horaire de stockage des dates dans l'annuaire LDAP. Les valeurs possibles sont documentées
  dans [la documentation officielle de PHP](https://www.php.net/timezones). (Par défaut : `UTC`)
