# LSauthMethod_HTTP

Cette [LSauthMethod](index.md#configuration-des-lsauthmethods) est utilisée pour gérer
l'authentification via les variables d'environnements définies suite à une authentification,
potentiellement déléguée au serveur web.

Cette méthode récupère dans l'environment d'exécution PHP, le nom d'utilisateur et le mot de passe
de l'utilisateur connecté. À partir du nom d'utilisateur, une recherche dans l'annuaire sera
effectuée pour trouver l'utilisateur correspondant. L'authentification sera réussie uniquement si un
et un seul utilisateur est retourné par la recherche et si une authentification auprès de l'annuaire
LDAP réussie à l'aide du DN de l'objet LDAP trouvé et du mot de passe fourni.

!!! note

    En cas d'authentification déléguée au serveur web, il est possible de désactiver la vérification
    du mot de passe via le paramètre `LSAUTHMETHOD_HTTP_TRUST_WITHOUT_PASSWORD_CHALLENGE`
    (voir ci-dessous).

Les variables d'environnements utilisées pour authentifier l'utilisateur connecté dépendent de la
méthode configurée via la constante `LSAUTHMETHOD_HTTP_METHOD` (voir ci-dessous). Si ces variables
ne sont pas disponibles, une erreur HTTP 403 sera générée pour réclamer une authentification à
l'utilisateur.

!!! note

    Cette [LSauthMethod](index.md#configuration-des-lsauthmethods) supporte le mode API et il s'agit
    de la méthode utilisée par défaut dans ce mode.

Cette librairie peut être configurée en éditant le fichier de configuration
`conf/LSauth/config.LSauthMethod_HTTP.php`.

**Structure du fichier :**

```php
/*
 *****************************************************
 * Configuration of the HTTP authentification support *
 *****************************************************
 */

// Don't check HTTP server's login/password by LDAP authentication challenge
//define('LSAUTHMETHOD_HTTP_TRUST_WITHOUT_PASSWORD_CHALLENGE',true);

// Authentication realm (API mode only)
//define('LSAUTHMETHOD_HTTP_API_REALM', ___('LdapSaisie API - Authentication required'));
```

- `LSAUTHMETHOD_HTTP_TRUST_WITHOUT_PASSWORD_CHALLENGE`

  Permet de désactiver le test d'authentification auprès de l'annuaire LDAP. Pour cela, cette
  constante doit être définie et valoir `True`.

- `LSAUTHMETHOD_HTTP_METHOD`

  Permet de définir la méthode utilisée par le serveur web pour passer à [PHP](http://www.php.net/)
  l'identifiant de l'utilisateur connecté et son mot de passe.

  Cette constance peut pendre les valeurs suivantes :

  - `PHP_PASS`

    Dans cette méthode, le serveur web défini les variables d'environnement `PHP_AUTH_USER` et
    `PHP_AUTH_PW`. Cette méthode est la méthode par défaut et convient en cas d'utilisation de
    `mod_php`.

  - `REMOTE_USER`

    Dans cette méthode, le serveur web défini la variable d'environnement `REMOTE_USER`. Cette
    variable ne contient que l'identifiant de l'utilisateur connecté. Cette méthode ne peut donc
    être utilisée que conjointement avec l'activation du paramètre
    `LSAUTHMETHOD_HTTP_TRUST_WITHOUT_PASSWORD_CHALLENGE`.

  - `AUTHORIZATION`

    Dans cette méthode, le serveur web passe le contenu de l'entête HTTP `Authorization` dans la
    variable d'environnement `HTTP_AUTHORIZATION`. Cette méthode convient en cas d'utilisation de
    [PHP](http://www.php.net/) en mode CGI ou encore via PHP-FPM.

    Pour utiliser cette méthode, il faudra adapter la configuration du serveur web. Par exemple,
    pour Apache HTTPd, vous pouvez utiliser le module `rewrite` et la règle de réécriture suivante :

    ```
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]
    ```

- `LSAUTHMETHOD_HTTP_LOGOUT_REMOTE_URL`

  URL de déconnexion externe, utile par exemple dans le contexte d'une connexion via un service SSO.
  L'utilisateur sera automatiquement redirigé vers cette URL après sa déconnexion effective au
  niveau d'LdapSaisie.

  !!! note

      Si cette URL de déconnexion n'est pas défini, le bouton de déconnexion sera masqué.

- `LSAUTHMETHOD_HTTP_REALM`

  Domaine d'authentification (`reaml`) utilisé pour réclamer l'authentification de l'utilisateur
  (facultatif).

  !!! note

      Pour que le message soit traduit, utilisez la fonction `___()` (voir exemple).
