# Les relations entre les objets de l'annuire (LSrelation)

Cette section décrit la manière de configurer les relations entre les
[LSobjects](index.md#configuration-lsobject) appelées *LSrelation*.

Dans le cadre d'une liaison dîte *simple*, c'est à dire une liaison au travers la valeur d'un
attribut qui fera directement référence à un autre objet (*DN* ou la première valeur d'un attribut
de référence), pourra être configurée simplement en spécifiant l'attribut de liaison et le type de
valeur qu'il contient. Dans le cas d'une liaison plus complexe, il sera possible de développer vous
même des méthodes de mise en relation.

```php
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['LSrelation'] = array (
  'relation1' => array(
    'label' => '[label de la relation]',
    'emptyText' => "[message]",
    'deleteOneConfirmText' => "[LSformat]",
    'deleteAllConfirmText' => "[message]",
    'LSobject' => '[le type d'LSobjet en relation]',
    'display_name_format' => '[LSformat du nom d'affichage des LSobjet en relation]',
    'canEdit_attribute' => '[nom d'attribut]',
    'copyable' => [booléen],

    // Liaison simple
    'linkAttribute' => '[attribut de liaison]',
    'linkAttributeValue' => '[valeur de l'attribut de liaison]',
    'linkAttributeOtherValues' => array('[autres valeurs possible de l'attribut de liaison]', [...]),

    // Liaison complexe
    'list_function' => '[méthode1]',
    'getkeyvalue_function' => '[methode2]',
    'update_function' => '[methode3]',
    'remove_function' => '[methode4]',
    'rename_function' => '[methode5]',
    'canEdit_function' => '[methode6]',

    'rights' => array(
      'LSprofile1' => 'r',
      'LSprofile2' => 'w',
      ...
    )
  )
);
```

- `label`

  Le label de la relation.

- `emptyText`

  Le texte à afficher pour décrire le fait que l'objet courant n'a aucune relation d'établie avec
  d'autres [LSobjects](index.md#configuration-lsobject). Exemple (au sujet d'un utilisateur) :
  *N'appartient à aucun groupe.*

- `deleteOneConfirmText`

  Format du message de confirmation de la suppression d'un objet lié composé à l'aide du nom de
  l'objet lié à supprimer (optionel).

- `deleteAllConfirmText`

  Message de confirmation de la suppression de tous les objets liés (optionel).

- `LSobject`

  Le type d'[LSobject](index.md#configuration-lsobject) en relation avec le type courant.
  *(Facultatif en cas de liaison complexe)*

- `display_name_format`

  [LSformat](../global/LSformat.md#format-parametrable) du nom d'affichage des objets en relation.

- `canEdit_attribute`

  Le nom de l'attibut du type d'[LSobject](index.md#configuration-lsobject) en relation devant être
  éditable par l'utilisateur pour que celui-ci puisse modifier la relation. Dans le cadre d'une
  relation simple, celui-ci peut, si nécessaire, être différent du paramètre `linkAttribute`.

- `copyable`

  Booléen définissant si ce type de relation doit être copié lors de la copie d'un objet
  (facultatif, par défaut : `False`).

- `linkAttribute`

  Dans le cadre d'une relation simple, il s'agit de l'attribut de liaison du type
  d'[LSobject](index.md#configuration-lsobject) en relation avec le type courant, c'est à dire
  l'attribut dans lequel on retrouve une valeur en relation avec l'objet courant.
  *(Facultatif en cas de liaison complexe)*

- `linkAttributeValue`

  Dans le cadre d'une relation simple, il s'agit du type de valeur prisent par l'attribut de liaison
  du type d'[LSobject](index.md#configuration-lsobject) en relation avec le type courant. Il peut
  s'agir du mot clé `dn` si l'attribut de liaison contient le *DN* de l'objet courant ou bien le nom
  d'un attribut du type d'objet courant dont la première valeur sera stockée par l'attribut de
  liaison. *(Facultatif en cas de liaison complexe)*

- `linkAttributeOtherValues`

  Dans le cadre d'une relation simple, il s'agit d'autres types de valeur possiblement prisent par
  l'attribut en plus de celui défini par le paramètre `linkAttributeValue`. Ce paramètre ne sert
  qu'a détecter des liaisons établies à l'aide de valeurs autres que celle relative au paramètre
  `linkAttributeValue` : en cas de nouvelle liaison, c'est la valeur associée à ce dernier qui sera
  utilisée pour établir la liaison. *(Facultatif en cas de liaison complexe)*

- `list_function`

  La méthode de la classe du type d'[LSobject](index.md#configuration-lsobject) en relation,
  permettant de lister les objets de ce type en relation avec l'objet courant.
  *(Facultatif en cas de liaison simple)*

- `getkeyvalue_function`

  La méthode de la classe du type d'[LSobject](index.md#configuration-lsobject) en relation,
  permettant d'obtenir la valeur clé à stocker pour établir la relation entre l'objet courant et
  d'autres objets du type concerné. *(Facultatif en cas de liaison simple)*

- `update_function`

  La méthode de la classe du type d'[LSobject](index.md#configuration-lsobject) en relation,
  permettant de mettre à jour les relations existantes entre l'objet courant et les objets du type
  concerné. Cette liste d'objets en relation est établie par l'utilisateur à travers l'interface.
  *(Facultatif en cas de liaison simple)*

- `remove_function`

  La méthode de la classe du type d'[LSobject](index.md#configuration-lsobject) en relation
  permettant de supprimer une relation existante entre l'objet courant et un objet du type concerné.
  *(Facultatif en cas de liaison simple)*

- `rename_function`

  La méthode de la classe du type d'[LSobject](index.md#configuration-lsobject) en relation
  permettant d'effectuer les actions nécessaires lorsque l'objet courant est renommé dans le but
  de maintenir les valeurs clés permettant d'établir les relations entre l'objet courant et les
  objets en relation avec lui. *(Facultatif en cas de liaison simple)*

- `canEdit_function`

  La méthode de la classe du type d'[LSobject](index.md#configuration-lsobject) en relation
  permettant de vérifier que l'utilisateur à le droit de modifier la relation avec un objet
  en particulier. *(Facultatif en cas de liaison simple)*

- `rights`

  Tableau associatif dont les clés sont les noms des
  [LSprofiles](../global/ldap/LSprofile.md#profils-dutilisateurs) ayant des droits sur cette
  relation et dont les valeurs associées sont les droits correspondants. La valeur des droits d'un
  [LSprofile](../global/ldap/LSprofile.md#profils-dutilisateurs) peut être `r` pour le droit de
  lecture ou `w` pour le droit de lecture-écriture.Par défaut, un
  [LSprofile](../global/ldap/LSprofile.md#profils-dutilisateurs) n'a aucun droit.
