<?php
/*******************************************************************************
 * Copyright (C) 2022 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/*
 ***********************************************
 * Ppolicy configuration
 ***********************************************
 */

// Default password policy object DN (set to null if no default policy is configured)
define('LS_PPOLICY_DEFAULT_DN', null);

// Ppolicy password warning expiration threshold (in seconds)
define('LS_PPOLICY_WARNING_EXPIRATION_THRESHOLD', 7 * 86400);

// Ppolicy password critical expiration threshold (in seconds)
define('LS_PPOLICY_CRITICAL_EXPIRATION_THRESHOLD', 2 * 86400);

// CSV file delimiter
define('LS_PPOLICY_CSV_DELIMITER',';');

// CSV file enclosure
define('LS_PPOLICY_CSV_ENCLOSURE','"');

// CSV file escape character (available since PHP 5.5.4)
define('LS_PPOLICY_CSV_ESCAPE_CHAR','\\');

// List of LSprofiles who are granted to use the exportPpolicyInfo API method
$GLOBALS['LS_PPOLICY_API_GRANTED_PROFILES'] = array('admin');

// List of extra attributes to include in Ppolicy info export
$GLOBALS['LS_PPOLICY_INFO_EXPORT_EXTRA_ATTRS'] = array();

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
