# Déclencheurs

Cette section décrit la manière de paramétrer des déclencheurs afin que LdapSaisie exécute durant
ses processus, et à des moments bien précis des traitements d'un
[LSobject](index.md#configuration-lsobject), des fonctions que vous pourrez développer vous même. De
plus, le résultat de l'exécution de vos fonctions pourra influer sur le déroulement des processus.

Actuellement, les évenements suivant sont gérés :

| Nom             | Description                       | Bloquant |
| --------------- | --------------------------------- | -------- |
| `before_create` | Avant la création du LSobject.    | Oui      |
| `after_create`  | Après la création du LSobject.    | Non      |
| `before_modify` | Avant la modification du LSobject | Oui      |
| `after_modify`  | Après la modification du LSobject | Non      |
| `before_rename` | Avant de renommer le LSobject     | Oui      |
| `after_rename`  | Après avoir renommé le LSobject   | Non      |
| `before_delete` | Avant la suppression du LSobject  | Oui      |
| `after_delete`  | Après la suppression du LSobject  | Non      |

!!! note

    Si un événement est dit *bloquant*, lors de l'exécution des actions liées, si une des fonctions
    retourne `false`, le processus s'arrêtera.

## Configuration

La configuration des déclencheurs se fait dans la définition des types
d'[LSobjects](index.md#configuration-lsobject). Par exemple, pour définir les fonctions à exécuter
après la modification des LSobjects de type *LSpeople*, c'est à dire lors de leur évènement
`after_modify`, il faut définir la variable suivante :

```php
$GLOBALS['LSobjects']['[nom du type d'LSobject]']['after_modify']
```

Cette variable peut contenir soit une chaine de caractères correspondant au nom de la fonction à
exécuter, soit un tableau de chaînes de caractères correspondant aux noms des fonctions à exécuter.

## Écriture d'une fonction

Une fonction exécuté par un déclencheur d'un LSobject se déclare de la manière suivante :

```php
/*
 * Ma fonction à exécuter lors de l'evenement [event]
 *
 * Paramètre :
 *     - $object : Le LSobject sur lequel l'évènement survient
 *
 * Valeurs retournées :
 *     - True : Tout s'est bien passé
 *     - False : Une erreur est survenue ou la fonction souhaite bloquer le
 *               processus lors d'un évènement bloquant.
 */
function maFonction ($object) {

  // Actions

}

```

Cette fonction doit prendre pour seul paramètre, le LSobject sur lequel l'évènement survient et doit
retourner soit `True` si tout s'est bien passé, soit `False` en cas de problème. Dans le cas d'un
événement bloquant, si la fonction retourne `False`, le processus est arrêté.
