<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

/*
 ***********************************************
 *          Send mail configuration            *
 ***********************************************
 */

// Pear :: Mail
define('PEAR_MAIL','/usr/share/php/Mail.php');

// Pear :: Mail_mime
define('PEAR_MAIL_MIME','/usr/share/php/Mail/mime.php');

// Html2Text
define('HTML2TEXT','/usr/share/php/Html2Text.php');

/*
 * Send method :
 *  - mail: using PHP mail() function
 *  - sendmail: using sendmail command
 *  - smtp: via SMTP server
 *  - discard: transparently discard outgoing email
 */
$GLOBALS['MAIL_SEND_METHOD'] = 'smtp';

/*
 * Sending parameters:
 *
 * Depend on send method, please consult PEAR :: Mail documentation for details:
 * Link: http://pear.php.net/manual/en/package.mail.mail.factory.php
 *
 * mail
 *    o If safe mode is disabled, $params will be passed as the fifth
 *      argument to the PHP mail() function. If $params is an array,
 *      its elements will be joined as a space-delimited string.
 * sendmail
 *    o $params["sendmail_path"] - The location of the sendmail program
 *      on the filesystem. Default is /usr/bin/sendmail.
 *    o $params["sendmail_args"] - Additional parameters to pass to the
 *      sendmail. Default is -i.
 * smtp
 *    o $params["host"] - The server to connect. Default is localhost.
 *    o $params["port"] - The port to connect. Default is 25.
 *    o $params["auth"] - Whether or not to use SMTP authentication.
 *      Default is FALSE.
 *    o $params["username"] - The username to use for SMTP authentication.
 *    o $params["password"] - The password to use for SMTP authentication.
 *    o $params["localhost"] - The value to give when sending EHLO or HELO.
 *      Default is localhost
 *    o $params["timeout"] - The SMTP connection timeout.
 *      Default is NULL (no timeout).
 *    o $params["verp"] - Whether to use VERP or not. Default is FALSE.
 *    o $params["debug"] - Whether to enable SMTP debug mode or not.
 *      Default is FALSE.
 *    o $params["persist"] - Indicates whether or not the SMTP connection
 *      should persist over multiple calls to the send() method.
 */
$GLOBALS['MAIL_SEND_PARAMS'] = NULL;

/*
 * Headers :
 */
$GLOBALS['MAIL_HEARDERS'] = [];

// Catch all sent emails
$GLOBALS['MAIL_CATCH_ALL'] = [];

/**
 * Email templates
 *
 * This addon offer ability to send email by using templates. Email templates are stored in
 * full-text files in configured directories (see $GLOBALS['MAIL_TEMPLATES_DIRECTORIES']). For each
 * template, you have to provide three files with the same name but with different extensions:
 * - template.subject: the email subject. Note: only the first line is used (and stripped)
 * - template.html: the HTML content of the email
 * - template.txt: the text content of the email
 * All these files will be used as Smarty templates and will be computed using variables provided
 * in the sending context. Note that the Smarty object used to compute the template is not the same
 * as the one used by LdapSaisie to display pages.
 *
 * Futhermore, this addon offer a view to list and edit existing template (see
 * $GLOBALS['MAIL_TEMPLATES_EDITOR_VIEW_ACCESS'] to configured access).
 */

// List of directory paths where as stored mail templates
// Notes:
// - provided path could be absolute or relative. Relative path are relative to the root base
//   sources LdapSaisie directory (commonly /usr/share/ldapsaisie or the src directory if you
//   installed it from sources). On Debian installation, you can specify 'local/email_templates' to
//   refer to /etc/ldapsaisie/local/email_templates directory/
// - Multiple directories could be specified, sorted so that the first ones take priority over
//   the last one.
// - To allow users to edit them using the editor view, these directories must be
//   writable by PHP process (commonly runed as www-data).
$GLOBALS['MAIL_TEMPLATES_DIRECTORIES'] = ['local/email_templates'];

// List of granted LSprofiles to access mail templates editor view
// WARNING: Sanitizing mail templates is hell... EXPOSE THIS VIEW ONLY TO TRUSTED USERS!
$GLOBALS['MAIL_TEMPLATES_EDITOR_VIEW_ACCESS'] = ['admin'];

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
