<?php
/*******************************************************************************
 * Copyright (C) 2007 Easter-eggs
 * https://ldapsaisie.org
 *
 * Author: See AUTHORS file in top-level directory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

******************************************************************************/

// Error messages
LSerror :: defineError('IMPERSONATE_01',
  ___("Impersonate: Failed to reconnect as %{name}.")
);

/**
 * Check support of impersonate addon by LdapSaisie
 *
 * @author Benjamin Renard <brenard@easter-eggs.com>
 *
 * @return boolean true if impersonate addon is totally supported, false in other case
 */
function LSaddon_impersonate_support() {
  return True;
}

function impersonate($object) {
  if (LSsession::changeAuthUser($object)) {
    LSsession::addInfo(getFData(
      _('Successfully reconnected as %{name}.'),
      $object->getDisplayName()
    ));
    LSurl::redirect('?LSsession_refresh');
    return True;
  }
  LSerror :: addErrorCode('IMPERSONATE_01', $object->getDisplayName());
  return False;
}

# vim: tabstop=2 shiftwidth=2 softtabstop=2 expandtab
