# LSattr_html_maildir

Ce type est utilisé pour la gestion des attributs dont la valeur est le chemin d'une maildir.
Typiquement, ce type attribut HTML est utile dans le cas de l'attribut *mailbox* utilisé par
maildrop pour stocker le chemin des boites mails. Ce type d'attribut offre la possibilité de gérér
un niveau de l'attribut et à travers les déclencheurs gérés par LdapSaisie la création, la
modification et ou la suppression de la boite mails.
Le [LSaddon](../../../LSaddon/index.md#configuration-des-lsaddons)
[maildir](../../../LSaddon/LSaddon_maildir.md#lsaddon_maildir) est utilisé pour manipuler la boite
mail à distance.

/// note
Actuellement, cet [LSaddon](../../../LSaddon/index.md#configuration-des-lsaddons) ne gérant que l'accès via FTP
au serveur distant, l'API d'accès via FTP est attaquée directement.
///

```
'html_options' => array (
  'LSform' => array (
    '[LSform1]' => [booléen],
    '[LSform2]' => [booléen],
    ...
  ),
  'remoteRootPathRegex' => "[Expression régulière pour matcher le dossier à créer]",
  'archiveNameFormat' => "[LSformat du chemin/nom du fichier une fois archiver]"
 ),
...
```

- `LSform`

  Tableau associatif obligatoire contenant en valeur clé le nom des [LSforms](../../LSform.md#lsform)
  dans lesquels la fonctionnalité de modification de la boite mail sera présente. Les valeurs
  attachées sont des booléens définissant si la modification est active par défaut.

- `remoteRootPathRegex`

  Expression régulière (compatible Perl) facultative dont le but est de *matcher* dans la valeur
  complète du chemin distant de la *maildir*, le chemin de la *maildir* à créer une fois connecté
  sur le serveur.

  Exemple : Si le chemin complet de la *maildir* est `/home/vmail/user`, mais que l'utilisateur FTP
  lorsqu'il se connecte arrive directement dans `/home/vmail`, et faut définir le paramètre
  `remoteRootPathRegex` de la manière suivante :

  ```
  /^\/home\/vmail\/([^\/]*)\/+$/
  ```

- `archiveNameFormat`

  [LSformat](../../../global/LSformat.md#format-parametrable) du nom du dossier de la *maildir* une
  fois archivée. Si ce format est défini, le dossier ne sera pas supprimé mais déplacé ou rénommé.
  Le format sera construit avec pour seul mot clé, le nom de l'ancien dossier. Exemple : Si le
  dossier de la maildir est `/home/vmail/user` et le paramètre `archiveNameFormat` vaut
  `%{old}.bckp`, le dossier sera renommé en `/home/vmail/user.bckp`.

  /// warning | Attention
  Ce format est interprété après application de la routine liée au paramètre
  `remoteRootPathRegex`. Ainsi, dans l'exemple précédent, si le paramètre `remoteRootPathRegex`
  tronquait uniquement le nom du dossier final, c'est à dire `user`, le format une fois
  interprété donnerai `user.bckp`.
  ///
