# zxcvbn

Cette règle vérifie la sécurité d'un mot de passe en utilisant la librairie
[ZxcvbnPhp](https://gitlab.easter-eggs.com/ee/zxcvbn-php). Cette librairie s'appuie sur un ensemble
de vérifications permettant de déterminer à quel point le mot de passe choisi est commun, prévisible
et plus globalement, estime en combien de temps il pourra être cassé par une personne malveillante.
Sur la base de l'analyse du mot de passe saisi, des conseils seront donnés à l'utilisateur pour le
guider dans le choix d'un mot de passe sûre.

/// warning | Attention
La librairie `ZxcvbnPhp` n'est compatible qu'avec PHP 7 et supérieur.
///

- `minScore`

  Le score minimal pour que le mot de passe soit accepté. Il doit s'agir d'un entier compris entre
  0 (le plus faible) et 4 (le plus sécurisé). Paramètre facultatif valant 4 par défaut.

- `minGuessesLog10`

  Permet de définir le logarithme en base 10 du nombre minimum estimé de tentative pour deviner le
  mot de passe. Par exemple, si `minGuessesLog10` est égal à 6, cela signifie que le mot de passe
  ne sera accepté que si `Zxcvbn` estime qu'il faut au moins 1 million (10^6) de tentatives pour le
  deviner. Paramètre facultatif valant 10 par défaut.

- `userDataAttrs`

  Liste d'attributs de l'objet dont les valeurs seront passées à la librairie `Zxcvbn` qui les
  considérera comme associés à l'utilisateur. Ainsi, par exemple, si l'utilisateur utilise son nom
  de famille ou encore son prénom dans son mot de passe, la librairie pourra lui indiqué que cela ne
  le protège que peut des attaques ciblées. Paramètre facultatif, mais il est fortement conseillé de
  renseigner un maximum d'attributs contenant des informations personnelles relatives à l'utilisteur.

- `banPersonalInfo`

  Booléen permettant d'interdire toutes utilisations d'informations personnelles dans le choix du mot
  de passe. Paramètre facultatif et vrai par défaut.

- `showWarning`

  Booléen définissant si les messages d'alertes retournés par la librairie `Zxcvbn` doivent être
  affichés à l'utilisateur. Paramètre facultatif et vrai par défaut.

- `showSuggestions`

  Booléen définissant si les messages de suggestions retournés par la librairie `Zxcvbn` doivent
  être affichés à l'utilisateur. Paramètre facultatif et vrai par défaut.

- `customDictionaries`

  Tableau associatif permettant de configurer des dictionnaires personnalisés : les clés contiennent
  le nom de la collection de dictionnaires et les valeurs associées, le chemin vers un fichier JSON
  contenant la collection de dictionnaires. Ces fichiers doivent contenir un objet racine dont les
   clés sont des chaînes de caractères correspondant au nom des dictionnaires et les valeurs
  associés sont des listes de mots __en minuscule__ triées par ordre décroissant de fréquence
  d'utilisation.

  Exemple:

  ```json
  {
    "dictionnaire1": ["mot1", "mot2"],
    "dictionnaire2": ["mot3", "mot4"]
  }
  ```

- `banDictionaries`

  Ce paramètre permet d'interdire tous mots issues de certains dictionnaires. Il s'agit d'un
  tableau devant contenir les noms des dictionaires interdits. La librairie `Zxcvbn` fournis
  les dictionnaires suivant :

  - `us_tv_and_film` : les mots les plus courrament utilisés dans les séries et films américains
  - `passwords` : les mot de passse les plus courrament utilisés
  - `male_names` : les prénoms masculins les plus courrant
  - `female_names` : les prénoms féminins les plus courrant
  - `surnames` : les nom de familles les plus courrant aux États Unis
  - `english_wikipedia` : les mots les plus courrament utilisés dans les articles en anglais de
    Wikipédia
  - `french_wikipedia` : les mots les plus courrament utilisés dans les articles en français de
    Wikipédia
  - `user_inputs` : les informations personnelles fournis lors de la validation du mot de passe

    __Note :__ lister ce dictionnaire dans se paramètre à le même effet que le paramètre
    `banPersonalInfo` documenté ci-dessus.

  Vous pouvez également lister ici tout dictionnaires personnalisés que vous auriez ajouté grâce
  au paramètre `customDictionaries`.

- `skipBanDictionariesMinGuessesLog10`

  Permet de définir le seuil minimal du `guesses_log10` retourné par Zxcvbn à partir duquel on
  ignore le test des dictionnaires interdits (voir `banDictionaries`, par defaut : `20`).

- `skipBanDictionariesMinLength`

  Permet de définir le seuil minimal de la longueur du mot de passe à partir duquel on ignore
  le test des dictionnaires interdits (voir `banDictionaries`, par defaut : `25`).

- `zxcvbn_autoload_path`

  Le chemin vers le fichier de chargement automatique des classes de la librairie *ZxcvbnPhp*. Ce
  paramètre est facultatif et vaut par défaut `Zxcvbn/autoload.php`, ce qui est adapté si vous
  utiliser le paquet Debian `php-zxcvbn` disponible sur le dépôt Debian du projet LdapSaisie.
