# Configuration LSobject

Cette partie décrit la manière de configurer les différents types de LSobjets manipulés par
LdapSaisie.

La configuration des LSobjects est stockée dans le dossier `/conf/LSobjects`. Dans ce dossier, on
retrouve un fichier par type d'LSobject, nommé de la manière suivante :

```
config.LSobjects.[nom du type d'LSobject].php
```

Ce fichier contient la déclaration de la configuration du type d'LSobject qui est stocké dans la
variable globale `$GLOBALS['LSobjects']['[nom du type d'LSobject]']`.

```php
$GLOBALS['LSobjects']['[nom du type d'LSobject]'] = array (
  'objectclass' => array(
    'objetclass1',
    'objetclass2',
    ...
  ),
  'filter' => '[filtre LDAP]',

  'rdn' => 'attr1',

  'LSaddons' => [LSaddon(s)],

  'container_dn' => 'ou=people',
  'generate_container_dn' => '[callable]',
  'container_auto_create' => array(
    // Information des configurations pour la création du conteneur du type d'LSobjet
    // lors de la création nouveau subDn
  ),

  'disable_creation' => [boolean]',

  'before_modify' => 'function1',
  'after_modify' => 'function2',
  'after_create' => 'function3',
  'after_delete' => 'function4',

  'label' => 'objet1',
  'display_name_format' => '[format]',
  'displayAttrName' => '[booleen]',

  //Custom Actions
  'customActions' => array (
    // Configuration des customActions pour ce type d'objet
  ),

  // LSrelation
  'LSrelation' => array(
    // Configuration des LSrelations entre ce type d'objet et les autres
  ),

  // LSform
  'LSform' => array (
    // Configuration des formulaires de l'objet
  ), // fin LSform

  // LSsearch
  'LSsearch' => array (
    // Configuration des recherches de l'objet
  ), // fin LSsearch

  'globalSearch' => [booleen],
  'globalSearch_extraDisplayedColumns' => [booleen],

  // ioFormat
  'ioFormat' => array (
    // Configuration des formats d'import/export de l'objet
  ),

  // Attributs
  'attrs' => array (
    // Configuration des attributs du type d'LSobjet
  )
);
...
```

- `objectclass`

  La liste des *objectclass* des objets.

- `filter`

  Filtre de recherche LDAP applicable à tout les objets de ce type et qui sera utilisé lors de
  chaque recherche de ce type d'objet.

- `rdn`

  Nom de l'attribut correspondant au *RDN* des objets LDAP.

- `LSaddons`

  LSaddon(s) dont le type d'objet dépend. Ce peut être un tableau de chaînes de caractères ou une
  simpe chaîne de caractères correspondant au(x) nom(s) du/des LSaddon(s) en dépendance.

- `container_dn`

  Elément pour construire le *basedn* de stockage de ce type d'objet. Par exemple, si le *basedn* de
  l'annuaire est `o=ls` et que les objets *utilisateurs* sont stockés dans la branche de l'annuaire
  `ou=people,o=ls`, alors `container_dn` devra valoir `ou=people`.

  Lorsque l'annuaire possède des [subDn](../global/ldap/subDn.md#sous-niveaux-de-connexion), les
  objets seront cherchés dans le *basedn* résultant de la concaténation du paramètre `container_dn`,
  d'une virgule et du *basedn* correspondant au
  [subDn](../global/ldap/subDn.md#sous-niveaux-de-connexion) courant.

- `generate_container_dn`

  *Callable* (au sens PHP), utilisé pour générer la valeur du paramètre `container_dn`
  dynamiquement. Ce *callable* prend en paramètre l'objet LSobject à
  créer et retourne la valeur du paramètre `container_dn`.

- `container_auto_create`

  Tableau associatif contenant les paramètres de configuration nécessaires à la création des
  `container_dn` dans les nouveaux objets utilisés comme
  [subDn](../global/ldap/subDn.md#sous-niveaux-de-connexion).
  [Voir la section concernée](container_auto_create.md#creation-automatique-du-conteneur-des-lsobjets-dans-un-subdn).

- `disable_creation`

  Booléen permetant de desactiver la creation de ce type d'objet de manière globale.

- `before_modify`

  Chaîne de caractères (ou tableau de chaine de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées avant la modification d'un objet.
  [Voir la section concernée](triggers.md#declencheurs_1).

- `after_modify`

  Chaîne de caractères (ou tableau de chaine de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées après la modification d'un objet.
  [Voir la section concernée](triggers.md#declencheurs_1).

- `after_create`

  Chaîne de caractères (ou tableau de chaine de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées après la création d'un objet.
  [Voir la section concernée](triggers.md#declencheurs_1).

- `after_delete`

  Chaîne de caractères (ou tableau de chaine de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées après la suppression d'un objet.
  [Voir la section concernée](triggers.md#declencheurs_1).

- `label`

  Nom générique au pluriel qualifiant le type d'objet. Exemple : *Utilisateurs*.

- `display_name_format`

  [Format paramètrable](../global/LSformat.md#format-parametrable) du nom des objets composés à
  partir des valeurs d'affichage des attributs de l'objet.

- `displayAttrName`

  Booléen définissant si le nom des attributs doit être affiché en préfixe de leur message d'aide
  (paramètre `help_info`).

- `customActions`

  Tableau associatif contenant les paramètres de configuration des
  [customActions](customActions.md#customactions).
  [Voir la section concernée](customActions.md#customactions).

- `LSrelation`

  Tableau associatif contenant les paramètres de configuration des
  [LSrelations](LSrelation.md#lsrelation). [Voir la section concernée](LSrelation.md#lsrelation).

- `LSform`

  Tableau associatif contenant les paramètres de configuration des [LSforms](LSform.md#lsform) des
  LSobjects. [Voir la section concernée](LSform.md#lsform).

- `LSsearch`

  Tableau associatif contenant les paramètres de configuration des recherches de
  LSobject de ce type dans l'annuaire.
  [Voir la section concernée](LSsearch.md#lssearch).

- `globalSearch`

  Inclure ou non ce type d'objet dans le résultat des recherches globales (Par défaut : `True`).

- `globalSearch_extraDisplayedColumns`

  Afficher ou non les colonnes supplémentaires pour ce type d'objet dans le résultat des recherches
  globales (Par défaut : `True`). Pour plus de détails les colonnes supplémentaires,
  [voir la section dédiée](LSsearch.md#lssearch).

- `ioFormat`

  Tableau associatif contenant les paramètres de configuration des formats de fichiers
  d'import/export de ce type d'LSobject.
  [Voir la section concernée](ioFormat.md#ioformat).

- `attrs`

  Tableau associatif contenant les paramètres de configuration des attributs des objets.
  [Voir la section concernée](LSattribute/index.md#configuration-des-attributs).
