# Configuration des attributs

Cette section décrit les options de configuration des attributs des
[LSobjects](../index.md#configuration-lsobject). Les attributs sont définis dans le tableau
associatif `attrs` de la configuration des [LSobjects](../index.md#configuration-lsobject). Dans ce
tableau, les clé les noms des attributs et les valeurs liés sont la configuration des attributs.

!!! warning

    Contrairement à ce qui existe dans le standard LDAP, les noms des attributs sont sensibles à la
    casse. Il faut que le nom des attributs dans LdapSaisie soient scrupuleusement les mêmes que
    ceux retourné par [Net_LDAP2](http://pear.php.net/package/Net_LDAP2)

```
'attrs' => array (
  /* ----------- start -----------*/
  'attr1' => array (
    'label' => '[label de l'attr1',
    'displayAttrName' => '[booleen]',
    'help_info' => '[Message d'aide sur l'attribut attr1]',
    'help_info_in_view' => '[booleen]',
    'ldap_type' => 'ldaptype1',
    'ldap_options' => array(
      // Options LDAP liées au type LDAP de l'attribut
    ),
    'html_type' => 'htmltype1',
    'html_options' => array(
      // Options HTML liées au type HTML de l'attribut
    ),
    'no_value_label' => '[No set value label]',
    'multiple' => 0,
    'required' => 1,
    'generate_function' => 'fonction1',
    'generate_value_format' => '[LSformat]',
    'default_value' => 'valeur1',
    'check_data' => array (
      // Régle de vérification syntaxique des données saisies
    ),
    'validation' => array (
      // Règle de vérification d'intégrité des données saisies
    ),
    'rights' => array(
      'LSprofile1' => 'droit1',
      'LSprofile2' => 'droit2',
      ...
    ),
    'view' => 1,
    'form' => array (
      'create' => 1,
      'modify' => 0,
      ...
    ),
    'dependAttrs' => array(
      // Attributs en dépendance
    ),
    'onDisplay' => 'fonction2'

    'before_modify' => 'function1',
    'after_modify' => 'function2'
  ),
  /* ----------- end -----------*/
  ...
);
...
```

- `label`

  Le label de l'attribut.

- `displayAttrName`

  Booléen définissant si le nom de l'attribut doit être affiché en préfixe du message d'aide
  (paramètre `help_info`).

- `help_info`

  Message d'aide qui sera affiché dans une bulle d'aide à côté du nom de l'attribut dans les
  formulaires.

- `help_info_in_view`

  Booléen définissant si le message d'aide doit être affiché sur la vue de visualisation de l'objet.

  Valeurs possibles : *0* ou *1*

  Valeur par défaut : *0*

- `ldap_type`

  Le type LDAP de l'attribut (facultatif, par défaut:
  [LSattr_ldap_ascii](LSattr_ldap/LSattr_ldap_ascii.md#lsattr_ldap_ascii)).
  [Voir la section concernée.](LSattr_ldap/index.md#configuration-des-attributs-ldap)

- `ldap_options`

  Tableau associatif contenant les paramètres de configuration du type LDAP de l'attribut.
  [Voir la section concernée.](LSattr_ldap/index.md#configuration-des-attributs-ldap)

- `html_type`

  Le type HTML de l'attribut (facultatif, par défaut:
    [LSattr_html_text](LSattr_html/LSattr_html_text.md#lsattr_html_text)).
  [Voir la section concernée.](LSattr_html/index.md#configuration-des-attributs-html)

- `html_options`

  Tableau associatif contenant les paramètres de configuration du type HTML de l'attribut.
  [Voir la section concernée.](LSattr_html/index.md#configuration-des-attributs-html)

- `no_value_label`

  Label affiché lorsque l'attribut n'a pas de valeur (facultatif).

- `multiple`

  Booléen définissant si cet attribut peut stocker plusieurs valeurs.

  Valeurs possibles : *0* ou *1*

  Valeur par défaut : *0*

- `required`

  Booléen définissant si cet attribut doit obligatoirement être défini.

  Valeurs possibles : *0* ou *1*

  Valeur par défaut : *0*

- `generate_function`

  Nom de la fonction permettant de générer la valeur de l'attribut. Cette fonction sera éxecutée, en
  passant en premier paramètre, l'objet [LSobject](../index.md#configuration-lsobject) courant.

- `generate_value_format`

  [LSformat](../../global/LSformat.md#format-parametrable) permettant la génération de l'attribut.

  !!! note

      Cette méthode de génération est utilisée uniquement si aucune fonction de génération de la
      valeur n'est définie (paramètre `generate_function`).

- `default_value`

  Valeur par défaut de l'attribut.

  !!! warning

      Il doit s'agir de la valeur telque retournée par le formulaire web. Ainsi, par exemple dans le
      cas d'un attribut booléen, les valeurs possibles sont `yes` ou `no`.

  !!! note

      Cette valeur est également utilisée dans le cadre de la génération automatique de la valeur de
      l'attribut si aucune autre méthode n'est disponible (via une fonction ou un
      [LSformat](../../global/LSformat.md#format-parametrable)).

- `check_data`

  Tableau associatif contenant les règles de vérification syntaxique des données de l'attribut.
  [Voir la section concernée.](check_data/index.md#configuration-des-regles-de-verification-syntaxique)

- `validation`

  Tableau associatif contenant les règles de vérification d'intégrité des données de l'attribut.
  [Voir la section concernée.](validation.md#configuration-des-regles-de-verification-dintegrite)

- `rights`

  Tableau associatif dont les clés sont les noms des
  [LSprofiles](../../global/ldap/LSprofile.md#profils-dutilisateurs) ayant des droits sur cet
  attribut et les valeurs associées sont les droits correspondants. La valeur des droits d'un
  [LSprofile](../../global/ldap/LSprofile.md#profils-dutilisateurs) peut être `r` pour le droit de
  lecture ou `w` pour le droit de lecture-écriture. Par défaut, un
  [LSprofile](../../global/ldap/LSprofile.md#profils-dutilisateurs) n'a aucun droit.

- `view`

  Booléen définissant si l'attribut est, ou non, affiché lors de la visualisation des objets du type
  courant.

  Valeurs possibles : *0* ou *1*

  Valeur par défaut : *0*

- `form`

  Tableau associatif dont les clés sont les noms des [LSforms](../LSform.md#lsform) et les valeurs
  associées la définition de l'affichage dans ce [LSform](../LSform.md#lsform). Si cette valeur vaut
  `0`, alors l'attribut sera lecture-seule et si cette valeur vaut `1`, cet attribut sera affiché
  en lecture-écriture.

- `dependAttrs`

  Tableau associatif listant les attributs dépendants de celui-ci. Les attributs listés ici seront
  regénérés lors de chaque modification de l'attribut courant. Cette génération sera effectuée avec
  la fonction définie dans le paramètre `generate_function` de l'attribut.

- `onDisplay`

  Nom ou liste de nom des fonctions retournant les valeurs d'affichages de l'attribut. Si c'est une
  liste, chacune des fonctions seront executée les unes après les autres. Ces fonctions seront
  éxecutées, en passant en premier paramètre, le tableau des valeurs de l'objet.

- `before_modify`

  Chaîne de caractères (ou tableau de chaine de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées avant toutes modifications de la valeur de l'attribut.
  [Voir la section concernée](triggers.md#declencheurs)

- `after_modify`

  Chaîne de caractères (ou tableau de chaine de caractères) correspondant au nom d'une ou plusieurs
  fonctions qui seront exécutées après toutes modifications de la valeur de l'attribut.
  [Voir la section concernée](triggers.md#declencheurs)
